@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.alicloud.ots.TableArgs.builder
import com.pulumi.alicloud.ots.kotlin.inputs.TableDefinedColumnArgs
import com.pulumi.alicloud.ots.kotlin.inputs.TableDefinedColumnArgsBuilder
import com.pulumi.alicloud.ots.kotlin.inputs.TablePrimaryKeyArgs
import com.pulumi.alicloud.ots.kotlin.inputs.TablePrimaryKeyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an OTS table resource.
 * > **NOTE:** From Provider version 1.10.0, the provider field 'ots_instance_name' has been deprecated and
 * you should use resource alicloud_ots_table's new field 'instance_name' and 'table_name' to re-import this resource.
 * > **NOTE:** Available since v1.9.2.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     description: name,
 *     accessedBy: "Any",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultTable = new alicloud.ots.Table("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: "tf_example",
 *     timeToLive: -1,
 *     maxVersion: 1,
 *     enableSse: true,
 *     sseKeyType: "SSE_KMS_SERVICE",
 *     primaryKeys: [
 *         {
 *             name: "pk1",
 *             type: "Integer",
 *         },
 *         {
 *             name: "pk2",
 *             type: "String",
 *         },
 *         {
 *             name: "pk3",
 *             type: "Binary",
 *         },
 *     ],
 *     definedColumns: [
 *         {
 *             name: "col1",
 *             type: "Integer",
 *         },
 *         {
 *             name: "col2",
 *             type: "String",
 *         },
 *         {
 *             name: "col3",
 *             type: "Binary",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     description=name,
 *     accessed_by="Any",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_table = alicloud.ots.Table("default",
 *     instance_name=default_instance.name,
 *     table_name="tf_example",
 *     time_to_live=-1,
 *     max_version=1,
 *     enable_sse=True,
 *     sse_key_type="SSE_KMS_SERVICE",
 *     primary_keys=[
 *         {
 *             "name": "pk1",
 *             "type": "Integer",
 *         },
 *         {
 *             "name": "pk2",
 *             "type": "String",
 *         },
 *         {
 *             "name": "pk3",
 *             "type": "Binary",
 *         },
 *     ],
 *     defined_columns=[
 *         {
 *             "name": "col1",
 *             "type": "Integer",
 *         },
 *         {
 *             "name": "col2",
 *             "type": "String",
 *         },
 *         {
 *             "name": "col3",
 *             "type": "Binary",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Description = name,
 *         AccessedBy = "Any",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultTable = new AliCloud.Ots.Table("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = "tf_example",
 *         TimeToLive = -1,
 *         MaxVersion = 1,
 *         EnableSse = true,
 *         SseKeyType = "SSE_KMS_SERVICE",
 *         PrimaryKeys = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk1",
 *                 Type = "Integer",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk2",
 *                 Type = "String",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk3",
 *                 Type = "Binary",
 *             },
 *         },
 *         DefinedColumns = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TableDefinedColumnArgs
 *             {
 *                 Name = "col1",
 *                 Type = "Integer",
 *             },
 *             new AliCloud.Ots.Inputs.TableDefinedColumnArgs
 *             {
 *                 Name = "col2",
 *                 Type = "String",
 *             },
 *             new AliCloud.Ots.Inputs.TableDefinedColumnArgs
 *             {
 *                 Name = "col3",
 *                 Type = "Binary",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String(name),
 * 			AccessedBy:  pulumi.String("Any"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ots.NewTable(ctx, "default", &ots.TableArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    pulumi.String("tf_example"),
 * 			TimeToLive:   int(-1),
 * 			MaxVersion:   pulumi.Int(1),
 * 			EnableSse:    pulumi.Bool(true),
 * 			SseKeyType:   pulumi.String("SSE_KMS_SERVICE"),
 * 			PrimaryKeys: ots.TablePrimaryKeyArray{
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk2"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk3"),
 * 					Type: pulumi.String("Binary"),
 * 				},
 * 			},
 * 			DefinedColumns: ots.TableDefinedColumnArray{
 * 				&ots.TableDefinedColumnArgs{
 * 					Name: pulumi.String("col1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 				&ots.TableDefinedColumnArgs{
 * 					Name: pulumi.String("col2"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				&ots.TableDefinedColumnArgs{
 * 					Name: pulumi.String("col3"),
 * 					Type: pulumi.String("Binary"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       description: ${name}
 *       accessedBy: Any
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultTable:
 *     type: alicloud:ots:Table
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: tf_example
 *       timeToLive: -1
 *       maxVersion: 1
 *       enableSse: true
 *       sseKeyType: SSE_KMS_SERVICE
 *       primaryKeys:
 *         - name: pk1
 *           type: Integer
 *         - name: pk2
 *           type: String
 *         - name: pk3
 *           type: Binary
 *       definedColumns:
 *         - name: col1
 *           type: Integer
 *         - name: col2
 *           type: String
 *         - name: col3
 *           type: Binary
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OTS table can be imported using id, e.g.
 * ```sh
 * $ pulumi import alicloud:ots/table:Table table my-ots:ots_table
 * ```
 * @property allowUpdate Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
 * @property definedColumns The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
 * @property deviationCellVersionInSec The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
 * @property enableSse Whether enable OTS server side encryption. Default value is false.
 * @property instanceName The name of the OTS instance in which table will located.
 * @property maxVersion The maximum number of versions stored in this table. The valid value is 1-2147483647.
 * @property primaryKeys The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
 * @property sseKeyId . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
 * @property sseKeyType The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
 * @property sseRoleArn The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
 * @property tableName The table name of the OTS instance. If changed, a new table would be created.
 * @property timeToLive The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
 */
public data class TableArgs(
    public val allowUpdate: Output<Boolean>? = null,
    public val definedColumns: Output<List<TableDefinedColumnArgs>>? = null,
    public val deviationCellVersionInSec: Output<String>? = null,
    public val enableSse: Output<Boolean>? = null,
    public val instanceName: Output<String>? = null,
    public val maxVersion: Output<Int>? = null,
    public val primaryKeys: Output<List<TablePrimaryKeyArgs>>? = null,
    public val sseKeyId: Output<String>? = null,
    public val sseKeyType: Output<String>? = null,
    public val sseRoleArn: Output<String>? = null,
    public val tableName: Output<String>? = null,
    public val timeToLive: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.TableArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.TableArgs =
        com.pulumi.alicloud.ots.TableArgs.builder()
            .allowUpdate(allowUpdate?.applyValue({ args0 -> args0 }))
            .definedColumns(
                definedColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deviationCellVersionInSec(deviationCellVersionInSec?.applyValue({ args0 -> args0 }))
            .enableSse(enableSse?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .maxVersion(maxVersion?.applyValue({ args0 -> args0 }))
            .primaryKeys(
                primaryKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sseKeyId(sseKeyId?.applyValue({ args0 -> args0 }))
            .sseKeyType(sseKeyType?.applyValue({ args0 -> args0 }))
            .sseRoleArn(sseRoleArn?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .timeToLive(timeToLive?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableArgs].
 */
@PulumiTagMarker
public class TableArgsBuilder internal constructor() {
    private var allowUpdate: Output<Boolean>? = null

    private var definedColumns: Output<List<TableDefinedColumnArgs>>? = null

    private var deviationCellVersionInSec: Output<String>? = null

    private var enableSse: Output<Boolean>? = null

    private var instanceName: Output<String>? = null

    private var maxVersion: Output<Int>? = null

    private var primaryKeys: Output<List<TablePrimaryKeyArgs>>? = null

    private var sseKeyId: Output<String>? = null

    private var sseKeyType: Output<String>? = null

    private var sseRoleArn: Output<String>? = null

    private var tableName: Output<String>? = null

    private var timeToLive: Output<Int>? = null

    /**
     * @param value Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
     */
    @JvmName("udkgxeomyqjmoesg")
    public suspend fun allowUpdate(`value`: Output<Boolean>) {
        this.allowUpdate = value
    }

    /**
     * @param value The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
     */
    @JvmName("hdxpqmmlqbjiqgli")
    public suspend fun definedColumns(`value`: Output<List<TableDefinedColumnArgs>>) {
        this.definedColumns = value
    }

    @JvmName("fswqjiglwohnvssp")
    public suspend fun definedColumns(vararg values: Output<TableDefinedColumnArgs>) {
        this.definedColumns = Output.all(values.asList())
    }

    /**
     * @param values The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
     */
    @JvmName("oqxobpdjwrviniab")
    public suspend fun definedColumns(values: List<Output<TableDefinedColumnArgs>>) {
        this.definedColumns = Output.all(values)
    }

    /**
     * @param value The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
     */
    @JvmName("wkpqnqosimpbsuks")
    public suspend fun deviationCellVersionInSec(`value`: Output<String>) {
        this.deviationCellVersionInSec = value
    }

    /**
     * @param value Whether enable OTS server side encryption. Default value is false.
     */
    @JvmName("qoelamddmpvxiatt")
    public suspend fun enableSse(`value`: Output<Boolean>) {
        this.enableSse = value
    }

    /**
     * @param value The name of the OTS instance in which table will located.
     */
    @JvmName("vamdckhwddrhooyt")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The maximum number of versions stored in this table. The valid value is 1-2147483647.
     */
    @JvmName("nviqdaekfdplcsig")
    public suspend fun maxVersion(`value`: Output<Int>) {
        this.maxVersion = value
    }

    /**
     * @param value The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
     */
    @JvmName("soimhckbhafjaqlc")
    public suspend fun primaryKeys(`value`: Output<List<TablePrimaryKeyArgs>>) {
        this.primaryKeys = value
    }

    @JvmName("mqbgvsbftkkwaffj")
    public suspend fun primaryKeys(vararg values: Output<TablePrimaryKeyArgs>) {
        this.primaryKeys = Output.all(values.asList())
    }

    /**
     * @param values The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
     */
    @JvmName("fkcuyqjpqfwrxatq")
    public suspend fun primaryKeys(values: List<Output<TablePrimaryKeyArgs>>) {
        this.primaryKeys = Output.all(values)
    }

    /**
     * @param value . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
     */
    @JvmName("xwoylkwpqqowppyu")
    public suspend fun sseKeyId(`value`: Output<String>) {
        this.sseKeyId = value
    }

    /**
     * @param value The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
     */
    @JvmName("qkiblfxenmswoxtj")
    public suspend fun sseKeyType(`value`: Output<String>) {
        this.sseKeyType = value
    }

    /**
     * @param value The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
     */
    @JvmName("pncpesdoovyvajqi")
    public suspend fun sseRoleArn(`value`: Output<String>) {
        this.sseRoleArn = value
    }

    /**
     * @param value The table name of the OTS instance. If changed, a new table would be created.
     */
    @JvmName("yxqhpkmcpymeqegi")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
     */
    @JvmName("omshcrkdbqfqxbtf")
    public suspend fun timeToLive(`value`: Output<Int>) {
        this.timeToLive = value
    }

    /**
     * @param value Whether allow data update operations. Default value is true. Skipping the resource state refresh step may result in unnecessary execution plan when upgrading from an earlier version.
     */
    @JvmName("qxsyuefimnnbkhnb")
    public suspend fun allowUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowUpdate = mapped
    }

    /**
     * @param value The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
     */
    @JvmName("botknghqouqibpxp")
    public suspend fun definedColumns(`value`: List<TableDefinedColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definedColumns = mapped
    }

    /**
     * @param argument The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
     */
    @JvmName("jleitkqkkrocjscw")
    public suspend fun definedColumns(argument: List<suspend TableDefinedColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableDefinedColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.definedColumns = mapped
    }

    /**
     * @param argument The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
     */
    @JvmName("kbobeedcjnpmdrbf")
    public suspend fun definedColumns(vararg argument: suspend TableDefinedColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TableDefinedColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.definedColumns = mapped
    }

    /**
     * @param argument The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
     */
    @JvmName("osssslrbfhvkqokm")
    public suspend fun definedColumns(argument: suspend TableDefinedColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TableDefinedColumnArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.definedColumns = mapped
    }

    /**
     * @param values The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of defined column. The number of `defined_column` should not be more than 32. See `defined_column` below.
     */
    @JvmName("oditauodpbkkdkre")
    public suspend fun definedColumns(vararg values: TableDefinedColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definedColumns = mapped
    }

    /**
     * @param value The max version offset of the table. The valid value is 1-9223372036854775807. Defaults to 86400.
     */
    @JvmName("gocvpwwawhxdrgjf")
    public suspend fun deviationCellVersionInSec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviationCellVersionInSec = mapped
    }

    /**
     * @param value Whether enable OTS server side encryption. Default value is false.
     */
    @JvmName("eaqoupjfimkmphig")
    public suspend fun enableSse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSse = mapped
    }

    /**
     * @param value The name of the OTS instance in which table will located.
     */
    @JvmName("iqtupbggqlhaginm")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The maximum number of versions stored in this table. The valid value is 1-2147483647.
     */
    @JvmName("yjggbqegdhjskskn")
    public suspend fun maxVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxVersion = mapped
    }

    /**
     * @param value The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
     */
    @JvmName("kkrdlujsgyeocdaa")
    public suspend fun primaryKeys(`value`: List<TablePrimaryKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKeys = mapped
    }

    /**
     * @param argument The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
     */
    @JvmName("alicscbjlfupnwiw")
    public suspend fun primaryKeys(argument: List<suspend TablePrimaryKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TablePrimaryKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.primaryKeys = mapped
    }

    /**
     * @param argument The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
     */
    @JvmName("fqwvtdohvkiohmft")
    public suspend fun primaryKeys(vararg argument: suspend TablePrimaryKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TablePrimaryKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.primaryKeys = mapped
    }

    /**
     * @param argument The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
     */
    @JvmName("foixmppgsohxoryx")
    public suspend fun primaryKeys(argument: suspend TablePrimaryKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TablePrimaryKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.primaryKeys = mapped
    }

    /**
     * @param values The property of `TableMeta` which indicates the structure information of a table. It describes the attribute value of primary key. The number of `primary_key` should not be less than one and not be more than four. See `primary_key` below.
     */
    @JvmName("uhmrbmalgmqwjohe")
    public suspend fun primaryKeys(vararg values: TablePrimaryKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryKeys = mapped
    }

    /**
     * @param value . The key ID of secret. `sse_key_id` is valid only when `sse_key_type` is set to `SSE_BYOK`.
     */
    @JvmName("wokraxwankunwpfc")
    public suspend fun sseKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKeyId = mapped
    }

    /**
     * @param value The key type of OTS server side encryption. `SSE_KMS_SERVICE`, `SSE_BYOK` is allowed.
     */
    @JvmName("acloonhjucffqahm")
    public suspend fun sseKeyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKeyType = mapped
    }

    /**
     * @param value The arn of role that can access kms service. `sse_role_arn` is valid only when `sse_key_type` is set to `SSE_BYOK`.
     */
    @JvmName("lteqhkhsfacewrby")
    public suspend fun sseRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseRoleArn = mapped
    }

    /**
     * @param value The table name of the OTS instance. If changed, a new table would be created.
     */
    @JvmName("ogrlsoaqwvbavixk")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The retention time of data stored in this table (unit: second). The value maximum is 2147483647 and -1 means never expired.
     */
    @JvmName("myqxatjtkwiujsdt")
    public suspend fun timeToLive(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToLive = mapped
    }

    internal fun build(): TableArgs = TableArgs(
        allowUpdate = allowUpdate,
        definedColumns = definedColumns,
        deviationCellVersionInSec = deviationCellVersionInSec,
        enableSse = enableSse,
        instanceName = instanceName,
        maxVersion = maxVersion,
        primaryKeys = primaryKeys,
        sseKeyId = sseKeyId,
        sseKeyType = sseKeyType,
        sseRoleArn = sseRoleArn,
        tableName = tableName,
        timeToLive = timeToLive,
    )
}
