@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.alicloud.ots.kotlin.outputs.TunnelChannel
import com.pulumi.alicloud.ots.kotlin.outputs.TunnelChannel.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Tunnel].
 */
@PulumiTagMarker
public class TunnelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TunnelArgs = TunnelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TunnelArgsBuilder.() -> Unit) {
        val builder = TunnelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Tunnel {
        val builtJavaResource = com.pulumi.alicloud.ots.Tunnel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Tunnel(builtJavaResource)
    }
}

/**
 * Provides an OTS tunnel resource.
 * For information about OTS tunnel and how to use it, see [Tunnel overview](https://www.alibabacloud.com/help/en/tablestore/latest/tunnel-service-overview).
 * > **NOTE:** Available since v1.172.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     description: name,
 *     accessedBy: "Any",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultTable = new alicloud.ots.Table("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: "tf_example",
 *     timeToLive: -1,
 *     maxVersion: 1,
 *     enableSse: true,
 *     sseKeyType: "SSE_KMS_SERVICE",
 *     primaryKeys: [
 *         {
 *             name: "pk1",
 *             type: "Integer",
 *         },
 *         {
 *             name: "pk2",
 *             type: "String",
 *         },
 *         {
 *             name: "pk3",
 *             type: "Binary",
 *         },
 *     ],
 * });
 * const defaultTunnel = new alicloud.ots.Tunnel("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: defaultTable.tableName,
 *     tunnelName: "tf_example",
 *     tunnelType: "BaseAndStream",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     description=name,
 *     accessed_by="Any",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_table = alicloud.ots.Table("default",
 *     instance_name=default_instance.name,
 *     table_name="tf_example",
 *     time_to_live=-1,
 *     max_version=1,
 *     enable_sse=True,
 *     sse_key_type="SSE_KMS_SERVICE",
 *     primary_keys=[
 *         {
 *             "name": "pk1",
 *             "type": "Integer",
 *         },
 *         {
 *             "name": "pk2",
 *             "type": "String",
 *         },
 *         {
 *             "name": "pk3",
 *             "type": "Binary",
 *         },
 *     ])
 * default_tunnel = alicloud.ots.Tunnel("default",
 *     instance_name=default_instance.name,
 *     table_name=default_table.table_name,
 *     tunnel_name="tf_example",
 *     tunnel_type="BaseAndStream")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Description = name,
 *         AccessedBy = "Any",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultTable = new AliCloud.Ots.Table("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = "tf_example",
 *         TimeToLive = -1,
 *         MaxVersion = 1,
 *         EnableSse = true,
 *         SseKeyType = "SSE_KMS_SERVICE",
 *         PrimaryKeys = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk1",
 *                 Type = "Integer",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk2",
 *                 Type = "String",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk3",
 *                 Type = "Binary",
 *             },
 *         },
 *     });
 *     var defaultTunnel = new AliCloud.Ots.Tunnel("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = defaultTable.TableName,
 *         TunnelName = "tf_example",
 *         TunnelType = "BaseAndStream",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String(name),
 * 			AccessedBy:  pulumi.String("Any"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTable, err := ots.NewTable(ctx, "default", &ots.TableArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    pulumi.String("tf_example"),
 * 			TimeToLive:   int(-1),
 * 			MaxVersion:   pulumi.Int(1),
 * 			EnableSse:    pulumi.Bool(true),
 * 			SseKeyType:   pulumi.String("SSE_KMS_SERVICE"),
 * 			PrimaryKeys: ots.TablePrimaryKeyArray{
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk2"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk3"),
 * 					Type: pulumi.String("Binary"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ots.NewTunnel(ctx, "default", &ots.TunnelArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    defaultTable.TableName,
 * 			TunnelName:   pulumi.String("tf_example"),
 * 			TunnelType:   pulumi.String("BaseAndStream"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       description: ${name}
 *       accessedBy: Any
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultTable:
 *     type: alicloud:ots:Table
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: tf_example
 *       timeToLive: -1
 *       maxVersion: 1
 *       enableSse: true
 *       sseKeyType: SSE_KMS_SERVICE
 *       primaryKeys:
 *         - name: pk1
 *           type: Integer
 *         - name: pk2
 *           type: String
 *         - name: pk3
 *           type: Binary
 *   defaultTunnel:
 *     type: alicloud:ots:Tunnel
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: ${defaultTable.tableName}
 *       tunnelName: tf_example
 *       tunnelType: BaseAndStream
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OTS tunnel can be imported using id, e.g.
 * ```sh
 * $ pulumi import alicloud:ots/tunnel:Tunnel foo <instance_name>:<table_name>:<tunnel_name>
 * ```
 */
public class Tunnel internal constructor(
    override val javaResource: com.pulumi.alicloud.ots.Tunnel,
) : KotlinCustomResource(javaResource, TunnelMapper) {
    /**
     * The channels of OTS tunnel. Each element contains the following attributes:
     */
    public val channels: Output<List<TunnelChannel>>
        get() = javaResource.channels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The creation time of the Tunnel.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether the tunnel has expired.
     */
    public val expired: Output<Boolean>
        get() = javaResource.expired().applyValue({ args0 -> args0 })

    /**
     * The name of the OTS instance in which table will located.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The name of the OTS table. If changed, a new table would be created.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * The tunnel id of the OTS which could not be changed.
     */
    public val tunnelId: Output<String>
        get() = javaResource.tunnelId().applyValue({ args0 -> args0 })

    /**
     * The name of the OTS tunnel. If changed, a new tunnel would be created.
     */
    public val tunnelName: Output<String>
        get() = javaResource.tunnelName().applyValue({ args0 -> args0 })

    /**
     * The latest consumption time of the tunnel, unix time in nanosecond.
     */
    public val tunnelRpo: Output<Int>
        get() = javaResource.tunnelRpo().applyValue({ args0 -> args0 })

    /**
     * The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
     */
    public val tunnelStage: Output<String>
        get() = javaResource.tunnelStage().applyValue({ args0 -> args0 })

    /**
     * The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
     */
    public val tunnelType: Output<String>
        get() = javaResource.tunnelType().applyValue({ args0 -> args0 })
}

public object TunnelMapper : ResourceMapper<Tunnel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ots.Tunnel::class == javaResource::class

    override fun map(javaResource: Resource): Tunnel = Tunnel(
        javaResource as
            com.pulumi.alicloud.ots.Tunnel,
    )
}

/**
 * @see [Tunnel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Tunnel].
 */
public suspend fun tunnel(name: String, block: suspend TunnelResourceBuilder.() -> Unit): Tunnel {
    val builder = TunnelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Tunnel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tunnel(name: String): Tunnel {
    val builder = TunnelResourceBuilder()
    builder.name(name)
    return builder.build()
}
