@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin

import com.pulumi.alicloud.ots.TunnelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an OTS tunnel resource.
 * For information about OTS tunnel and how to use it, see [Tunnel overview](https://www.alibabacloud.com/help/en/tablestore/latest/tunnel-service-overview).
 * > **NOTE:** Available since v1.172.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultInstance = new alicloud.ots.Instance("default", {
 *     name: `${name}-${_default.result}`,
 *     description: name,
 *     accessedBy: "Any",
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultTable = new alicloud.ots.Table("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: "tf_example",
 *     timeToLive: -1,
 *     maxVersion: 1,
 *     enableSse: true,
 *     sseKeyType: "SSE_KMS_SERVICE",
 *     primaryKeys: [
 *         {
 *             name: "pk1",
 *             type: "Integer",
 *         },
 *         {
 *             name: "pk2",
 *             type: "String",
 *         },
 *         {
 *             name: "pk3",
 *             type: "Binary",
 *         },
 *     ],
 * });
 * const defaultTunnel = new alicloud.ots.Tunnel("default", {
 *     instanceName: defaultInstance.name,
 *     tableName: defaultTable.tableName,
 *     tunnelName: "tf_example",
 *     tunnelType: "BaseAndStream",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_instance = alicloud.ots.Instance("default",
 *     name=f"{name}-{default['result']}",
 *     description=name,
 *     accessed_by="Any",
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_table = alicloud.ots.Table("default",
 *     instance_name=default_instance.name,
 *     table_name="tf_example",
 *     time_to_live=-1,
 *     max_version=1,
 *     enable_sse=True,
 *     sse_key_type="SSE_KMS_SERVICE",
 *     primary_keys=[
 *         {
 *             "name": "pk1",
 *             "type": "Integer",
 *         },
 *         {
 *             "name": "pk2",
 *             "type": "String",
 *         },
 *         {
 *             "name": "pk3",
 *             "type": "Binary",
 *         },
 *     ])
 * default_tunnel = alicloud.ots.Tunnel("default",
 *     instance_name=default_instance.name,
 *     table_name=default_table.table_name,
 *     tunnel_name="tf_example",
 *     tunnel_type="BaseAndStream")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultInstance = new AliCloud.Ots.Instance("default", new()
 *     {
 *         Name = $"{name}-{@default.Result}",
 *         Description = name,
 *         AccessedBy = "Any",
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultTable = new AliCloud.Ots.Table("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = "tf_example",
 *         TimeToLive = -1,
 *         MaxVersion = 1,
 *         EnableSse = true,
 *         SseKeyType = "SSE_KMS_SERVICE",
 *         PrimaryKeys = new[]
 *         {
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk1",
 *                 Type = "Integer",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk2",
 *                 Type = "String",
 *             },
 *             new AliCloud.Ots.Inputs.TablePrimaryKeyArgs
 *             {
 *                 Name = "pk3",
 *                 Type = "Binary",
 *             },
 *         },
 *     });
 *     var defaultTunnel = new AliCloud.Ots.Tunnel("default", new()
 *     {
 *         InstanceName = defaultInstance.Name,
 *         TableName = defaultTable.TableName,
 *         TunnelName = "tf_example",
 *         TunnelType = "BaseAndStream",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := ots.NewInstance(ctx, "default", &ots.InstanceArgs{
 * 			Name:        pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String(name),
 * 			AccessedBy:  pulumi.String("Any"),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTable, err := ots.NewTable(ctx, "default", &ots.TableArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    pulumi.String("tf_example"),
 * 			TimeToLive:   int(-1),
 * 			MaxVersion:   pulumi.Int(1),
 * 			EnableSse:    pulumi.Bool(true),
 * 			SseKeyType:   pulumi.String("SSE_KMS_SERVICE"),
 * 			PrimaryKeys: ots.TablePrimaryKeyArray{
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk1"),
 * 					Type: pulumi.String("Integer"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk2"),
 * 					Type: pulumi.String("String"),
 * 				},
 * 				&ots.TablePrimaryKeyArgs{
 * 					Name: pulumi.String("pk3"),
 * 					Type: pulumi.String("Binary"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ots.NewTunnel(ctx, "default", &ots.TunnelArgs{
 * 			InstanceName: defaultInstance.Name,
 * 			TableName:    defaultTable.TableName,
 * 			TunnelName:   pulumi.String("tf_example"),
 * 			TunnelType:   pulumi.String("BaseAndStream"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultInstance:
 *     type: alicloud:ots:Instance
 *     name: default
 *     properties:
 *       name: ${name}-${default.result}
 *       description: ${name}
 *       accessedBy: Any
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultTable:
 *     type: alicloud:ots:Table
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: tf_example
 *       timeToLive: -1
 *       maxVersion: 1
 *       enableSse: true
 *       sseKeyType: SSE_KMS_SERVICE
 *       primaryKeys:
 *         - name: pk1
 *           type: Integer
 *         - name: pk2
 *           type: String
 *         - name: pk3
 *           type: Binary
 *   defaultTunnel:
 *     type: alicloud:ots:Tunnel
 *     name: default
 *     properties:
 *       instanceName: ${defaultInstance.name}
 *       tableName: ${defaultTable.tableName}
 *       tunnelName: tf_example
 *       tunnelType: BaseAndStream
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * OTS tunnel can be imported using id, e.g.
 * ```sh
 * $ pulumi import alicloud:ots/tunnel:Tunnel foo <instance_name>:<table_name>:<tunnel_name>
 * ```
 * @property instanceName The name of the OTS instance in which table will located.
 * @property tableName The name of the OTS table. If changed, a new table would be created.
 * @property tunnelName The name of the OTS tunnel. If changed, a new tunnel would be created.
 * @property tunnelType The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
 */
public data class TunnelArgs(
    public val instanceName: Output<String>? = null,
    public val tableName: Output<String>? = null,
    public val tunnelName: Output<String>? = null,
    public val tunnelType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.TunnelArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.TunnelArgs =
        com.pulumi.alicloud.ots.TunnelArgs.builder()
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .tunnelName(tunnelName?.applyValue({ args0 -> args0 }))
            .tunnelType(tunnelType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TunnelArgs].
 */
@PulumiTagMarker
public class TunnelArgsBuilder internal constructor() {
    private var instanceName: Output<String>? = null

    private var tableName: Output<String>? = null

    private var tunnelName: Output<String>? = null

    private var tunnelType: Output<String>? = null

    /**
     * @param value The name of the OTS instance in which table will located.
     */
    @JvmName("intffjmhramfdoto")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The name of the OTS table. If changed, a new table would be created.
     */
    @JvmName("ymqduweeumvahvyn")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the OTS tunnel. If changed, a new tunnel would be created.
     */
    @JvmName("eavmyyxyojmdmqvo")
    public suspend fun tunnelName(`value`: Output<String>) {
        this.tunnelName = value
    }

    /**
     * @param value The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
     */
    @JvmName("vvqtejvgxqcwtxlj")
    public suspend fun tunnelType(`value`: Output<String>) {
        this.tunnelType = value
    }

    /**
     * @param value The name of the OTS instance in which table will located.
     */
    @JvmName("jwutvkfpogdhojit")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the OTS table. If changed, a new table would be created.
     */
    @JvmName("lkpmexodyishlqyn")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The name of the OTS tunnel. If changed, a new tunnel would be created.
     */
    @JvmName("hpfhjklxxikifncy")
    public suspend fun tunnelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelName = mapped
    }

    /**
     * @param value The type of the OTS tunnel. Only `BaseAndStream`, `BaseData` or `Stream` is allowed.
     */
    @JvmName("tnkaipddoeypwumn")
    public suspend fun tunnelType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tunnelType = mapped
    }

    internal fun build(): TunnelArgs = TunnelArgs(
        instanceName = instanceName,
        tableName = tableName,
        tunnelName = tunnelName,
        tunnelType = tunnelType,
    )
}
