@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.GetTablesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTables.
 * @property ids A list of table IDs.
 * @property instanceName The name of OTS instance.
 * @property nameRegex A regex string to filter results by table name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetTablesPlainArgs(
    public val ids: List<String>? = null,
    public val instanceName: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.GetTablesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.GetTablesPlainArgs =
        com.pulumi.alicloud.ots.inputs.GetTablesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceName(instanceName.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTablesPlainArgs].
 */
@PulumiTagMarker
public class GetTablesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of table IDs.
     */
    @JvmName("hajcwhgdxdgsogqu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of table IDs.
     */
    @JvmName("lydudnxhnkhufies")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of OTS instance.
     */
    @JvmName("rkgelohhyqjtxhre")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value A regex string to filter results by table name.
     */
    @JvmName("uikuaxigioscsbxn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ohkstponkdbclsnj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetTablesPlainArgs = GetTablesPlainArgs(
        ids = ids,
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
