@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.GetTunnelsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTunnels.
 * @property ids A list of tunnel IDs.
 * @property instanceName The name of OTS instance.
 * @property nameRegex A regex string to filter results by tunnel name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property tableName The name of OTS table.
 */
public data class GetTunnelsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceName: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tableName: String,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.GetTunnelsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.GetTunnelsPlainArgs =
        com.pulumi.alicloud.ots.inputs.GetTunnelsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceName(instanceName.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTunnelsPlainArgs].
 */
@PulumiTagMarker
public class GetTunnelsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tableName: String? = null

    /**
     * @param value A list of tunnel IDs.
     */
    @JvmName("rkiowglxoioquoix")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of tunnel IDs.
     */
    @JvmName("ybgsiwojpqqibmef")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of OTS instance.
     */
    @JvmName("tcjpuvqlctghubxt")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value A regex string to filter results by tunnel name.
     */
    @JvmName("lehnmrvimqnxwmnj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bqmfjdvbyopxjjhy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of OTS table.
     */
    @JvmName("wvnvrpuwntiuxsrg")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    internal fun build(): GetTunnelsPlainArgs = GetTunnelsPlainArgs(
        ids = ids,
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
