@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.SearchIndexSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldSchemas A list of field schemas. See `field_schema` below.
 * @property indexSettings The settings of the search index, including routingFields. See `index_setting` below.
 * @property indexSorts The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
 */
public data class SearchIndexSchemaArgs(
    public val fieldSchemas: Output<List<SearchIndexSchemaFieldSchemaArgs>>,
    public val indexSettings: Output<List<SearchIndexSchemaIndexSettingArgs>>? = null,
    public val indexSorts: Output<List<SearchIndexSchemaIndexSortArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.SearchIndexSchemaArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.SearchIndexSchemaArgs =
        com.pulumi.alicloud.ots.inputs.SearchIndexSchemaArgs.builder()
            .fieldSchemas(
                fieldSchemas.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .indexSettings(
                indexSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .indexSorts(
                indexSorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SearchIndexSchemaArgs].
 */
@PulumiTagMarker
public class SearchIndexSchemaArgsBuilder internal constructor() {
    private var fieldSchemas: Output<List<SearchIndexSchemaFieldSchemaArgs>>? = null

    private var indexSettings: Output<List<SearchIndexSchemaIndexSettingArgs>>? = null

    private var indexSorts: Output<List<SearchIndexSchemaIndexSortArgs>>? = null

    /**
     * @param value A list of field schemas. See `field_schema` below.
     */
    @JvmName("ppwarvmyvthngbwt")
    public suspend fun fieldSchemas(`value`: Output<List<SearchIndexSchemaFieldSchemaArgs>>) {
        this.fieldSchemas = value
    }

    @JvmName("msfdowlgyxkvjsya")
    public suspend fun fieldSchemas(vararg values: Output<SearchIndexSchemaFieldSchemaArgs>) {
        this.fieldSchemas = Output.all(values.asList())
    }

    /**
     * @param values A list of field schemas. See `field_schema` below.
     */
    @JvmName("pvoxycqsrrgedmep")
    public suspend fun fieldSchemas(values: List<Output<SearchIndexSchemaFieldSchemaArgs>>) {
        this.fieldSchemas = Output.all(values)
    }

    /**
     * @param value The settings of the search index, including routingFields. See `index_setting` below.
     */
    @JvmName("nphprgyunlgnorwx")
    public suspend fun indexSettings(`value`: Output<List<SearchIndexSchemaIndexSettingArgs>>) {
        this.indexSettings = value
    }

    @JvmName("srdtcvmsllunemsy")
    public suspend fun indexSettings(vararg values: Output<SearchIndexSchemaIndexSettingArgs>) {
        this.indexSettings = Output.all(values.asList())
    }

    /**
     * @param values The settings of the search index, including routingFields. See `index_setting` below.
     */
    @JvmName("oreqegcpgbrqbyfy")
    public suspend fun indexSettings(values: List<Output<SearchIndexSchemaIndexSettingArgs>>) {
        this.indexSettings = Output.all(values)
    }

    /**
     * @param value The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
     */
    @JvmName("acnqjgdyjltioupw")
    public suspend fun indexSorts(`value`: Output<List<SearchIndexSchemaIndexSortArgs>>) {
        this.indexSorts = value
    }

    @JvmName("lbinrqwkeougjmeq")
    public suspend fun indexSorts(vararg values: Output<SearchIndexSchemaIndexSortArgs>) {
        this.indexSorts = Output.all(values.asList())
    }

    /**
     * @param values The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
     */
    @JvmName("siblcwirwonnvnrf")
    public suspend fun indexSorts(values: List<Output<SearchIndexSchemaIndexSortArgs>>) {
        this.indexSorts = Output.all(values)
    }

    /**
     * @param value A list of field schemas. See `field_schema` below.
     */
    @JvmName("cctwipdxbowwtmyv")
    public suspend fun fieldSchemas(`value`: List<SearchIndexSchemaFieldSchemaArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldSchemas = mapped
    }

    /**
     * @param argument A list of field schemas. See `field_schema` below.
     */
    @JvmName("pwvhataosgnntiaq")
    public suspend fun fieldSchemas(argument: List<suspend SearchIndexSchemaFieldSchemaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaFieldSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSchemas = mapped
    }

    /**
     * @param argument A list of field schemas. See `field_schema` below.
     */
    @JvmName("anmuwixrneelkame")
    public suspend fun fieldSchemas(vararg argument: suspend SearchIndexSchemaFieldSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaFieldSchemaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldSchemas = mapped
    }

    /**
     * @param argument A list of field schemas. See `field_schema` below.
     */
    @JvmName("oybqugnvkxalkdfa")
    public suspend fun fieldSchemas(argument: suspend SearchIndexSchemaFieldSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SearchIndexSchemaFieldSchemaArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fieldSchemas = mapped
    }

    /**
     * @param values A list of field schemas. See `field_schema` below.
     */
    @JvmName("gybpcrdkjbpcovfw")
    public suspend fun fieldSchemas(vararg values: SearchIndexSchemaFieldSchemaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldSchemas = mapped
    }

    /**
     * @param value The settings of the search index, including routingFields. See `index_setting` below.
     */
    @JvmName("wkisegfpspyinout")
    public suspend fun indexSettings(`value`: List<SearchIndexSchemaIndexSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexSettings = mapped
    }

    /**
     * @param argument The settings of the search index, including routingFields. See `index_setting` below.
     */
    @JvmName("vnssvlkobbuivhyx")
    public suspend fun indexSettings(argument: List<suspend SearchIndexSchemaIndexSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaIndexSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.indexSettings = mapped
    }

    /**
     * @param argument The settings of the search index, including routingFields. See `index_setting` below.
     */
    @JvmName("stdhpajwpgernemp")
    public suspend fun indexSettings(vararg argument: suspend SearchIndexSchemaIndexSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaIndexSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.indexSettings = mapped
    }

    /**
     * @param argument The settings of the search index, including routingFields. See `index_setting` below.
     */
    @JvmName("cjklqjyunawxlgqf")
    public suspend fun indexSettings(argument: suspend SearchIndexSchemaIndexSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SearchIndexSchemaIndexSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.indexSettings = mapped
    }

    /**
     * @param values The settings of the search index, including routingFields. See `index_setting` below.
     */
    @JvmName("usdqisdsnrkqochm")
    public suspend fun indexSettings(vararg values: SearchIndexSchemaIndexSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexSettings = mapped
    }

    /**
     * @param value The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
     */
    @JvmName("rywjjrswhtvkkdtq")
    public suspend fun indexSorts(`value`: List<SearchIndexSchemaIndexSortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexSorts = mapped
    }

    /**
     * @param argument The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
     */
    @JvmName("emijemnhinsgjwof")
    public suspend fun indexSorts(argument: List<suspend SearchIndexSchemaIndexSortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaIndexSortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.indexSorts = mapped
    }

    /**
     * @param argument The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
     */
    @JvmName("mhpolovhdtaxdlwh")
    public suspend fun indexSorts(vararg argument: suspend SearchIndexSchemaIndexSortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaIndexSortArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.indexSorts = mapped
    }

    /**
     * @param argument The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
     */
    @JvmName("qshhcpkofpbtjilx")
    public suspend fun indexSorts(argument: suspend SearchIndexSchemaIndexSortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SearchIndexSchemaIndexSortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.indexSorts = mapped
    }

    /**
     * @param values The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
     */
    @JvmName("spjncwlfqetwctei")
    public suspend fun indexSorts(vararg values: SearchIndexSchemaIndexSortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexSorts = mapped
    }

    internal fun build(): SearchIndexSchemaArgs = SearchIndexSchemaArgs(
        fieldSchemas = fieldSchemas ?: throw PulumiNullFieldException("fieldSchemas"),
        indexSettings = indexSettings,
        indexSorts = indexSorts,
    )
}
