@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.SearchIndexSchemaFieldSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property analyzer Specifies the type of the analyzer that you want to use. If fieldType is set to Text, you can configure this parameter. Otherwise, the default analyzer type single-word tokenization is used.
 * @property enableSortAndAgg Specifies whether to enable sorting and aggregation. Type: Boolean. Sorting can be enabled only for fields for which enable_sort_and_agg is set to true.
 * @property fieldName The name of the field that is used to sort data. only required if sorter_type is FieldSort.
 * @property fieldType Specifies the type of the field. Use FieldType.XXX to set the type.
 * @property index Specifies whether to enable indexing for the column. Type: Boolean.
 * @property isArray Specifies whether the value is an array. Type: Boolean.
 * @property store Specifies whether to store the value of the field in the search index. Type: Boolean. If you set store to true, you can read the value of the field from the search index without querying the data table. This improves query performance.
 */
public data class SearchIndexSchemaFieldSchemaArgs(
    public val analyzer: Output<String>? = null,
    public val enableSortAndAgg: Output<Boolean>? = null,
    public val fieldName: Output<String>,
    public val fieldType: Output<String>,
    public val index: Output<Boolean>? = null,
    public val isArray: Output<Boolean>? = null,
    public val store: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.SearchIndexSchemaFieldSchemaArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.SearchIndexSchemaFieldSchemaArgs =
        com.pulumi.alicloud.ots.inputs.SearchIndexSchemaFieldSchemaArgs.builder()
            .analyzer(analyzer?.applyValue({ args0 -> args0 }))
            .enableSortAndAgg(enableSortAndAgg?.applyValue({ args0 -> args0 }))
            .fieldName(fieldName.applyValue({ args0 -> args0 }))
            .fieldType(fieldType.applyValue({ args0 -> args0 }))
            .index(index?.applyValue({ args0 -> args0 }))
            .isArray(isArray?.applyValue({ args0 -> args0 }))
            .store(store?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SearchIndexSchemaFieldSchemaArgs].
 */
@PulumiTagMarker
public class SearchIndexSchemaFieldSchemaArgsBuilder internal constructor() {
    private var analyzer: Output<String>? = null

    private var enableSortAndAgg: Output<Boolean>? = null

    private var fieldName: Output<String>? = null

    private var fieldType: Output<String>? = null

    private var index: Output<Boolean>? = null

    private var isArray: Output<Boolean>? = null

    private var store: Output<Boolean>? = null

    /**
     * @param value Specifies the type of the analyzer that you want to use. If fieldType is set to Text, you can configure this parameter. Otherwise, the default analyzer type single-word tokenization is used.
     */
    @JvmName("recukfmffajriner")
    public suspend fun analyzer(`value`: Output<String>) {
        this.analyzer = value
    }

    /**
     * @param value Specifies whether to enable sorting and aggregation. Type: Boolean. Sorting can be enabled only for fields for which enable_sort_and_agg is set to true.
     */
    @JvmName("adjxtaerelipcfuy")
    public suspend fun enableSortAndAgg(`value`: Output<Boolean>) {
        this.enableSortAndAgg = value
    }

    /**
     * @param value The name of the field that is used to sort data. only required if sorter_type is FieldSort.
     */
    @JvmName("csikihqoadrhfbvb")
    public suspend fun fieldName(`value`: Output<String>) {
        this.fieldName = value
    }

    /**
     * @param value Specifies the type of the field. Use FieldType.XXX to set the type.
     */
    @JvmName("vwpayptutuhjnxdx")
    public suspend fun fieldType(`value`: Output<String>) {
        this.fieldType = value
    }

    /**
     * @param value Specifies whether to enable indexing for the column. Type: Boolean.
     */
    @JvmName("rmxskjwyscrxcvnm")
    public suspend fun index(`value`: Output<Boolean>) {
        this.index = value
    }

    /**
     * @param value Specifies whether the value is an array. Type: Boolean.
     */
    @JvmName("xyjpmrsarkbpairs")
    public suspend fun isArray(`value`: Output<Boolean>) {
        this.isArray = value
    }

    /**
     * @param value Specifies whether to store the value of the field in the search index. Type: Boolean. If you set store to true, you can read the value of the field from the search index without querying the data table. This improves query performance.
     */
    @JvmName("ljepgooajopslwka")
    public suspend fun store(`value`: Output<Boolean>) {
        this.store = value
    }

    /**
     * @param value Specifies the type of the analyzer that you want to use. If fieldType is set to Text, you can configure this parameter. Otherwise, the default analyzer type single-word tokenization is used.
     */
    @JvmName("hrmayfefunfrnbed")
    public suspend fun analyzer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyzer = mapped
    }

    /**
     * @param value Specifies whether to enable sorting and aggregation. Type: Boolean. Sorting can be enabled only for fields for which enable_sort_and_agg is set to true.
     */
    @JvmName("mpjikhahbckihdsu")
    public suspend fun enableSortAndAgg(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSortAndAgg = mapped
    }

    /**
     * @param value The name of the field that is used to sort data. only required if sorter_type is FieldSort.
     */
    @JvmName("vvooyshubefnmuxf")
    public suspend fun fieldName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldName = mapped
    }

    /**
     * @param value Specifies the type of the field. Use FieldType.XXX to set the type.
     */
    @JvmName("anndklasgekudkwh")
    public suspend fun fieldType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldType = mapped
    }

    /**
     * @param value Specifies whether to enable indexing for the column. Type: Boolean.
     */
    @JvmName("gbtvoafwaevijdpr")
    public suspend fun index(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.index = mapped
    }

    /**
     * @param value Specifies whether the value is an array. Type: Boolean.
     */
    @JvmName("viusbyyjgmsisehf")
    public suspend fun isArray(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArray = mapped
    }

    /**
     * @param value Specifies whether to store the value of the field in the search index. Type: Boolean. If you set store to true, you can read the value of the field from the search index without querying the data table. This improves query performance.
     */
    @JvmName("ydwpyyvxaqimopns")
    public suspend fun store(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.store = mapped
    }

    internal fun build(): SearchIndexSchemaFieldSchemaArgs = SearchIndexSchemaFieldSchemaArgs(
        analyzer = analyzer,
        enableSortAndAgg = enableSortAndAgg,
        fieldName = fieldName ?: throw PulumiNullFieldException("fieldName"),
        fieldType = fieldType ?: throw PulumiNullFieldException("fieldType"),
        index = index,
        isArray = isArray,
        store = store,
    )
}
