@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property routingFields Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
 */
public data class SearchIndexSchemaIndexSettingArgs(
    public val routingFields: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSettingArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSettingArgs =
        com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSettingArgs.builder()
            .routingFields(routingFields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SearchIndexSchemaIndexSettingArgs].
 */
@PulumiTagMarker
public class SearchIndexSchemaIndexSettingArgsBuilder internal constructor() {
    private var routingFields: Output<List<String>>? = null

    /**
     * @param value Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
     */
    @JvmName("mfjxveodtcpvlwlu")
    public suspend fun routingFields(`value`: Output<List<String>>) {
        this.routingFields = value
    }

    @JvmName("nxdajwhsuswkimvn")
    public suspend fun routingFields(vararg values: Output<String>) {
        this.routingFields = Output.all(values.asList())
    }

    /**
     * @param values Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
     */
    @JvmName("gcfnbquxbcjckogm")
    public suspend fun routingFields(values: List<Output<String>>) {
        this.routingFields = Output.all(values)
    }

    /**
     * @param value Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
     */
    @JvmName("jxkohmsehpdklswj")
    public suspend fun routingFields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingFields = mapped
    }

    /**
     * @param values Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
     */
    @JvmName("hgbnofaqeqvwqkju")
    public suspend fun routingFields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingFields = mapped
    }

    internal fun build(): SearchIndexSchemaIndexSettingArgs = SearchIndexSchemaIndexSettingArgs(
        routingFields = routingFields,
    )
}
