@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property sorters Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
 */
public data class SearchIndexSchemaIndexSortArgs(
    public val sorters: Output<List<SearchIndexSchemaIndexSortSorterArgs>>,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortArgs =
        com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortArgs.builder()
            .sorters(
                sorters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SearchIndexSchemaIndexSortArgs].
 */
@PulumiTagMarker
public class SearchIndexSchemaIndexSortArgsBuilder internal constructor() {
    private var sorters: Output<List<SearchIndexSchemaIndexSortSorterArgs>>? = null

    /**
     * @param value Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
     */
    @JvmName("vgepbsiobapqaqms")
    public suspend fun sorters(`value`: Output<List<SearchIndexSchemaIndexSortSorterArgs>>) {
        this.sorters = value
    }

    @JvmName("sbfuxpvhitkbtcqm")
    public suspend fun sorters(vararg values: Output<SearchIndexSchemaIndexSortSorterArgs>) {
        this.sorters = Output.all(values.asList())
    }

    /**
     * @param values Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
     */
    @JvmName("ayyphqmgcplbagqb")
    public suspend fun sorters(values: List<Output<SearchIndexSchemaIndexSortSorterArgs>>) {
        this.sorters = Output.all(values)
    }

    /**
     * @param value Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
     */
    @JvmName("wcahplihcxdamqag")
    public suspend fun sorters(`value`: List<SearchIndexSchemaIndexSortSorterArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sorters = mapped
    }

    /**
     * @param argument Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
     */
    @JvmName("kidwmcgclfiletol")
    public suspend fun sorters(argument: List<suspend SearchIndexSchemaIndexSortSorterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaIndexSortSorterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sorters = mapped
    }

    /**
     * @param argument Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
     */
    @JvmName("obulqypcusifdtko")
    public suspend fun sorters(vararg argument: suspend SearchIndexSchemaIndexSortSorterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SearchIndexSchemaIndexSortSorterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sorters = mapped
    }

    /**
     * @param argument Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
     */
    @JvmName("erfwrbsudnxhkxye")
    public suspend fun sorters(argument: suspend SearchIndexSchemaIndexSortSorterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SearchIndexSchemaIndexSortSorterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sorters = mapped
    }

    /**
     * @param values Specifies the presorting method for the search index. PrimaryKeySort and FieldSort are supported. See `sorter` below.
     */
    @JvmName("uixtitspmmrxbdme")
    public suspend fun sorters(vararg values: SearchIndexSchemaIndexSortSorterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sorters = mapped
    }

    internal fun build(): SearchIndexSchemaIndexSortArgs = SearchIndexSchemaIndexSortArgs(
        sorters = sorters ?: throw PulumiNullFieldException("sorters"),
    )
}
