@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortSorterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fieldName The name of the field that is used to sort data. only required if sorter_type is FieldSort.
 * @property mode The sorting method that is used when the field contains multiple values. valid values: `Min`, `Max`, `Avg`. only required if sorter_type is FieldSort.
 * @property order The sort order. Data can be sorted in ascending(`Asc`) or descending(`Desc`) order. Default value: `Asc`.
 * @property sorterType Data is sorted by Which fields or keys. valid values: `PrimaryKeySort`, `FieldSort`.
 */
public data class SearchIndexSchemaIndexSortSorterArgs(
    public val fieldName: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val order: Output<String>? = null,
    public val sorterType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortSorterArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortSorterArgs =
        com.pulumi.alicloud.ots.inputs.SearchIndexSchemaIndexSortSorterArgs.builder()
            .fieldName(fieldName?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .order(order?.applyValue({ args0 -> args0 }))
            .sorterType(sorterType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SearchIndexSchemaIndexSortSorterArgs].
 */
@PulumiTagMarker
public class SearchIndexSchemaIndexSortSorterArgsBuilder internal constructor() {
    private var fieldName: Output<String>? = null

    private var mode: Output<String>? = null

    private var order: Output<String>? = null

    private var sorterType: Output<String>? = null

    /**
     * @param value The name of the field that is used to sort data. only required if sorter_type is FieldSort.
     */
    @JvmName("ixxluauoaglppidp")
    public suspend fun fieldName(`value`: Output<String>) {
        this.fieldName = value
    }

    /**
     * @param value The sorting method that is used when the field contains multiple values. valid values: `Min`, `Max`, `Avg`. only required if sorter_type is FieldSort.
     */
    @JvmName("todnkjgmwtjyggpj")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The sort order. Data can be sorted in ascending(`Asc`) or descending(`Desc`) order. Default value: `Asc`.
     */
    @JvmName("xonknyqirmlmyeul")
    public suspend fun order(`value`: Output<String>) {
        this.order = value
    }

    /**
     * @param value Data is sorted by Which fields or keys. valid values: `PrimaryKeySort`, `FieldSort`.
     */
    @JvmName("qbixmiyyuxcfqkqt")
    public suspend fun sorterType(`value`: Output<String>) {
        this.sorterType = value
    }

    /**
     * @param value The name of the field that is used to sort data. only required if sorter_type is FieldSort.
     */
    @JvmName("bghcvynucpbbxryr")
    public suspend fun fieldName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldName = mapped
    }

    /**
     * @param value The sorting method that is used when the field contains multiple values. valid values: `Min`, `Max`, `Avg`. only required if sorter_type is FieldSort.
     */
    @JvmName("ngkwvhatarijiisq")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The sort order. Data can be sorted in ascending(`Asc`) or descending(`Desc`) order. Default value: `Asc`.
     */
    @JvmName("vnufdmctrkadyhbp")
    public suspend fun order(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Data is sorted by Which fields or keys. valid values: `PrimaryKeySort`, `FieldSort`.
     */
    @JvmName("pkmsdyqkcdncncgr")
    public suspend fun sorterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sorterType = mapped
    }

    internal fun build(): SearchIndexSchemaIndexSortSorterArgs = SearchIndexSchemaIndexSortSorterArgs(
        fieldName = fieldName,
        mode = mode,
        order = order,
        sorterType = sorterType,
    )
}
