@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.TableDefinedColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name for defined column.
 * @property type Type for defined column. `Integer`, `String`, `Binary`, `Double`, `Boolean` is allowed.
 */
public data class TableDefinedColumnArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.TableDefinedColumnArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.TableDefinedColumnArgs =
        com.pulumi.alicloud.ots.inputs.TableDefinedColumnArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableDefinedColumnArgs].
 */
@PulumiTagMarker
public class TableDefinedColumnArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name for defined column.
     */
    @JvmName("riqxhxvqqcjmvjdx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type for defined column. `Integer`, `String`, `Binary`, `Double`, `Boolean` is allowed.
     */
    @JvmName("udyjiiiwgumtypgy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name for defined column.
     */
    @JvmName("xqgrxsvoxsqapxch")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type for defined column. `Integer`, `String`, `Binary`, `Double`, `Boolean` is allowed.
     */
    @JvmName("qiahfskrfmcugrti")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TableDefinedColumnArgs = TableDefinedColumnArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
