@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.inputs

import com.pulumi.alicloud.ots.inputs.TablePrimaryKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name for primary key.
 * @property type Type for primary key. Only `Integer`, `String` or `Binary` is allowed.
 */
public data class TablePrimaryKeyArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ots.inputs.TablePrimaryKeyArgs> {
    override fun toJava(): com.pulumi.alicloud.ots.inputs.TablePrimaryKeyArgs =
        com.pulumi.alicloud.ots.inputs.TablePrimaryKeyArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TablePrimaryKeyArgs].
 */
@PulumiTagMarker
public class TablePrimaryKeyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name for primary key.
     */
    @JvmName("pohxrxsiomloatbl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type for primary key. Only `Integer`, `String` or `Binary` is allowed.
     */
    @JvmName("dlktmjdlinpnndbf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name for primary key.
     */
    @JvmName("wixlouchjeycjqka")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type for primary key. Only `Integer`, `String` or `Binary` is allowed.
     */
    @JvmName("djnpltkglwemivfi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TablePrimaryKeyArgs = TablePrimaryKeyArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
