@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domain The domain of the instance attachment.
 * @property endpoint The access endpoint of the instance attachment.
 * @property id The resource ID, the value is same as "instance_name".
 * @property instanceName The name of OTS instance.
 * @property region The region of the instance attachment.
 * @property vpcId The ID of attaching VPC to instance.
 * @property vpcName The name of attaching VPC to instance.
 */
public data class GetInstanceAttachmentsAttachment(
    public val domain: String,
    public val endpoint: String,
    public val id: String,
    public val instanceName: String,
    public val region: String,
    public val vpcId: String,
    public val vpcName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetInstanceAttachmentsAttachment): GetInstanceAttachmentsAttachment = GetInstanceAttachmentsAttachment(
            domain = javaType.domain(),
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            instanceName = javaType.instanceName(),
            region = javaType.region(),
            vpcId = javaType.vpcId(),
            vpcName = javaType.vpcName(),
        )
    }
}
