@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceAttachments.
 * @property attachments A list of instance attachments. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceName The instance name.
 * @property nameRegex
 * @property names A list of vpc names.
 * @property outputFile
 * @property vpcIds A list of vpc ids.
 */
public data class GetInstanceAttachmentsResult(
    public val attachments: List<GetInstanceAttachmentsAttachment>,
    public val id: String,
    public val instanceName: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val vpcIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetInstanceAttachmentsResult): GetInstanceAttachmentsResult = GetInstanceAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ots.kotlin.outputs.GetInstanceAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceName = javaType.instanceName(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            vpcIds = javaType.vpcIds().map({ args0 -> args0 }),
        )
    }
}
