@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property clusterType The cluster type of the instance. Possible values: `SSD`, `HYBRID`.
 * @property createTime The create time of the instance.
 * @property description The description of the instance.
 * @property entityQuota (Removed since v1.221.0) The instance quota which indicating the maximum number of tables.
 * @property id ID of the instance.
 * @property name Instance name.
 * @property network (Removed since v1.221.0) The network type of the instance. Possible values: `NORMAL`, `VPC`, `VPC_CONSOLE`.
 * @property networkSourceAcls (Available since v1.221.0) The set of request sources that are allowed access. Possible values: `TRUST_PROXY`.
 * @property networkTypeAcls (Available since v1.221.0) The set of network types that are allowed access. Possible values: `CLASSIC`, `VPC`, `INTERNET`.
 * @property policy (Available since v1.221.0) instance policy, json string.
 * @property policyVersion (Available since v1.221.0) instance policy version.
 * @property resourceGroupId (Available since v1.221.0) The resource group the instance belongs to.
 * @property status Instance status. Possible values: `Running`, `Disabled`, `Deleting`.
 * @property tableQuota (Available since v1.221.0) The instance quota which indicating the maximum number of tables.
 * @property tags A map of tags assigned to the instance. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const instancesDs = alicloud.ots.getInstances({
 *     tags: {
 *         tagKey1: "tagValue1",
 *         tagKey2: "tagValue2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * instances_ds = alicloud.ots.get_instances(tags={
 *     "tagKey1": "tagValue1",
 *     "tagKey2": "tagValue2",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instancesDs = AliCloud.Ots.GetInstances.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *             { "tagKey2", "tagValue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ots"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ots.GetInstances(ctx, &ots.GetInstancesArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 				"tagKey2": "tagValue2",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ots.OtsFunctions;
 * import com.pulumi.alicloud.ots.inputs.GetInstancesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var instancesDs = OtsFunctions.getInstances(GetInstancesArgs.builder()
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tagValue1"),
 *                 Map.entry("tagKey2", "tagValue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   instancesDs:
 *     fn::invoke:
 *       Function: alicloud:ots:getInstances
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 *           tagKey2: tagValue2
 * ```
 * <!--End PulumiCodeChooser -->
 * @property userId The user id of the instance.
 */
public data class GetInstancesInstance(
    public val clusterType: String,
    public val createTime: String,
    public val description: String,
    public val entityQuota: Int,
    public val id: String,
    public val name: String,
    public val network: String,
    public val networkSourceAcls: List<String>,
    public val networkTypeAcls: List<String>,
    public val policy: String,
    public val policyVersion: Int,
    public val resourceGroupId: String,
    public val status: String,
    public val tableQuota: Int,
    public val tags: Map<String, String>,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            clusterType = javaType.clusterType(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            entityQuota = javaType.entityQuota(),
            id = javaType.id(),
            name = javaType.name(),
            network = javaType.network(),
            networkSourceAcls = javaType.networkSourceAcls().map({ args0 -> args0 }),
            networkTypeAcls = javaType.networkTypeAcls().map({ args0 -> args0 }),
            policy = javaType.policy(),
            policyVersion = javaType.policyVersion(),
            resourceGroupId = javaType.resourceGroupId(),
            status = javaType.status(),
            tableQuota = javaType.tableQuota(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userId = javaType.userId(),
        )
    }
}
