@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the index.
 * @property currentSyncTimestamp Timestamp for sync phase.
 * @property id The resource ID. The value is `<instance_name>:<table_name>:<indexName>:<indexType>`.
 * @property indexName The index name of the OTS Table which could not be changed.
 * @property instanceName The name of OTS instance.
 * @property meteringLastUpdateTime Last update time for metering data..
 * @property reservedReadCu Reserve related resources for the index.
 * @property rowCount The number of rows of data for index.
 * @property schema JSON representation of the schema of index.
 * @property storageSize Storage space occupied by index.
 * @property syncPhase The synchronization state of the index.
 * @property tableName The name of OTS table.
 * @property timeToLive TTL of index.
 */
public data class GetSearchIndexesIndex(
    public val createTime: Int,
    public val currentSyncTimestamp: Int,
    public val id: String,
    public val indexName: String,
    public val instanceName: String,
    public val meteringLastUpdateTime: Int,
    public val reservedReadCu: Int,
    public val rowCount: Int,
    public val schema: String,
    public val storageSize: Int,
    public val syncPhase: String,
    public val tableName: String,
    public val timeToLive: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetSearchIndexesIndex): GetSearchIndexesIndex = GetSearchIndexesIndex(
            createTime = javaType.createTime(),
            currentSyncTimestamp = javaType.currentSyncTimestamp(),
            id = javaType.id(),
            indexName = javaType.indexName(),
            instanceName = javaType.instanceName(),
            meteringLastUpdateTime = javaType.meteringLastUpdateTime(),
            reservedReadCu = javaType.reservedReadCu(),
            rowCount = javaType.rowCount(),
            schema = javaType.schema(),
            storageSize = javaType.storageSize(),
            syncPhase = javaType.syncPhase(),
            tableName = javaType.tableName(),
            timeToLive = javaType.timeToLive(),
        )
    }
}
