@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property definedColumns A list of defined column for index, referenced from Table's primary keys or predefined columns.
 * @property id The resource ID. The value is `<instance_name>:<table_name>:<indexName>:<indexType>`.
 * @property indexName The index name of the OTS Table which could not be changed.
 * @property indexType The index type of the OTS Table which could not be changed.
 * @property instanceName The name of OTS instance.
 * @property primaryKeys A list of primary keys for index, referenced from Table's primary keys or predefined columns.
 * @property tableName The name of OTS table.
 */
public data class GetSecondaryIndexesIndex(
    public val definedColumns: List<String>,
    public val id: String,
    public val indexName: String,
    public val indexType: String,
    public val instanceName: String,
    public val primaryKeys: List<String>,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetSecondaryIndexesIndex): GetSecondaryIndexesIndex = GetSecondaryIndexesIndex(
            definedColumns = javaType.definedColumns().map({ args0 -> args0 }),
            id = javaType.id(),
            indexName = javaType.indexName(),
            indexType = javaType.indexType(),
            instanceName = javaType.instanceName(),
            primaryKeys = javaType.primaryKeys().map({ args0 -> args0 }),
            tableName = javaType.tableName(),
        )
    }
}
