@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecondaryIndexes.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of secondary index IDs.
 * @property indexes A list of indexes. Each element contains the following attributes:
 * @property instanceName The OTS instance name.
 * @property nameRegex
 * @property names A list of secondary index  names.
 * @property outputFile
 * @property tableName The table name of the OTS which could not be changed.
 */
public data class GetSecondaryIndexesResult(
    public val id: String,
    public val ids: List<String>,
    public val indexes: List<GetSecondaryIndexesIndex>,
    public val instanceName: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val tableName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetSecondaryIndexesResult): GetSecondaryIndexesResult = GetSecondaryIndexesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            indexes = javaType.indexes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ots.kotlin.outputs.GetSecondaryIndexesIndex.Companion.toKotlin(args0)
                })
            }),
            instanceName = javaType.instanceName(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName(),
        )
    }
}
