@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property definedColumns
 * @property id ID of the table. The value is `<instance_name>:<table_name>`.
 * @property instanceName The name of OTS instance.
 * @property maxVersion The maximum number of versions stored in this table.
 * @property primaryKeys The property of `TableMeta` which indicates the structure information of a table.
 * @property tableName The table name of the OTS which could not be changed.
 * @property timeToLive The retention time of data stored in this table.
 */
public data class GetTablesTable(
    public val definedColumns: List<GetTablesTableDefinedColumn>,
    public val id: String,
    public val instanceName: String,
    public val maxVersion: Int,
    public val primaryKeys: List<GetTablesTablePrimaryKey>,
    public val tableName: String,
    public val timeToLive: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetTablesTable): GetTablesTable =
            GetTablesTable(
                definedColumns = javaType.definedColumns().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ots.kotlin.outputs.GetTablesTableDefinedColumn.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                instanceName = javaType.instanceName(),
                maxVersion = javaType.maxVersion(),
                primaryKeys = javaType.primaryKeys().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ots.kotlin.outputs.GetTablesTablePrimaryKey.Companion.toKotlin(args0)
                    })
                }),
                tableName = javaType.tableName(),
                timeToLive = javaType.timeToLive(),
            )
    }
}
