@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTunnels.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of tunnel IDs.
 * @property instanceName The OTS instance name.
 * @property nameRegex
 * @property names A list of tunnel names.
 * @property outputFile
 * @property tableName The table name of the OTS which could not be changed.
 * @property tunnels A list of tunnels. Each element contains the following attributes:
 */
public data class GetTunnelsResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceName: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val tableName: String,
    public val tunnels: List<GetTunnelsTunnel>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetTunnelsResult): GetTunnelsResult = GetTunnelsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceName = javaType.instanceName(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName(),
            tunnels = javaType.tunnels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ots.kotlin.outputs.GetTunnelsTunnel.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
