@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property channels The channels of OTS tunnel. Each element contains the following attributes:
 * @property createTime The creation time of the Tunnel.
 * @property expired Whether the tunnel has expired.
 * @property id The resource ID. The value is `<instance_name>:<table_name>:<tunnel_name>`.
 * @property instanceName The name of OTS instance.
 * @property tableName The name of OTS table.
 * @property tunnelId The tunnel id of the OTS which could not be changed.
 * @property tunnelName The tunnel name of the OTS which could not be changed.
 * @property tunnelRpo The latest consumption time of the tunnel, unix time in nanosecond.
 * @property tunnelStage The stage of OTS tunnel, valid values: `InitBaseDataAndStreamShard`, `ProcessBaseData`, `ProcessStream`.
 * @property tunnelType The type of the OTS tunnel, valid values: `BaseAndStream`, `BaseData`, `Stream`.
 */
public data class GetTunnelsTunnel(
    public val channels: List<GetTunnelsTunnelChannel>,
    public val createTime: Int,
    public val expired: Boolean,
    public val id: String,
    public val instanceName: String,
    public val tableName: String,
    public val tunnelId: String,
    public val tunnelName: String,
    public val tunnelRpo: Int,
    public val tunnelStage: String,
    public val tunnelType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetTunnelsTunnel): GetTunnelsTunnel = GetTunnelsTunnel(
            channels = javaType.channels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ots.kotlin.outputs.GetTunnelsTunnelChannel.Companion.toKotlin(args0)
                })
            }),
            createTime = javaType.createTime(),
            expired = javaType.expired(),
            id = javaType.id(),
            instanceName = javaType.instanceName(),
            tableName = javaType.tableName(),
            tunnelId = javaType.tunnelId(),
            tunnelName = javaType.tunnelName(),
            tunnelRpo = javaType.tunnelRpo(),
            tunnelStage = javaType.tunnelStage(),
            tunnelType = javaType.tunnelType(),
        )
    }
}
