@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property channelId The id of the channel.
 * @property channelRpo The latest consumption time of the channel, unix time in nanosecond
 * @property channelStatus The status of the channel, valid values: `WAIT`, `OPEN`, `CLOSING`, `CLOSE`, `TERMINATED`.
 * @property channelType The type of the channel, valid values: `BaseData`, `Stream`.
 * @property clientId The client id of the channel.
 */
public data class GetTunnelsTunnelChannel(
    public val channelId: String,
    public val channelRpo: Int,
    public val channelStatus: String,
    public val channelType: String,
    public val clientId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.GetTunnelsTunnelChannel): GetTunnelsTunnelChannel = GetTunnelsTunnelChannel(
            channelId = javaType.channelId(),
            channelRpo = javaType.channelRpo(),
            channelStatus = javaType.channelStatus(),
            channelType = javaType.channelType(),
            clientId = javaType.clientId(),
        )
    }
}
