@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldSchemas A list of field schemas. See `field_schema` below.
 * @property indexSettings The settings of the search index, including routingFields. See `index_setting` below.
 * @property indexSorts The presorting settings of the search index, including sorters. If no value is specified for the indexSort parameter, field values are sorted by primary key by default. See `index_sort` below.
 */
public data class SearchIndexSchema(
    public val fieldSchemas: List<SearchIndexSchemaFieldSchema>,
    public val indexSettings: List<SearchIndexSchemaIndexSetting>? = null,
    public val indexSorts: List<SearchIndexSchemaIndexSort>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.SearchIndexSchema): SearchIndexSchema = SearchIndexSchema(
            fieldSchemas = javaType.fieldSchemas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ots.kotlin.outputs.SearchIndexSchemaFieldSchema.Companion.toKotlin(args0)
                })
            }),
            indexSettings = javaType.indexSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ots.kotlin.outputs.SearchIndexSchemaIndexSetting.Companion.toKotlin(args0)
                })
            }),
            indexSorts = javaType.indexSorts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ots.kotlin.outputs.SearchIndexSchemaIndexSort.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
