@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property analyzer Specifies the type of the analyzer that you want to use. If fieldType is set to Text, you can configure this parameter. Otherwise, the default analyzer type single-word tokenization is used.
 * @property enableSortAndAgg Specifies whether to enable sorting and aggregation. Type: Boolean. Sorting can be enabled only for fields for which enable_sort_and_agg is set to true.
 * @property fieldName The name of the field that is used to sort data. only required if sorter_type is FieldSort.
 * @property fieldType Specifies the type of the field. Use FieldType.XXX to set the type.
 * @property index Specifies whether to enable indexing for the column. Type: Boolean.
 * @property isArray Specifies whether the value is an array. Type: Boolean.
 * @property store Specifies whether to store the value of the field in the search index. Type: Boolean. If you set store to true, you can read the value of the field from the search index without querying the data table. This improves query performance.
 */
public data class SearchIndexSchemaFieldSchema(
    public val analyzer: String? = null,
    public val enableSortAndAgg: Boolean? = null,
    public val fieldName: String,
    public val fieldType: String,
    public val index: Boolean? = null,
    public val isArray: Boolean? = null,
    public val store: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.SearchIndexSchemaFieldSchema): SearchIndexSchemaFieldSchema = SearchIndexSchemaFieldSchema(
            analyzer = javaType.analyzer().map({ args0 -> args0 }).orElse(null),
            enableSortAndAgg = javaType.enableSortAndAgg().map({ args0 -> args0 }).orElse(null),
            fieldName = javaType.fieldName(),
            fieldType = javaType.fieldType(),
            index = javaType.index().map({ args0 -> args0 }).orElse(null),
            isArray = javaType.isArray().map({ args0 -> args0 }).orElse(null),
            store = javaType.store().map({ args0 -> args0 }).orElse(null),
        )
    }
}
