@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property routingFields Specifies custom routing fields. You can specify some primary key columns as routing fields. Tablestore distributes data that is written to a search index across different partitions based on the specified routing fields. The data whose routing field values are the same is distributed to the same partition.
 */
public data class SearchIndexSchemaIndexSetting(
    public val routingFields: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.SearchIndexSchemaIndexSetting): SearchIndexSchemaIndexSetting = SearchIndexSchemaIndexSetting(
            routingFields = javaType.routingFields().map({ args0 -> args0 }),
        )
    }
}
