@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldName The name of the field that is used to sort data. only required if sorter_type is FieldSort.
 * @property mode The sorting method that is used when the field contains multiple values. valid values: `Min`, `Max`, `Avg`. only required if sorter_type is FieldSort.
 * @property order The sort order. Data can be sorted in ascending(`Asc`) or descending(`Desc`) order. Default value: `Asc`.
 * @property sorterType Data is sorted by Which fields or keys. valid values: `PrimaryKeySort`, `FieldSort`.
 */
public data class SearchIndexSchemaIndexSortSorter(
    public val fieldName: String? = null,
    public val mode: String? = null,
    public val order: String? = null,
    public val sorterType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.SearchIndexSchemaIndexSortSorter): SearchIndexSchemaIndexSortSorter = SearchIndexSchemaIndexSortSorter(
            fieldName = javaType.fieldName().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            sorterType = javaType.sorterType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
