@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name for defined column.
 * @property type Type for defined column. `Integer`, `String`, `Binary`, `Double`, `Boolean` is allowed.
 */
public data class TableDefinedColumn(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.TableDefinedColumn): TableDefinedColumn = TableDefinedColumn(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
