@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ots.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property channelId The id of the channel.
 * @property channelRpo The latest consumption time of the channel, unix time in nanosecond.
 * @property channelStatus The status of the channel, valid values: `WAIT`, `OPEN`, `CLOSING`, `CLOSE`, `TERMINATED`.
 * @property channelType The type of the channel, valid values: `BaseData`, `Stream`.
 * @property clientId The client id of the channel.
 */
public data class TunnelChannel(
    public val channelId: String? = null,
    public val channelRpo: Int? = null,
    public val channelStatus: String? = null,
    public val channelType: String? = null,
    public val clientId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ots.outputs.TunnelChannel): TunnelChannel =
            TunnelChannel(
                channelId = javaType.channelId().map({ args0 -> args0 }).orElse(null),
                channelRpo = javaType.channelRpo().map({ args0 -> args0 }).orElse(null),
                channelStatus = javaType.channelStatus().map({ args0 -> args0 }).orElse(null),
                channelType = javaType.channelType().map({ args0 -> args0 }).orElse(null),
                clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
