@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a PolarDB account resource and used to manage databases.
 * > **NOTE:** Available since v1.67.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.polardb.getNodeClasses({
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     payType: "PostPaid",
 *     category: "Normal",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.classes?.[0]?.zoneId),
 *     vswitchName: "terraform-example",
 * });
 * const defaultCluster = new alicloud.polardb.Cluster("default", {
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     dbNodeClass: _default.then(_default => _default.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
 *     payType: "PostPaid",
 *     vswitchId: defaultSwitch.id,
 *     description: "terraform-example",
 * });
 * const defaultAccount = new alicloud.polardb.Account("default", {
 *     dbClusterId: defaultCluster.id,
 *     accountName: "terraform_example",
 *     accountPassword: "Example1234",
 *     accountDescription: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.polardb.get_node_classes(db_type="MySQL",
 *     db_version="8.0",
 *     pay_type="PostPaid",
 *     category="Normal")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.classes[0].zone_id,
 *     vswitch_name="terraform-example")
 * default_cluster = alicloud.polardb.Cluster("default",
 *     db_type="MySQL",
 *     db_version="8.0",
 *     db_node_class=default.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
 *     pay_type="PostPaid",
 *     vswitch_id=default_switch.id,
 *     description="terraform-example")
 * default_account = alicloud.polardb.Account("default",
 *     db_cluster_id=default_cluster.id,
 *     account_name="terraform_example",
 *     account_password="Example1234",
 *     account_description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         PayType = "PostPaid",
 *         Category = "Normal",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
 *         VswitchName = "terraform-example",
 *     });
 *     var defaultCluster = new AliCloud.PolarDB.Cluster("default", new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         DbNodeClass = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
 *         PayType = "PostPaid",
 *         VswitchId = defaultSwitch.Id,
 *         Description = "terraform-example",
 *     });
 *     var defaultAccount = new AliCloud.PolarDB.Account("default", new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *         AccountName = "terraform_example",
 *         AccountPassword = "Example1234",
 *         AccountDescription = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
 * 			DbType:    pulumi.StringRef("MySQL"),
 * 			DbVersion: pulumi.StringRef("8.0"),
 * 			PayType:   "PostPaid",
 * 			Category:  pulumi.StringRef("Normal"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Classes[0].ZoneId),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCluster, err := polardb.NewCluster(ctx, "default", &polardb.ClusterArgs{
 * 			DbType:      pulumi.String("MySQL"),
 * 			DbVersion:   pulumi.String("8.0"),
 * 			DbNodeClass: pulumi.String(_default.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
 * 			PayType:     pulumi.String("PostPaid"),
 * 			VswitchId:   defaultSwitch.ID(),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = polardb.NewAccount(ctx, "default", &polardb.AccountArgs{
 * 			DbClusterId:        defaultCluster.ID(),
 * 			AccountName:        pulumi.String("terraform_example"),
 * 			AccountPassword:    pulumi.String("Example1234"),
 * 			AccountDescription: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.polardb.PolardbFunctions;
 * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.polardb.Cluster;
 * import com.pulumi.alicloud.polardb.ClusterArgs;
 * import com.pulumi.alicloud.polardb.Account;
 * import com.pulumi.alicloud.polardb.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .payType("PostPaid")
 *             .category("Normal")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.classes()[0].zoneId())
 *             .vswitchName("terraform-example")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .dbNodeClass(default_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
 *             .payType("PostPaid")
 *             .vswitchId(defaultSwitch.id())
 *             .description("terraform-example")
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .accountName("terraform_example")
 *             .accountPassword("Example1234")
 *             .accountDescription("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.classes[0].zoneId}
 *       vswitchName: terraform-example
 *   defaultCluster:
 *     type: alicloud:polardb:Cluster
 *     name: default
 *     properties:
 *       dbType: MySQL
 *       dbVersion: '8.0'
 *       dbNodeClass: ${default.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
 *       payType: PostPaid
 *       vswitchId: ${defaultSwitch.id}
 *       description: terraform-example
 *   defaultAccount:
 *     type: alicloud:polardb:Account
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultCluster.id}
 *       accountName: terraform_example
 *       accountPassword: Example1234
 *       accountDescription: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:polardb:getNodeClasses
 *       Arguments:
 *         dbType: MySQL
 *         dbVersion: '8.0'
 *         payType: PostPaid
 *         category: Normal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * PolarDB account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/account:Account example "pc-12345:tf_account"
 * ```
 * @property accountDescription Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
 * @property accountName Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
 * @property accountPassword Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
 * @property accountType Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
 * @property dbClusterId The Id of cluster in which account belongs.
 * @property kmsEncryptedPassword An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 */
public data class AccountArgs(
    public val accountDescription: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val accountPassword: Output<String>? = null,
    public val accountType: Output<String>? = null,
    public val dbClusterId: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.AccountArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.AccountArgs =
        com.pulumi.alicloud.polardb.AccountArgs.builder()
            .accountDescription(accountDescription?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .accountType(accountType?.applyValue({ args0 -> args0 }))
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountDescription: Output<String>? = null

    private var accountName: Output<String>? = null

    private var accountPassword: Output<String>? = null

    private var accountType: Output<String>? = null

    private var dbClusterId: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    /**
     * @param value Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
     */
    @JvmName("aygqbioxitgnioro")
    public suspend fun accountDescription(`value`: Output<String>) {
        this.accountDescription = value
    }

    /**
     * @param value Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
     */
    @JvmName("hlefktuexrvumguj")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
     */
    @JvmName("yspmcgfkxovskbyc")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
     */
    @JvmName("uybulxxiqothgsfa")
    public suspend fun accountType(`value`: Output<String>) {
        this.accountType = value
    }

    /**
     * @param value The Id of cluster in which account belongs.
     */
    @JvmName("ycngtorqxhxplhtd")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("vgrqbhiesxsnskct")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("lehdurcmviwdssgx")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
     */
    @JvmName("rhbpcvfquyrsxpbl")
    public suspend fun accountDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountDescription = mapped
    }

    /**
     * @param value Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
     */
    @JvmName("fkmeahxgpfiqmwra")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters.
     */
    @JvmName("jhkhoqlntyiiuwks")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value Account type, Valid values are `Normal`, `Super`, Default to `Normal`.
     */
    @JvmName("wpgoncqpfgldvblv")
    public suspend fun accountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value The Id of cluster in which account belongs.
     */
    @JvmName("xlimggbtbrrbiknm")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
     */
    @JvmName("itfbnmdqfupgjqnx")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("cfurncvoymtsaphq")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("dwchwnkyagijlybh")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountDescription = accountDescription,
        accountName = accountName,
        accountPassword = accountPassword,
        accountType = accountType,
        dbClusterId = dbClusterId,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
    )
}
