@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.AccountPrivilegeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a PolarDB account privilege resource and used to grant several database some access privilege. A database can be granted by multiple account.
 * > **NOTE:** Available in v1.67.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.polardb.getNodeClasses({
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     payType: "PostPaid",
 *     category: "Normal",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.classes?.[0]?.zoneId),
 *     vswitchName: "terraform-example",
 * });
 * const defaultCluster = new alicloud.polardb.Cluster("default", {
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     dbNodeClass: _default.then(_default => _default.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
 *     payType: "PostPaid",
 *     vswitchId: defaultSwitch.id,
 *     description: "terraform-example",
 * });
 * const defaultAccount = new alicloud.polardb.Account("default", {
 *     dbClusterId: defaultCluster.id,
 *     accountName: "terraform_example",
 *     accountPassword: "Example1234",
 *     accountDescription: "terraform-example",
 * });
 * const defaultDatabase = new alicloud.polardb.Database("default", {
 *     dbClusterId: defaultCluster.id,
 *     dbName: "terraform-example",
 * });
 * const defaultAccountPrivilege = new alicloud.polardb.AccountPrivilege("default", {
 *     dbClusterId: defaultCluster.id,
 *     accountName: defaultAccount.accountName,
 *     accountPrivilege: "ReadOnly",
 *     dbNames: [defaultDatabase&#46;dbName],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.polardb.get_node_classes(db_type="MySQL",
 *     db_version="8.0",
 *     pay_type="PostPaid",
 *     category="Normal")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.classes[0].zone_id,
 *     vswitch_name="terraform-example")
 * default_cluster = alicloud.polardb.Cluster("default",
 *     db_type="MySQL",
 *     db_version="8.0",
 *     db_node_class=default.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
 *     pay_type="PostPaid",
 *     vswitch_id=default_switch.id,
 *     description="terraform-example")
 * default_account = alicloud.polardb.Account("default",
 *     db_cluster_id=default_cluster.id,
 *     account_name="terraform_example",
 *     account_password="Example1234",
 *     account_description="terraform-example")
 * default_database = alicloud.polardb.Database("default",
 *     db_cluster_id=default_cluster.id,
 *     db_name="terraform-example")
 * default_account_privilege = alicloud.polardb.AccountPrivilege("default",
 *     db_cluster_id=default_cluster.id,
 *     account_name=default_account.account_name,
 *     account_privilege="ReadOnly",
 *     db_names=[default_database&#46;db_name])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         PayType = "PostPaid",
 *         Category = "Normal",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
 *         VswitchName = "terraform-example",
 *     });
 *     var defaultCluster = new AliCloud.PolarDB.Cluster("default", new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         DbNodeClass = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
 *         PayType = "PostPaid",
 *         VswitchId = defaultSwitch.Id,
 *         Description = "terraform-example",
 *     });
 *     var defaultAccount = new AliCloud.PolarDB.Account("default", new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *         AccountName = "terraform_example",
 *         AccountPassword = "Example1234",
 *         AccountDescription = "terraform-example",
 *     });
 *     var defaultDatabase = new AliCloud.PolarDB.Database("default", new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *         DbName = "terraform-example",
 *     });
 *     var defaultAccountPrivilege = new AliCloud.PolarDB.AccountPrivilege("default", new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *         AccountName = defaultAccount.AccountName,
 *         Privilege = "ReadOnly",
 *         DbNames = new[]
 *         {
 *             defaultDatabase.DbName,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
 * 			DbType:    pulumi.StringRef("MySQL"),
 * 			DbVersion: pulumi.StringRef("8.0"),
 * 			PayType:   "PostPaid",
 * 			Category:  pulumi.StringRef("Normal"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Classes[0].ZoneId),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCluster, err := polardb.NewCluster(ctx, "default", &polardb.ClusterArgs{
 * 			DbType:      pulumi.String("MySQL"),
 * 			DbVersion:   pulumi.String("8.0"),
 * 			DbNodeClass: pulumi.String(_default.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
 * 			PayType:     pulumi.String("PostPaid"),
 * 			VswitchId:   defaultSwitch.ID(),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAccount, err := polardb.NewAccount(ctx, "default", &polardb.AccountArgs{
 * 			DbClusterId:        defaultCluster.ID(),
 * 			AccountName:        pulumi.String("terraform_example"),
 * 			AccountPassword:    pulumi.String("Example1234"),
 * 			AccountDescription: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDatabase, err := polardb.NewDatabase(ctx, "default", &polardb.DatabaseArgs{
 * 			DbClusterId: defaultCluster.ID(),
 * 			DbName:      pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = polardb.NewAccountPrivilege(ctx, "default", &polardb.AccountPrivilegeArgs{
 * 			DbClusterId:      defaultCluster.ID(),
 * 			AccountName:      defaultAccount.AccountName,
 * 			AccountPrivilege: pulumi.String("ReadOnly"),
 * 			DbNames: pulumi.StringArray{
 * 				defaultDatabase.DbName,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.polardb.PolardbFunctions;
 * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.polardb.Cluster;
 * import com.pulumi.alicloud.polardb.ClusterArgs;
 * import com.pulumi.alicloud.polardb.Account;
 * import com.pulumi.alicloud.polardb.AccountArgs;
 * import com.pulumi.alicloud.polardb.Database;
 * import com.pulumi.alicloud.polardb.DatabaseArgs;
 * import com.pulumi.alicloud.polardb.AccountPrivilege;
 * import com.pulumi.alicloud.polardb.AccountPrivilegeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .payType("PostPaid")
 *             .category("Normal")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.classes()[0].zoneId())
 *             .vswitchName("terraform-example")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .dbNodeClass(default_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
 *             .payType("PostPaid")
 *             .vswitchId(defaultSwitch.id())
 *             .description("terraform-example")
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .accountName("terraform_example")
 *             .accountPassword("Example1234")
 *             .accountDescription("terraform-example")
 *             .build());
 *         var defaultDatabase = new Database("defaultDatabase", DatabaseArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .dbName("terraform-example")
 *             .build());
 *         var defaultAccountPrivilege = new AccountPrivilege("defaultAccountPrivilege", AccountPrivilegeArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .accountName(defaultAccount.accountName())
 *             .accountPrivilege("ReadOnly")
 *             .dbNames(defaultDatabase.dbName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.classes[0].zoneId}
 *       vswitchName: terraform-example
 *   defaultCluster:
 *     type: alicloud:polardb:Cluster
 *     name: default
 *     properties:
 *       dbType: MySQL
 *       dbVersion: '8.0'
 *       dbNodeClass: ${default.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
 *       payType: PostPaid
 *       vswitchId: ${defaultSwitch.id}
 *       description: terraform-example
 *   defaultAccount:
 *     type: alicloud:polardb:Account
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultCluster.id}
 *       accountName: terraform_example
 *       accountPassword: Example1234
 *       accountDescription: terraform-example
 *   defaultDatabase:
 *     type: alicloud:polardb:Database
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultCluster.id}
 *       dbName: terraform-example
 *   defaultAccountPrivilege:
 *     type: alicloud:polardb:AccountPrivilege
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultCluster.id}
 *       accountName: ${defaultAccount.accountName}
 *       accountPrivilege: ReadOnly
 *       dbNames:
 *         - ${defaultDatabase.dbName}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:polardb:getNodeClasses
 *       Arguments:
 *         dbType: MySQL
 *         dbVersion: '8.0'
 *         payType: PostPaid
 *         category: Normal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * PolarDB account privilege can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/accountPrivilege:AccountPrivilege example "pc-12345:tf_account:ReadOnly"
 * ```
 * @property accountName A specified account name.
 * @property accountPrivilege The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
 * @property dbClusterId The Id of cluster in which account belongs.
 * @property dbNames List of specified database name.
 */
public data class AccountPrivilegeArgs(
    public val accountName: Output<String>? = null,
    public val accountPrivilege: Output<String>? = null,
    public val dbClusterId: Output<String>? = null,
    public val dbNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.AccountPrivilegeArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.AccountPrivilegeArgs =
        com.pulumi.alicloud.polardb.AccountPrivilegeArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .accountPrivilege(accountPrivilege?.applyValue({ args0 -> args0 }))
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 }))
            .dbNames(dbNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AccountPrivilegeArgs].
 */
@PulumiTagMarker
public class AccountPrivilegeArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var accountPrivilege: Output<String>? = null

    private var dbClusterId: Output<String>? = null

    private var dbNames: Output<List<String>>? = null

    /**
     * @param value A specified account name.
     */
    @JvmName("kfwfcuwpdwnjipgb")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
     */
    @JvmName("haeuelprricnpaql")
    public suspend fun accountPrivilege(`value`: Output<String>) {
        this.accountPrivilege = value
    }

    /**
     * @param value The Id of cluster in which account belongs.
     */
    @JvmName("fvjemtgbgpevpsgr")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value List of specified database name.
     */
    @JvmName("edtpbpvsilwrusll")
    public suspend fun dbNames(`value`: Output<List<String>>) {
        this.dbNames = value
    }

    @JvmName("dmcodhbqrvvfdbdm")
    public suspend fun dbNames(vararg values: Output<String>) {
        this.dbNames = Output.all(values.asList())
    }

    /**
     * @param values List of specified database name.
     */
    @JvmName("gcotoowxhrkskbpu")
    public suspend fun dbNames(values: List<Output<String>>) {
        this.dbNames = Output.all(values)
    }

    /**
     * @param value A specified account name.
     */
    @JvmName("fbjyciqoxetwttjo")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The privilege of one account access database. Valid values: ["ReadOnly", "ReadWrite"], ["DMLOnly", "DDLOnly"] added since version v1.101.0. Default to "ReadOnly".
     */
    @JvmName("qtejhjxjyfndkaey")
    public suspend fun accountPrivilege(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPrivilege = mapped
    }

    /**
     * @param value The Id of cluster in which account belongs.
     */
    @JvmName("odplastpklfaqftt")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    /**
     * @param value List of specified database name.
     */
    @JvmName("kgkohidhuhrcbpim")
    public suspend fun dbNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNames = mapped
    }

    /**
     * @param values List of specified database name.
     */
    @JvmName("dkvmcrsqxxpfddtq")
    public suspend fun dbNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbNames = mapped
    }

    internal fun build(): AccountPrivilegeArgs = AccountPrivilegeArgs(
        accountName = accountName,
        accountPrivilege = accountPrivilege,
        dbClusterId = dbClusterId,
        dbNames = dbNames,
    )
}
