@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource = com.pulumi.alicloud.polardb.BackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * PolarDB backup policy can be imported using the id or cluster id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/backupPolicy:BackupPolicy example "rm-12345678"
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.polardb.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
     */
    public val backupFrequency: Output<String>
        get() = javaResource.backupFrequency().applyValue({ args0 -> args0 })

    /**
     * Cluster backup retention days, Fixed for 7 days, not modified.
     */
    public val backupRetentionPeriod: Output<String>
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
     */
    public val backupRetentionPolicyOnClusterDeletion: Output<String>
        get() = javaResource.backupRetentionPolicyOnClusterDeletion().applyValue({ args0 -> args0 })

    /**
     * The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
     */
    public val dataLevel1BackupFrequency: Output<String>
        get() = javaResource.dataLevel1BackupFrequency().applyValue({ args0 -> args0 })

    /**
     * PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    public val dataLevel1BackupPeriods: Output<List<String>>
        get() = javaResource.dataLevel1BackupPeriods().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
     */
    public val dataLevel1BackupRetentionPeriod: Output<Int>
        get() = javaResource.dataLevel1BackupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
     */
    public val dataLevel1BackupTime: Output<String>
        get() = javaResource.dataLevel1BackupTime().applyValue({ args0 -> args0 })

    /**
     * PolarDB Cluster of level-2 backup is a cross regional backup area.
     */
    public val dataLevel2BackupAnotherRegionRegion: Output<String>?
        get() = javaResource.dataLevel2BackupAnotherRegionRegion().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
     */
    public val dataLevel2BackupAnotherRegionRetentionPeriod: Output<Int>
        get() = javaResource.dataLevel2BackupAnotherRegionRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    public val dataLevel2BackupPeriods: Output<List<String>>?
        get() = javaResource.dataLevel2BackupPeriods().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
     */
    public val dataLevel2BackupRetentionPeriod: Output<Int>
        get() = javaResource.dataLevel2BackupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The Id of cluster that can run database.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the log backup feature was enabled. Valid values are `0`, `1`. `1` By default, the log backup feature is enabled and cannot be disabled.
     */
    public val enableBackupLog: Output<Int>
        get() = javaResource.enableBackupLog().applyValue({ args0 -> args0 })

    /**
     * The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview&#46;](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
     */
    public val logBackupAnotherRegionRegion: Output<String>?
        get() = javaResource.logBackupAnotherRegionRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
     * > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
     */
    public val logBackupAnotherRegionRetentionPeriod: Output<Int>?
        get() = javaResource.logBackupAnotherRegionRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
     */
    public val logBackupRetentionPeriod: Output<Int>
        get() = javaResource.logBackupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]&#46; Default to ["Tuesday", "Thursday", "Saturday"].
     */
    public val preferredBackupPeriods: Output<List<String>>
        get() = javaResource.preferredBackupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
     */
    public val preferredBackupTime: Output<String>
        get() = javaResource.preferredBackupTime().applyValue({ args0 -> args0 })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.polardb.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.alicloud.polardb.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
