@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.BackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * PolarDB backup policy can be imported using the id or cluster id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/backupPolicy:BackupPolicy example "rm-12345678"
 * ```
 * @property backupFrequency The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
 * @property backupRetentionPeriod Cluster backup retention days, Fixed for 7 days, not modified.
 * @property backupRetentionPolicyOnClusterDeletion Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
 * @property dataLevel1BackupFrequency The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
 * @property dataLevel1BackupPeriods PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
 * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
 * @property dataLevel1BackupRetentionPeriod The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
 * @property dataLevel1BackupTime The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
 * @property dataLevel2BackupAnotherRegionRegion PolarDB Cluster of level-2 backup is a cross regional backup area.
 * @property dataLevel2BackupAnotherRegionRetentionPeriod PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
 * @property dataLevel2BackupPeriods PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
 * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
 * @property dataLevel2BackupRetentionPeriod The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
 * @property dbClusterId The Id of cluster that can run database.
 * @property logBackupAnotherRegionRegion The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview&#46;](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
 * @property logBackupAnotherRegionRetentionPeriod The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
 * > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
 * @property logBackupRetentionPeriod The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
 * @property preferredBackupPeriods PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]&#46; Default to ["Tuesday", "Thursday", "Saturday"].
 * @property preferredBackupTime PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
 */
public data class BackupPolicyArgs(
    public val backupFrequency: Output<String>? = null,
    public val backupRetentionPeriod: Output<String>? = null,
    public val backupRetentionPolicyOnClusterDeletion: Output<String>? = null,
    public val dataLevel1BackupFrequency: Output<String>? = null,
    public val dataLevel1BackupPeriods: Output<List<String>>? = null,
    public val dataLevel1BackupRetentionPeriod: Output<Int>? = null,
    public val dataLevel1BackupTime: Output<String>? = null,
    public val dataLevel2BackupAnotherRegionRegion: Output<String>? = null,
    public val dataLevel2BackupAnotherRegionRetentionPeriod: Output<Int>? = null,
    public val dataLevel2BackupPeriods: Output<List<String>>? = null,
    public val dataLevel2BackupRetentionPeriod: Output<Int>? = null,
    public val dbClusterId: Output<String>? = null,
    public val logBackupAnotherRegionRegion: Output<String>? = null,
    public val logBackupAnotherRegionRetentionPeriod: Output<Int>? = null,
    public val logBackupRetentionPeriod: Output<Int>? = null,
    public val preferredBackupPeriods: Output<List<String>>? = null,
    public val preferredBackupTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.BackupPolicyArgs =
        com.pulumi.alicloud.polardb.BackupPolicyArgs.builder()
            .backupFrequency(backupFrequency?.applyValue({ args0 -> args0 }))
            .backupRetentionPeriod(backupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .backupRetentionPolicyOnClusterDeletion(
                backupRetentionPolicyOnClusterDeletion?.applyValue({ args0 ->
                    args0
                }),
            )
            .dataLevel1BackupFrequency(dataLevel1BackupFrequency?.applyValue({ args0 -> args0 }))
            .dataLevel1BackupPeriods(
                dataLevel1BackupPeriods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .dataLevel1BackupRetentionPeriod(dataLevel1BackupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .dataLevel1BackupTime(dataLevel1BackupTime?.applyValue({ args0 -> args0 }))
            .dataLevel2BackupAnotherRegionRegion(
                dataLevel2BackupAnotherRegionRegion?.applyValue({ args0 ->
                    args0
                }),
            )
            .dataLevel2BackupAnotherRegionRetentionPeriod(
                dataLevel2BackupAnotherRegionRetentionPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .dataLevel2BackupPeriods(
                dataLevel2BackupPeriods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .dataLevel2BackupRetentionPeriod(dataLevel2BackupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 }))
            .logBackupAnotherRegionRegion(logBackupAnotherRegionRegion?.applyValue({ args0 -> args0 }))
            .logBackupAnotherRegionRetentionPeriod(
                logBackupAnotherRegionRetentionPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .logBackupRetentionPeriod(logBackupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .preferredBackupPeriods(
                preferredBackupPeriods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .preferredBackupTime(preferredBackupTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var backupFrequency: Output<String>? = null

    private var backupRetentionPeriod: Output<String>? = null

    private var backupRetentionPolicyOnClusterDeletion: Output<String>? = null

    private var dataLevel1BackupFrequency: Output<String>? = null

    private var dataLevel1BackupPeriods: Output<List<String>>? = null

    private var dataLevel1BackupRetentionPeriod: Output<Int>? = null

    private var dataLevel1BackupTime: Output<String>? = null

    private var dataLevel2BackupAnotherRegionRegion: Output<String>? = null

    private var dataLevel2BackupAnotherRegionRetentionPeriod: Output<Int>? = null

    private var dataLevel2BackupPeriods: Output<List<String>>? = null

    private var dataLevel2BackupRetentionPeriod: Output<Int>? = null

    private var dbClusterId: Output<String>? = null

    private var logBackupAnotherRegionRegion: Output<String>? = null

    private var logBackupAnotherRegionRetentionPeriod: Output<Int>? = null

    private var logBackupRetentionPeriod: Output<Int>? = null

    private var preferredBackupPeriods: Output<List<String>>? = null

    private var preferredBackupTime: Output<String>? = null

    /**
     * @param value The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
     */
    @JvmName("suyccijioablwagr")
    public suspend fun backupFrequency(`value`: Output<String>) {
        this.backupFrequency = value
    }

    /**
     * @param value Cluster backup retention days, Fixed for 7 days, not modified.
     */
    @JvmName("giwhaneiwvnybhhy")
    public suspend fun backupRetentionPeriod(`value`: Output<String>) {
        this.backupRetentionPeriod = value
    }

    /**
     * @param value Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
     */
    @JvmName("mnphauxqdpsqttcx")
    public suspend fun backupRetentionPolicyOnClusterDeletion(`value`: Output<String>) {
        this.backupRetentionPolicyOnClusterDeletion = value
    }

    /**
     * @param value The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
     */
    @JvmName("mankyhacrqdgccku")
    public suspend fun dataLevel1BackupFrequency(`value`: Output<String>) {
        this.dataLevel1BackupFrequency = value
    }

    /**
     * @param value PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("bcomtbdbhahcuook")
    public suspend fun dataLevel1BackupPeriods(`value`: Output<List<String>>) {
        this.dataLevel1BackupPeriods = value
    }

    @JvmName("oxoliuavalwdeeok")
    public suspend fun dataLevel1BackupPeriods(vararg values: Output<String>) {
        this.dataLevel1BackupPeriods = Output.all(values.asList())
    }

    /**
     * @param values PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("cssqguwfrkwigtjo")
    public suspend fun dataLevel1BackupPeriods(values: List<Output<String>>) {
        this.dataLevel1BackupPeriods = Output.all(values)
    }

    /**
     * @param value The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
     */
    @JvmName("gamjjhwlojcecatt")
    public suspend fun dataLevel1BackupRetentionPeriod(`value`: Output<Int>) {
        this.dataLevel1BackupRetentionPeriod = value
    }

    /**
     * @param value The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
     */
    @JvmName("xxbuweaquwyxdrdl")
    public suspend fun dataLevel1BackupTime(`value`: Output<String>) {
        this.dataLevel1BackupTime = value
    }

    /**
     * @param value PolarDB Cluster of level-2 backup is a cross regional backup area.
     */
    @JvmName("vlkxfkidsmntoarp")
    public suspend fun dataLevel2BackupAnotherRegionRegion(`value`: Output<String>) {
        this.dataLevel2BackupAnotherRegionRegion = value
    }

    /**
     * @param value PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
     */
    @JvmName("whwbkpcxjucbfcql")
    public suspend fun dataLevel2BackupAnotherRegionRetentionPeriod(`value`: Output<Int>) {
        this.dataLevel2BackupAnotherRegionRetentionPeriod = value
    }

    /**
     * @param value PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("jsgdebcsxtvgpqrf")
    public suspend fun dataLevel2BackupPeriods(`value`: Output<List<String>>) {
        this.dataLevel2BackupPeriods = value
    }

    @JvmName("maffmsgysjrlhypp")
    public suspend fun dataLevel2BackupPeriods(vararg values: Output<String>) {
        this.dataLevel2BackupPeriods = Output.all(values.asList())
    }

    /**
     * @param values PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("hdgrqrbcnsvwonrp")
    public suspend fun dataLevel2BackupPeriods(values: List<Output<String>>) {
        this.dataLevel2BackupPeriods = Output.all(values)
    }

    /**
     * @param value The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
     */
    @JvmName("clxvbusfuturdjob")
    public suspend fun dataLevel2BackupRetentionPeriod(`value`: Output<Int>) {
        this.dataLevel2BackupRetentionPeriod = value
    }

    /**
     * @param value The Id of cluster that can run database.
     */
    @JvmName("bsafvpcnpwllnorj")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview&#46;](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
     */
    @JvmName("anndintadsdllnoq")
    public suspend fun logBackupAnotherRegionRegion(`value`: Output<String>) {
        this.logBackupAnotherRegionRegion = value
    }

    /**
     * @param value The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
     * > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
     */
    @JvmName("yoncweiixqsiowxf")
    public suspend fun logBackupAnotherRegionRetentionPeriod(`value`: Output<Int>) {
        this.logBackupAnotherRegionRetentionPeriod = value
    }

    /**
     * @param value The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
     */
    @JvmName("fjrmvrjbdurswaps")
    public suspend fun logBackupRetentionPeriod(`value`: Output<Int>) {
        this.logBackupRetentionPeriod = value
    }

    /**
     * @param value PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]&#46; Default to ["Tuesday", "Thursday", "Saturday"].
     */
    @JvmName("knjmjjnablekajgm")
    public suspend fun preferredBackupPeriods(`value`: Output<List<String>>) {
        this.preferredBackupPeriods = value
    }

    @JvmName("ndxlgmdstbfsmpuh")
    public suspend fun preferredBackupPeriods(vararg values: Output<String>) {
        this.preferredBackupPeriods = Output.all(values.asList())
    }

    /**
     * @param values PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]&#46; Default to ["Tuesday", "Thursday", "Saturday"].
     */
    @JvmName("jhjswhidhydhjlnl")
    public suspend fun preferredBackupPeriods(values: List<Output<String>>) {
        this.preferredBackupPeriods = Output.all(values)
    }

    /**
     * @param value PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
     */
    @JvmName("kpagfmphgkenhqng")
    public suspend fun preferredBackupTime(`value`: Output<String>) {
        this.preferredBackupTime = value
    }

    /**
     * @param value The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
     */
    @JvmName("kxdyypjagjwdeyxk")
    public suspend fun backupFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupFrequency = mapped
    }

    /**
     * @param value Cluster backup retention days, Fixed for 7 days, not modified.
     */
    @JvmName("hhwvtvodwbtgkicb")
    public suspend fun backupRetentionPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPeriod = mapped
    }

    /**
     * @param value Specifies whether to retain backups when you delete a cluster. Valid values are `ALL`, `LATEST`, `NONE`. Default to `NONE`. Value options can refer to the latest docs [ModifyBackupPolicy](https://www.alibabacloud.com/help/en/polardb/latest/modifybackuppolicy)
     */
    @JvmName("yrvvnwgbjkgjvvms")
    public suspend fun backupRetentionPolicyOnClusterDeletion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPolicyOnClusterDeletion = mapped
    }

    /**
     * @param value The Id of cluster that can run database.The backup frequency. Valid values are `Normal`, `2/24H`, `3/24H`, `4/24H`.Default to `Normal`.
     */
    @JvmName("bdvaixriupmnyinc")
    public suspend fun dataLevel1BackupFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel1BackupFrequency = mapped
    }

    /**
     * @param value PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("ifoiawdpngcmvpsk")
    public suspend fun dataLevel1BackupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel1BackupPeriods = mapped
    }

    /**
     * @param values PolarDB Cluster of level-1 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("pajrcefuhxxnwokh")
    public suspend fun dataLevel1BackupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataLevel1BackupPeriods = mapped
    }

    /**
     * @param value The retention period of level-1 backups. Valid values: 3 to 14. Unit: days.
     */
    @JvmName("ewtirfniqhjaevre")
    public suspend fun dataLevel1BackupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel1BackupRetentionPeriod = mapped
    }

    /**
     * @param value The time period during which automatic backup is performed. The format is HH: MMZ HH: MMZ (UTC time), and the entered value must be an hour apart, such as 14:00z-15:00z.
     */
    @JvmName("kcgrtugwgqxxbukj")
    public suspend fun dataLevel1BackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel1BackupTime = mapped
    }

    /**
     * @param value PolarDB Cluster of level-2 backup is a cross regional backup area.
     */
    @JvmName("mieofnbtjaypkbaf")
    public suspend fun dataLevel2BackupAnotherRegionRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel2BackupAnotherRegionRegion = mapped
    }

    /**
     * @param value PolarDB Cluster of level-2 backup cross region backup retention period. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
     */
    @JvmName("uyxhhlvhuxnyihbb")
    public suspend fun dataLevel2BackupAnotherRegionRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel2BackupAnotherRegionRetentionPeriod = mapped
    }

    /**
     * @param value PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("exogmwpgcanwmvew")
    public suspend fun dataLevel2BackupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel2BackupPeriods = mapped
    }

    /**
     * @param values PolarDB Cluster of level-2 backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"].
     * > **NOTE:** Note Select at least two values. Separate multiple values with commas (,).
     */
    @JvmName("rotbilfwexxyqjao")
    public suspend fun dataLevel2BackupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataLevel2BackupPeriods = mapped
    }

    /**
     * @param value The retention period of level-2 backups. Valid values are `0`, `30 to 7300`, `-1`. Default to `0`.
     */
    @JvmName("bgujfqhabfgwwofk")
    public suspend fun dataLevel2BackupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLevel2BackupRetentionPeriod = mapped
    }

    /**
     * @param value The Id of cluster that can run database.
     */
    @JvmName("qyuglaabwxueluhd")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    /**
     * @param value The region in which you want to store cross-region log backups. For information about regions that support the cross-region backup feature, see [Overview&#46;](https://www.alibabacloud.com/help/en/polardb/latest/backup-and-restoration-overview)
     */
    @JvmName("uvdbhdsdrgfiiedj")
    public suspend fun logBackupAnotherRegionRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBackupAnotherRegionRegion = mapped
    }

    /**
     * @param value The retention period of cross-region log backups. Default value: OFF. Valid values are `0`, `30 to 7300`, `-1`.
     * > **NOTE:** Note When you create a cluster, the default value of this parameter is 0.
     */
    @JvmName("bigjbemryuafutfk")
    public suspend fun logBackupAnotherRegionRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBackupAnotherRegionRetentionPeriod = mapped
    }

    /**
     * @param value The retention period of the log backups. Valid values are `3 to 7300`, `-1`.
     */
    @JvmName("faqxulrnplkvtbxo")
    public suspend fun logBackupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBackupRetentionPeriod = mapped
    }

    /**
     * @param value PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]&#46; Default to ["Tuesday", "Thursday", "Saturday"].
     */
    @JvmName("uftfkaowrwigasde")
    public suspend fun preferredBackupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupPeriods = mapped
    }

    /**
     * @param values PolarDB Cluster backup period. Valid values: ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]&#46; Default to ["Tuesday", "Thursday", "Saturday"].
     */
    @JvmName("wvxybpxhqomlrvqm")
    public suspend fun preferredBackupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredBackupPeriods = mapped
    }

    /**
     * @param value PolarDB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. Default to "02:00Z-03:00Z". China time is 8 hours behind it.
     */
    @JvmName("lsmuautbdydrjvfs")
    public suspend fun preferredBackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupTime = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        backupFrequency = backupFrequency,
        backupRetentionPeriod = backupRetentionPeriod,
        backupRetentionPolicyOnClusterDeletion = backupRetentionPolicyOnClusterDeletion,
        dataLevel1BackupFrequency = dataLevel1BackupFrequency,
        dataLevel1BackupPeriods = dataLevel1BackupPeriods,
        dataLevel1BackupRetentionPeriod = dataLevel1BackupRetentionPeriod,
        dataLevel1BackupTime = dataLevel1BackupTime,
        dataLevel2BackupAnotherRegionRegion = dataLevel2BackupAnotherRegionRegion,
        dataLevel2BackupAnotherRegionRetentionPeriod = dataLevel2BackupAnotherRegionRetentionPeriod,
        dataLevel2BackupPeriods = dataLevel2BackupPeriods,
        dataLevel2BackupRetentionPeriod = dataLevel2BackupRetentionPeriod,
        dbClusterId = dbClusterId,
        logBackupAnotherRegionRegion = logBackupAnotherRegionRegion,
        logBackupAnotherRegionRetentionPeriod = logBackupAnotherRegionRetentionPeriod,
        logBackupRetentionPeriod = logBackupRetentionPeriod,
        preferredBackupPeriods = preferredBackupPeriods,
        preferredBackupTime = preferredBackupTime,
    )
}
