@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.kotlin.outputs.ClusterDbClusterIpArray
import com.pulumi.alicloud.polardb.kotlin.outputs.ClusterDbRevisionVersionList
import com.pulumi.alicloud.polardb.kotlin.outputs.ClusterParameter
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.polardb.kotlin.outputs.ClusterDbClusterIpArray.Companion.toKotlin as clusterDbClusterIpArrayToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.ClusterDbRevisionVersionList.Companion.toKotlin as clusterDbRevisionVersionListToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.ClusterParameter.Companion.toKotlin as clusterParameterToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.alicloud.polardb.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * PolarDB cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/cluster:Cluster example pc-abc12345678
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.alicloud.polardb.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * Specifies whether to enable the no-activity suspension feature. Default value: false. Valid values are `true`, `false`. This parameter is valid only for serverless clusters.
     */
    public val allowShutDown: Output<String>?
        get() = javaResource.allowShutDown().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The retention policy for the backup sets when you delete the cluster.  Valid values are `ALL`, `LATEST`, `NONE`. Value options can refer to the latest docs [DeleteDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/deletedbcluster-1)
     */
    public val backupRetentionPolicyOnClusterDeletion: Output<String>
        get() = javaResource.backupRetentionPolicyOnClusterDeletion().applyValue({ args0 -> args0 })

    /**
     * The time point of data to be cloned. Valid values are `LATEST`,`BackupID`,`Timestamp`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CloneDataPoint`.
     * > **NOTE:** If CreationOption is set to CloneFromRDS, the value of this parameter must be LATEST.
     */
    public val cloneDataPoint: Output<String>?
        get() = javaResource.cloneDataPoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable or disable SQL data collector. Valid values are `Enable`, `Disabled`.
     */
    public val collectorStatus: Output<String>
        get() = javaResource.collectorStatus().applyValue({ args0 -> args0 })

    /**
     * (Available since 1.81.0) PolarDB cluster connection string.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * (Available since 1.204.1) PolarDB cluster creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The edition of the PolarDB service. Valid values are `Normal`,`Basic`,`ArchiveNormal`,`NormalMultimaster`,`SENormal`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationCategory`.
     * > **NOTE:** You can set this parameter to Basic only when DBType is set to MySQL and DBVersion is set to 5.6, 5.7, or 8.0. You can set this parameter to Archive only when DBType is set to MySQL and DBVersion is set to 8.0. From version 1.188.0, `creation_category` can be set to `NormalMultimaster`. From version 1.203.0, `creation_category` can be set to `SENormal`.
     */
    public val creationCategory: Output<String>
        get() = javaResource.creationCategory().applyValue({ args0 -> args0 })

    /**
     * The method that is used to create a cluster. Valid values are `Normal`,`CloneFromPolarDB`,`CloneFromRDS`,`MigrationFromRDS`,`CreateGdnStandby`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationOption`.
     * > **NOTE:** The default value is Normal. If DBType is set to MySQL and DBVersion is set to 5.6 or 5.7, this parameter can be set to CloneFromRDS or MigrationFromRDS. If DBType is set to MySQL and DBVersion is set to 8.0, this parameter can be set to CreateGdnStandby.
     */
    public val creationOption: Output<String>
        get() = javaResource.creationOption().applyValue({ args0 -> args0 })

    /**
     * db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    public val dbClusterIpArrays: Output<List<ClusterDbClusterIpArray>>
        get() = javaResource.dbClusterIpArrays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterDbClusterIpArrayToKotlin(args0) })
            })
        })

    /**
     * The db_node_class of cluster node.
     * > **NOTE:** Node specifications are divided into cluster version, single node version and History Library version. They can't change each other, but the general specification and exclusive specification of cluster version can be changed.
     * From version 1.204.0, If you need to create a Serverless cluster, `db_node_class` can be set to `polar.mysql.sl.small`.
     */
    public val dbNodeClass: Output<String>
        get() = javaResource.dbNodeClass().applyValue({ args0 -> args0 })

    /**
     * Number of the PolarDB cluster nodes, default is 2(Each cluster must contain at least a primary node and a read-only node). Add/remove nodes by modifying this parameter, valid values: [2~16].
     * > **NOTE:** To avoid adding or removing multiple read-only nodes by mistake, the system allows you to add or remove one read-only node at a time.
     */
    public val dbNodeCount: Output<Int>
        get() = javaResource.dbNodeCount().applyValue({ args0 -> args0 })

    /**
     * The ID of the node or node subscript. Node subscript values: 1 to 15.
     */
    public val dbNodeId: Output<String>?
        get() = javaResource.dbNodeId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The number of Standard Edition nodes. Default value: `1`. Valid values are `1`, `2`.
     */
    public val dbNodeNum: Output<Int>?
        get() = javaResource.dbNodeNum().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available since v1.216.0) The db_revision_version_list supports the following:
     */
    public val dbRevisionVersionLists: Output<List<ClusterDbRevisionVersionList>>
        get() = javaResource.dbRevisionVersionLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterDbRevisionVersionListToKotlin(args0) })
            })
        })

    /**
     * Database type. Value options: MySQL, Oracle, PostgreSQL.
     */
    public val dbType: Output<String>
        get() = javaResource.dbType().applyValue({ args0 -> args0 })

    /**
     * Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
     */
    public val dbVersion: Output<String>
        get() = javaResource.dbVersion().applyValue({ args0 -> args0 })

    /**
     * The time zone of the cluster. You can set the parameter to a value that is on the hour from -12:00 to +13:00 based on UTC. Example: 00:00. Default value: SYSTEM. This value indicates that the time zone of the cluster is the same as the time zone of the region.
     * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
     */
    public val defaultTimeZone: Output<String>
        get() = javaResource.defaultTimeZone().applyValue({ args0 -> args0 })

    /**
     * turn on table deletion_lock. Valid values are 0, 1. 1 means to open the cluster protection lock, 0 means to close the cluster protection lock
     * > **NOTE:**  Cannot modify after created when `pay_type` is `Prepaid` .`deletion_lock` the cluster protection lock can be turned on or off when `pay_type` is `Postpaid`.
     */
    public val deletionLock: Output<Int>?
        get() = javaResource.deletionLock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of cluster.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * turn on table auto encryption. Valid values are `ON`, `OFF`. Only MySQL 8.0 supports.
     * > **NOTE:** `encrypt_new_tables` Polardb MySQL 8.0 cluster, after TDE and Automatic Encryption are enabled, all newly created tables are automatically encrypted in the cluster.
     */
    public val encryptNewTables: Output<String>?
        get() = javaResource.encryptNewTables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the custom key. `encryption_key` cannot be modified after TDE is opened.
     */
    public val encryptionKey: Output<String>?
        get() = javaResource.encryptionKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Immediate or scheduled kernel version upgrade. Valid values are `true`, `false`. True means immediate execution, False means scheduled execution.
     */
    public val fromTimeService: Output<String>?
        get() = javaResource.fromTimeService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the global database network (GDN).
     * > **NOTE:** This parameter is required if CreationOption is set to CreateGdnStandby.
     */
    public val gdnId: Output<String>?
        get() = javaResource.gdnId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether the hot standby feature is enabled. Valid values are `ON`, `OFF`. Only MySQL supports.
     */
    public val hotReplicaMode: Output<String>
        get() = javaResource.hotReplicaMode().applyValue({ args0 -> args0 })

    /**
     * Whether to enable the hot standby cluster. Valid values are `ON`, `OFF`. Only MySQL supports.
     */
    public val hotStandbyCluster: Output<String>
        get() = javaResource.hotStandbyCluster().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the In-Memory Column Index (IMCI) feature. Valid values are `ON`, `OFF`.
     * > **NOTE:**  Only polardb MySQL Cluster version is available. The cluster with minor version number of 8.0.1 supports the column index feature, and the specific kernel version must be 8.0.1.1.22 or above.
     * > **NOTE:**  The single node, the single node version of the history library, and the cluster version of the history library do not support column save indexes.
     */
    public val imciSwitch: Output<String>
        get() = javaResource.imciSwitch().applyValue({ args0 -> args0 })

    /**
     * Enable the Binlog function. Default value: `OFF`. Valid values are `OFF`, `ON`.
     * > **NOTE:** This parameter is valid only MySQL Engine supports.
     */
    public val loosePolarLogBin: Output<String>
        get() = javaResource.loosePolarLogBin().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the table names are case-sensitive. Default value: `1`.  Valid values are `1`, `0`.
     * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
     */
    public val lowerCaseTableNames: Output<Int>
        get() = javaResource.lowerCaseTableNames().applyValue({ args0 -> args0 })

    /**
     * Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    public val maintainTime: Output<String>
        get() = javaResource.maintainTime().applyValue({ args0 -> args0 })

    /**
     * Use as `db_node_class` change class, define upgrade or downgrade. Valid values are `Upgrade`, `Downgrade`, Default to `Upgrade`.
     */
    public val modifyType: Output<String>?
        get() = javaResource.modifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the parameter template
     * > **NOTE:** You can call the [DescribeParameterGroups](https://www.alibabacloud.com/help/en/polardb/latest/describeparametergroups) operation to query the details of all parameter templates of a specified region, such as the ID of a parameter template.
     */
    public val parameterGroupId: Output<String>?
        get() = javaResource.parameterGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    public val parameters: Output<List<ClusterParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterParameterToKotlin(args0)
                })
            })
        })

    /**
     * Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
     */
    public val payType: Output<String>?
        get() = javaResource.payType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The latest time to start executing the target scheduled task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
     * > **NOTE:** The latest time must be 30 minutes or more later than the start time. If PlannedStartTime is set but this parameter is not specified, the latest time to execute the target task defaults to the start time+30 minutes. For example, when the PlannedStartTime is set to 2021-01-14T09:00:00Z and this parameter is left blank, the target task will start executing at the latest on 2021-01-14T09:30:00Z.
     */
    public val plannedEndTime: Output<String>?
        get() = javaResource.plannedEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The earliest time to start executing a scheduled (i.e. within the target time period) kernel version upgrade task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
     * > **NOTE:** The starting time range is any time point within the next 24 hours. For example, the current time is 2021-01-14T09:00:00Z, and the allowed start time range for filling in here is 2021-01-14T09:00:00Z~2021-01-15T09:00:00Z. If this parameter is left blank, the kernel version upgrade task will be executed immediately by default.
     */
    public val plannedStartTime: Output<String>?
        get() = javaResource.plannedStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available since 1.196.0) PolarDB cluster connection port.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The specifications of the Standard Edition PolarProxy. Available parameters can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1)
     * > **NOTE:** This parameter is valid only for standard edition clusters.
     */
    public val proxyClass: Output<String>?
        get() = javaResource.proxyClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of PolarProxy. Valid values are `EXCLUSIVE` `GENERAL`.
     * > **NOTE:** This parameter is valid for both standard and enterprise clusters.
     */
    public val proxyType: Output<String>?
        get() = javaResource.proxyType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    public val renewalStatus: Output<String>?
        get() = javaResource.renewalStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of resource group which the PolarDB cluster belongs. If not specified, then it belongs to the default resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The Alibaba Cloud Resource Name (ARN) of the RAM role. A RAM role is a virtual identity that you can create within your Alibaba Cloud account. For more information see [RAM role overview](https://www.alibabacloud.com/help/en/resource-access-management/latest/ram-role-overview).
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
     */
    public val scaleApRoNumMax: Output<Int>
        get() = javaResource.scaleApRoNumMax().applyValue({ args0 -> args0 })

    /**
     * Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
     */
    public val scaleApRoNumMin: Output<Int>
        get() = javaResource.scaleApRoNumMin().applyValue({ args0 -> args0 })

    /**
     * The maximum number of PCUs per node for scaling. Valid values: 1 PCU to 32 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    public val scaleMax: Output<Int>?
        get() = javaResource.scaleMax().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The minimum number of PCUs per node for scaling. Valid values: 1 PCU to 31 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`.  This parameter is valid only for serverless clusters.
     */
    public val scaleMin: Output<Int>?
        get() = javaResource.scaleMin().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum number of read-only nodes for scaling. Valid values: 0 to 15. It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7. It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    public val scaleRoNumMax: Output<Int>?
        get() = javaResource.scaleRoNumMax().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum number of read-only nodes for scaling. Valid values: 0 to 15 . It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7 .It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    public val scaleRoNumMin: Output<Int>?
        get() = javaResource.scaleRoNumMin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The detection period for No-activity Suspension. Valid values: 300 to 86,4005. Unit: seconds. The detection duration must be a multiple of 300 seconds. This parameter is valid only for serverless clusters.
     */
    public val secondsUntilAutoPause: Output<Int>
        get() = javaResource.secondsUntilAutoPause().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group. Separate multiple security groups with commas (,). You can add a maximum of three security groups to a cluster.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * This attribute has been deprecated from v1.130.0 and using `db_cluster_ip_array` sub-element `security_ips` instead.
     * Its value is same as `db_cluster_ip_array` sub-element `security_ips` value and its db_cluster_ip_array_name is "default".
     */
    public val securityIps: Output<List<String>>
        get() = javaResource.securityIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Serverless steady-state switch. Valid values are `ON`, `OFF`. This parameter is valid only for serverless clusters.
     * > **NOTE:** When serverless_steady_switch is `ON` and serverless_type is `SteadyServerless`, parameters `scale_min`, `scale_max`, `scale_ro_num_min` and `scale_ro_num_max` are all required.
     */
    public val serverlessSteadySwitch: Output<String>?
        get() = javaResource.serverlessSteadySwitch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the serverless cluster. Valid values `AgileServerless`, `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    public val serverlessType: Output<String>?
        get() = javaResource.serverlessType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the source RDS instance or the ID of the source PolarDB cluster. This parameter is required only when CreationOption is set to MigrationFromRDS, CloneFromRDS, or CloneFromPolarDB.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `SourceResourceId`.
     */
    public val sourceResourceId: Output<String>?
        get() = javaResource.sourceResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available since 1.204.1) PolarDB cluster status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The billing method of the storage. Valid values `Postpaid`, `Prepaid`.
     */
    public val storagePayType: Output<String>
        get() = javaResource.storagePayType().applyValue({ args0 -> args0 })

    /**
     * Storage space charged by space (monthly package). Unit: GB.
     * > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
     * > **NOTE:**  Valid values for PolarDB for MySQL Enterprise Edition: 50 to 100000.It is valid when pay_type is `PrePaid`.
     */
    public val storageSpace: Output<Int>
        get() = javaResource.storageSpace().applyValue({ args0 -> args0 })

    /**
     * The storage type of the cluster. Enterprise storage type values are `PSL5`, `PSL4`. The standard version storage type values are `ESSDPL1`, `ESSDPL2`, `ESSDPL3`. The standard version only supports MySQL.
     * > **NOTE:** Serverless cluster does not support this parameter.
     */
    public val storageType: Output<String>
        get() = javaResource.storageType().applyValue({ args0 -> args0 })

    /**
     * The category of the cluster. Valid values are `Exclusive`, `General`. Only MySQL supports.
     */
    public val subCategory: Output<String>
        get() = javaResource.subCategory().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersion](https://www.alibabacloud.com/help/en/polardb/latest/describedbclusterversion) interface.
     */
    public val targetDbRevisionVersionCode: Output<String>?
        get() = javaResource.targetDbRevisionVersionCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available since 1.200.0) The region where the TDE key resides.
     * > **NOTE:** TDE can be enabled on clusters that have joined a global database network (GDN). After TDE is enabled on the primary cluster in a GDN, TDE is enabled on the secondary clusters in the GDN by default. The key used by the secondary clusters and the region for the key resides must be the same as the primary cluster. The region of the key cannot be modified.
     * > **NOTE:** You cannot enable TDE for the secondary clusters in a GDN. Used to view user KMS activation status.
     */
    public val tdeRegion: Output<String>
        get() = javaResource.tdeRegion().applyValue({ args0 -> args0 })

    /**
     * turn on TDE encryption. Valid values are `Enabled`, `Disabled`. Default to `Disabled`. TDE cannot be closed after it is turned on.
     * > **NOTE:** `tde_status` Cannot modify after created when `db_type` is `PostgreSQL` or `Oracle`.`tde_status` only support modification from `Disabled` to `Enabled` when `db_type` is `MySQL`.
     */
    public val tdeStatus: Output<String>?
        get() = javaResource.tdeStatus().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Version upgrade type. Valid values are PROXY, DB, ALL. PROXY means upgrading the proxy version, DB means upgrading the db version, ALL means upgrading both db and proxy versions simultaneously.
     */
    public val upgradeType: Output<String>?
        get() = javaResource.upgradeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The virtual switch ID to launch DB instances in one VPC.
     * > **NOTE:** If vswitch_id is not specified, system will get a vswitch belongs to the user automatically.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Zone to launch the DB cluster. it supports multiple zone.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.polardb.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.alicloud.polardb.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
