@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.ClusterArgs.builder
import com.pulumi.alicloud.polardb.kotlin.inputs.ClusterDbClusterIpArrayArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.ClusterDbClusterIpArrayArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.ClusterParameterArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.ClusterParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * PolarDB cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/cluster:Cluster example pc-abc12345678
 * ```
 * @property allowShutDown Specifies whether to enable the no-activity suspension feature. Default value: false. Valid values are `true`, `false`. This parameter is valid only for serverless clusters.
 * @property autoRenewPeriod Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
 * @property backupRetentionPolicyOnClusterDeletion The retention policy for the backup sets when you delete the cluster.  Valid values are `ALL`, `LATEST`, `NONE`. Value options can refer to the latest docs [DeleteDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/deletedbcluster-1)
 * @property cloneDataPoint The time point of data to be cloned. Valid values are `LATEST`,`BackupID`,`Timestamp`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CloneDataPoint`.
 * > **NOTE:** If CreationOption is set to CloneFromRDS, the value of this parameter must be LATEST.
 * @property collectorStatus Specifies whether to enable or disable SQL data collector. Valid values are `Enable`, `Disabled`.
 * @property creationCategory The edition of the PolarDB service. Valid values are `Normal`,`Basic`,`ArchiveNormal`,`NormalMultimaster`,`SENormal`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationCategory`.
 * > **NOTE:** You can set this parameter to Basic only when DBType is set to MySQL and DBVersion is set to 5.6, 5.7, or 8.0. You can set this parameter to Archive only when DBType is set to MySQL and DBVersion is set to 8.0. From version 1.188.0, `creation_category` can be set to `NormalMultimaster`. From version 1.203.0, `creation_category` can be set to `SENormal`.
 * @property creationOption The method that is used to create a cluster. Valid values are `Normal`,`CloneFromPolarDB`,`CloneFromRDS`,`MigrationFromRDS`,`CreateGdnStandby`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationOption`.
 * > **NOTE:** The default value is Normal. If DBType is set to MySQL and DBVersion is set to 5.6 or 5.7, this parameter can be set to CloneFromRDS or MigrationFromRDS. If DBType is set to MySQL and DBVersion is set to 8.0, this parameter can be set to CreateGdnStandby.
 * @property dbClusterIpArrays db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
 * @property dbNodeClass The db_node_class of cluster node.
 * > **NOTE:** Node specifications are divided into cluster version, single node version and History Library version. They can't change each other, but the general specification and exclusive specification of cluster version can be changed.
 * From version 1.204.0, If you need to create a Serverless cluster, `db_node_class` can be set to `polar.mysql.sl.small`.
 * @property dbNodeCount Number of the PolarDB cluster nodes, default is 2(Each cluster must contain at least a primary node and a read-only node). Add/remove nodes by modifying this parameter, valid values: [2~16].
 * > **NOTE:** To avoid adding or removing multiple read-only nodes by mistake, the system allows you to add or remove one read-only node at a time.
 * @property dbNodeId The ID of the node or node subscript. Node subscript values: 1 to 15.
 * @property dbNodeNum The number of Standard Edition nodes. Default value: `1`. Valid values are `1`, `2`.
 * @property dbType Database type. Value options: MySQL, Oracle, PostgreSQL.
 * @property dbVersion Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
 * @property defaultTimeZone The time zone of the cluster. You can set the parameter to a value that is on the hour from -12:00 to +13:00 based on UTC. Example: 00:00. Default value: SYSTEM. This value indicates that the time zone of the cluster is the same as the time zone of the region.
 * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
 * @property deletionLock turn on table deletion_lock. Valid values are 0, 1. 1 means to open the cluster protection lock, 0 means to close the cluster protection lock
 * > **NOTE:**  Cannot modify after created when `pay_type` is `Prepaid` .`deletion_lock` the cluster protection lock can be turned on or off when `pay_type` is `Postpaid`.
 * @property description The description of cluster.
 * @property encryptNewTables turn on table auto encryption. Valid values are `ON`, `OFF`. Only MySQL 8.0 supports.
 * > **NOTE:** `encrypt_new_tables` Polardb MySQL 8.0 cluster, after TDE and Automatic Encryption are enabled, all newly created tables are automatically encrypted in the cluster.
 * @property encryptionKey The ID of the custom key. `encryption_key` cannot be modified after TDE is opened.
 * @property fromTimeService Immediate or scheduled kernel version upgrade. Valid values are `true`, `false`. True means immediate execution, False means scheduled execution.
 * @property gdnId The ID of the global database network (GDN).
 * > **NOTE:** This parameter is required if CreationOption is set to CreateGdnStandby.
 * @property hotReplicaMode Indicates whether the hot standby feature is enabled. Valid values are `ON`, `OFF`. Only MySQL supports.
 * @property hotStandbyCluster Whether to enable the hot standby cluster. Valid values are `ON`, `OFF`. Only MySQL supports.
 * @property imciSwitch Specifies whether to enable the In-Memory Column Index (IMCI) feature. Valid values are `ON`, `OFF`.
 * > **NOTE:**  Only polardb MySQL Cluster version is available. The cluster with minor version number of 8.0.1 supports the column index feature, and the specific kernel version must be 8.0.1.1.22 or above.
 * > **NOTE:**  The single node, the single node version of the history library, and the cluster version of the history library do not support column save indexes.
 * @property loosePolarLogBin Enable the Binlog function. Default value: `OFF`. Valid values are `OFF`, `ON`.
 * > **NOTE:** This parameter is valid only MySQL Engine supports.
 * @property lowerCaseTableNames Specifies whether the table names are case-sensitive. Default value: `1`.  Valid values are `1`, `0`.
 * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
 * @property maintainTime Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
 * @property modifyType Use as `db_node_class` change class, define upgrade or downgrade. Valid values are `Upgrade`, `Downgrade`, Default to `Upgrade`.
 * @property parameterGroupId The ID of the parameter template
 * > **NOTE:** You can call the [DescribeParameterGroups](https://www.alibabacloud.com/help/en/polardb/latest/describeparametergroups) operation to query the details of all parameter templates of a specified region, such as the ID of a parameter template.
 * @property parameters Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
 * @property payType Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
 * @property period The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property plannedEndTime The latest time to start executing the target scheduled task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
 * > **NOTE:** The latest time must be 30 minutes or more later than the start time. If PlannedStartTime is set but this parameter is not specified, the latest time to execute the target task defaults to the start time+30 minutes. For example, when the PlannedStartTime is set to 2021-01-14T09:00:00Z and this parameter is left blank, the target task will start executing at the latest on 2021-01-14T09:30:00Z.
 * @property plannedStartTime The earliest time to start executing a scheduled (i.e. within the target time period) kernel version upgrade task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
 * > **NOTE:** The starting time range is any time point within the next 24 hours. For example, the current time is 2021-01-14T09:00:00Z, and the allowed start time range for filling in here is 2021-01-14T09:00:00Z~2021-01-15T09:00:00Z. If this parameter is left blank, the kernel version upgrade task will be executed immediately by default.
 * @property proxyClass The specifications of the Standard Edition PolarProxy. Available parameters can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1)
 * > **NOTE:** This parameter is valid only for standard edition clusters.
 * @property proxyType The type of PolarProxy. Valid values are `EXCLUSIVE` `GENERAL`.
 * > **NOTE:** This parameter is valid for both standard and enterprise clusters.
 * @property renewalStatus Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
 * @property resourceGroupId The ID of resource group which the PolarDB cluster belongs. If not specified, then it belongs to the default resource group.
 * @property roleArn The Alibaba Cloud Resource Name (ARN) of the RAM role. A RAM role is a virtual identity that you can create within your Alibaba Cloud account. For more information see [RAM role overview](https://www.alibabacloud.com/help/en/resource-access-management/latest/ram-role-overview).
 * @property scaleApRoNumMax Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
 * @property scaleApRoNumMin Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
 * @property scaleMax The maximum number of PCUs per node for scaling. Valid values: 1 PCU to 32 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
 * @property scaleMin The minimum number of PCUs per node for scaling. Valid values: 1 PCU to 31 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`.  This parameter is valid only for serverless clusters.
 * @property scaleRoNumMax The maximum number of read-only nodes for scaling. Valid values: 0 to 15. It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7. It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
 * @property scaleRoNumMin The minimum number of read-only nodes for scaling. Valid values: 0 to 15 . It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7 .It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
 * @property secondsUntilAutoPause The detection period for No-activity Suspension. Valid values: 300 to 86,4005. Unit: seconds. The detection duration must be a multiple of 300 seconds. This parameter is valid only for serverless clusters.
 * @property securityGroupIds The ID of the security group. Separate multiple security groups with commas (,). You can add a maximum of three security groups to a cluster.
 * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~20 minutes. Please make full preparation before changing them.
 * @property securityIps This attribute has been deprecated from v1.130.0 and using `db_cluster_ip_array` sub-element `security_ips` instead.
 * Its value is same as `db_cluster_ip_array` sub-element `security_ips` value and its db_cluster_ip_array_name is "default".
 * @property serverlessSteadySwitch Serverless steady-state switch. Valid values are `ON`, `OFF`. This parameter is valid only for serverless clusters.
 * > **NOTE:** When serverless_steady_switch is `ON` and serverless_type is `SteadyServerless`, parameters `scale_min`, `scale_max`, `scale_ro_num_min` and `scale_ro_num_max` are all required.
 * @property serverlessType The type of the serverless cluster. Valid values `AgileServerless`, `SteadyServerless`. This parameter is valid only for serverless clusters.
 * @property sourceResourceId The ID of the source RDS instance or the ID of the source PolarDB cluster. This parameter is required only when CreationOption is set to MigrationFromRDS, CloneFromRDS, or CloneFromPolarDB.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `SourceResourceId`.
 * @property storagePayType The billing method of the storage. Valid values `Postpaid`, `Prepaid`.
 * @property storageSpace Storage space charged by space (monthly package). Unit: GB.
 * > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
 * > **NOTE:**  Valid values for PolarDB for MySQL Enterprise Edition: 50 to 100000.It is valid when pay_type is `PrePaid`.
 * @property storageType The storage type of the cluster. Enterprise storage type values are `PSL5`, `PSL4`. The standard version storage type values are `ESSDPL1`, `ESSDPL2`, `ESSDPL3`. The standard version only supports MySQL.
 * > **NOTE:** Serverless cluster does not support this parameter.
 * @property subCategory The category of the cluster. Valid values are `Exclusive`, `General`. Only MySQL supports.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property targetDbRevisionVersionCode The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersion](https://www.alibabacloud.com/help/en/polardb/latest/describedbclusterversion) interface.
 * @property tdeStatus turn on TDE encryption. Valid values are `Enabled`, `Disabled`. Default to `Disabled`. TDE cannot be closed after it is turned on.
 * > **NOTE:** `tde_status` Cannot modify after created when `db_type` is `PostgreSQL` or `Oracle`.`tde_status` only support modification from `Disabled` to `Enabled` when `db_type` is `MySQL`.
 * @property upgradeType Version upgrade type. Valid values are PROXY, DB, ALL. PROXY means upgrading the proxy version, DB means upgrading the db version, ALL means upgrading both db and proxy versions simultaneously.
 * @property vpcId The id of the VPC.
 * @property vswitchId The virtual switch ID to launch DB instances in one VPC.
 * > **NOTE:** If vswitch_id is not specified, system will get a vswitch belongs to the user automatically.
 * @property zoneId The Zone to launch the DB cluster. it supports multiple zone.
 */
public data class ClusterArgs(
    public val allowShutDown: Output<String>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val backupRetentionPolicyOnClusterDeletion: Output<String>? = null,
    public val cloneDataPoint: Output<String>? = null,
    public val collectorStatus: Output<String>? = null,
    public val creationCategory: Output<String>? = null,
    public val creationOption: Output<String>? = null,
    public val dbClusterIpArrays: Output<List<ClusterDbClusterIpArrayArgs>>? = null,
    public val dbNodeClass: Output<String>? = null,
    public val dbNodeCount: Output<Int>? = null,
    public val dbNodeId: Output<String>? = null,
    public val dbNodeNum: Output<Int>? = null,
    public val dbType: Output<String>? = null,
    public val dbVersion: Output<String>? = null,
    public val defaultTimeZone: Output<String>? = null,
    public val deletionLock: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val encryptNewTables: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val fromTimeService: Output<String>? = null,
    public val gdnId: Output<String>? = null,
    public val hotReplicaMode: Output<String>? = null,
    public val hotStandbyCluster: Output<String>? = null,
    public val imciSwitch: Output<String>? = null,
    public val loosePolarLogBin: Output<String>? = null,
    public val lowerCaseTableNames: Output<Int>? = null,
    public val maintainTime: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    public val parameterGroupId: Output<String>? = null,
    public val parameters: Output<List<ClusterParameterArgs>>? = null,
    public val payType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val plannedEndTime: Output<String>? = null,
    public val plannedStartTime: Output<String>? = null,
    public val proxyClass: Output<String>? = null,
    public val proxyType: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val scaleApRoNumMax: Output<Int>? = null,
    public val scaleApRoNumMin: Output<Int>? = null,
    public val scaleMax: Output<Int>? = null,
    public val scaleMin: Output<Int>? = null,
    public val scaleRoNumMax: Output<Int>? = null,
    public val scaleRoNumMin: Output<Int>? = null,
    public val secondsUntilAutoPause: Output<Int>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val securityIps: Output<List<String>>? = null,
    public val serverlessSteadySwitch: Output<String>? = null,
    public val serverlessType: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val storagePayType: Output<String>? = null,
    public val storageSpace: Output<Int>? = null,
    public val storageType: Output<String>? = null,
    public val subCategory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetDbRevisionVersionCode: Output<String>? = null,
    public val tdeStatus: Output<String>? = null,
    public val upgradeType: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.ClusterArgs =
        com.pulumi.alicloud.polardb.ClusterArgs.builder()
            .allowShutDown(allowShutDown?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .backupRetentionPolicyOnClusterDeletion(
                backupRetentionPolicyOnClusterDeletion?.applyValue({ args0 ->
                    args0
                }),
            )
            .cloneDataPoint(cloneDataPoint?.applyValue({ args0 -> args0 }))
            .collectorStatus(collectorStatus?.applyValue({ args0 -> args0 }))
            .creationCategory(creationCategory?.applyValue({ args0 -> args0 }))
            .creationOption(creationOption?.applyValue({ args0 -> args0 }))
            .dbClusterIpArrays(
                dbClusterIpArrays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dbNodeClass(dbNodeClass?.applyValue({ args0 -> args0 }))
            .dbNodeCount(dbNodeCount?.applyValue({ args0 -> args0 }))
            .dbNodeId(dbNodeId?.applyValue({ args0 -> args0 }))
            .dbNodeNum(dbNodeNum?.applyValue({ args0 -> args0 }))
            .dbType(dbType?.applyValue({ args0 -> args0 }))
            .dbVersion(dbVersion?.applyValue({ args0 -> args0 }))
            .defaultTimeZone(defaultTimeZone?.applyValue({ args0 -> args0 }))
            .deletionLock(deletionLock?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptNewTables(encryptNewTables?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .fromTimeService(fromTimeService?.applyValue({ args0 -> args0 }))
            .gdnId(gdnId?.applyValue({ args0 -> args0 }))
            .hotReplicaMode(hotReplicaMode?.applyValue({ args0 -> args0 }))
            .hotStandbyCluster(hotStandbyCluster?.applyValue({ args0 -> args0 }))
            .imciSwitch(imciSwitch?.applyValue({ args0 -> args0 }))
            .loosePolarLogBin(loosePolarLogBin?.applyValue({ args0 -> args0 }))
            .lowerCaseTableNames(lowerCaseTableNames?.applyValue({ args0 -> args0 }))
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .parameterGroupId(parameterGroupId?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .payType(payType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .plannedEndTime(plannedEndTime?.applyValue({ args0 -> args0 }))
            .plannedStartTime(plannedStartTime?.applyValue({ args0 -> args0 }))
            .proxyClass(proxyClass?.applyValue({ args0 -> args0 }))
            .proxyType(proxyType?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .scaleApRoNumMax(scaleApRoNumMax?.applyValue({ args0 -> args0 }))
            .scaleApRoNumMin(scaleApRoNumMin?.applyValue({ args0 -> args0 }))
            .scaleMax(scaleMax?.applyValue({ args0 -> args0 }))
            .scaleMin(scaleMin?.applyValue({ args0 -> args0 }))
            .scaleRoNumMax(scaleRoNumMax?.applyValue({ args0 -> args0 }))
            .scaleRoNumMin(scaleRoNumMin?.applyValue({ args0 -> args0 }))
            .secondsUntilAutoPause(secondsUntilAutoPause?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serverlessSteadySwitch(serverlessSteadySwitch?.applyValue({ args0 -> args0 }))
            .serverlessType(serverlessType?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .storagePayType(storagePayType?.applyValue({ args0 -> args0 }))
            .storageSpace(storageSpace?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .subCategory(subCategory?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetDbRevisionVersionCode(targetDbRevisionVersionCode?.applyValue({ args0 -> args0 }))
            .tdeStatus(tdeStatus?.applyValue({ args0 -> args0 }))
            .upgradeType(upgradeType?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var allowShutDown: Output<String>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var backupRetentionPolicyOnClusterDeletion: Output<String>? = null

    private var cloneDataPoint: Output<String>? = null

    private var collectorStatus: Output<String>? = null

    private var creationCategory: Output<String>? = null

    private var creationOption: Output<String>? = null

    private var dbClusterIpArrays: Output<List<ClusterDbClusterIpArrayArgs>>? = null

    private var dbNodeClass: Output<String>? = null

    private var dbNodeCount: Output<Int>? = null

    private var dbNodeId: Output<String>? = null

    private var dbNodeNum: Output<Int>? = null

    private var dbType: Output<String>? = null

    private var dbVersion: Output<String>? = null

    private var defaultTimeZone: Output<String>? = null

    private var deletionLock: Output<Int>? = null

    private var description: Output<String>? = null

    private var encryptNewTables: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var fromTimeService: Output<String>? = null

    private var gdnId: Output<String>? = null

    private var hotReplicaMode: Output<String>? = null

    private var hotStandbyCluster: Output<String>? = null

    private var imciSwitch: Output<String>? = null

    private var loosePolarLogBin: Output<String>? = null

    private var lowerCaseTableNames: Output<Int>? = null

    private var maintainTime: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var parameterGroupId: Output<String>? = null

    private var parameters: Output<List<ClusterParameterArgs>>? = null

    private var payType: Output<String>? = null

    private var period: Output<Int>? = null

    private var plannedEndTime: Output<String>? = null

    private var plannedStartTime: Output<String>? = null

    private var proxyClass: Output<String>? = null

    private var proxyType: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var scaleApRoNumMax: Output<Int>? = null

    private var scaleApRoNumMin: Output<Int>? = null

    private var scaleMax: Output<Int>? = null

    private var scaleMin: Output<Int>? = null

    private var scaleRoNumMax: Output<Int>? = null

    private var scaleRoNumMin: Output<Int>? = null

    private var secondsUntilAutoPause: Output<Int>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var securityIps: Output<List<String>>? = null

    private var serverlessSteadySwitch: Output<String>? = null

    private var serverlessType: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var storagePayType: Output<String>? = null

    private var storageSpace: Output<Int>? = null

    private var storageType: Output<String>? = null

    private var subCategory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetDbRevisionVersionCode: Output<String>? = null

    private var tdeStatus: Output<String>? = null

    private var upgradeType: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Specifies whether to enable the no-activity suspension feature. Default value: false. Valid values are `true`, `false`. This parameter is valid only for serverless clusters.
     */
    @JvmName("levsicviafddlibs")
    public suspend fun allowShutDown(`value`: Output<String>) {
        this.allowShutDown = value
    }

    /**
     * @param value Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
     */
    @JvmName("wqnnqbvmsfdxxdgs")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The retention policy for the backup sets when you delete the cluster.  Valid values are `ALL`, `LATEST`, `NONE`. Value options can refer to the latest docs [DeleteDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/deletedbcluster-1)
     */
    @JvmName("haagdquepnsynvdi")
    public suspend fun backupRetentionPolicyOnClusterDeletion(`value`: Output<String>) {
        this.backupRetentionPolicyOnClusterDeletion = value
    }

    /**
     * @param value The time point of data to be cloned. Valid values are `LATEST`,`BackupID`,`Timestamp`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CloneDataPoint`.
     * > **NOTE:** If CreationOption is set to CloneFromRDS, the value of this parameter must be LATEST.
     */
    @JvmName("awcqjisabhdqcjuw")
    public suspend fun cloneDataPoint(`value`: Output<String>) {
        this.cloneDataPoint = value
    }

    /**
     * @param value Specifies whether to enable or disable SQL data collector. Valid values are `Enable`, `Disabled`.
     */
    @JvmName("fdyevqpwoifsygim")
    public suspend fun collectorStatus(`value`: Output<String>) {
        this.collectorStatus = value
    }

    /**
     * @param value The edition of the PolarDB service. Valid values are `Normal`,`Basic`,`ArchiveNormal`,`NormalMultimaster`,`SENormal`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationCategory`.
     * > **NOTE:** You can set this parameter to Basic only when DBType is set to MySQL and DBVersion is set to 5.6, 5.7, or 8.0. You can set this parameter to Archive only when DBType is set to MySQL and DBVersion is set to 8.0. From version 1.188.0, `creation_category` can be set to `NormalMultimaster`. From version 1.203.0, `creation_category` can be set to `SENormal`.
     */
    @JvmName("iseqhxfibuxhlprf")
    public suspend fun creationCategory(`value`: Output<String>) {
        this.creationCategory = value
    }

    /**
     * @param value The method that is used to create a cluster. Valid values are `Normal`,`CloneFromPolarDB`,`CloneFromRDS`,`MigrationFromRDS`,`CreateGdnStandby`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationOption`.
     * > **NOTE:** The default value is Normal. If DBType is set to MySQL and DBVersion is set to 5.6 or 5.7, this parameter can be set to CloneFromRDS or MigrationFromRDS. If DBType is set to MySQL and DBVersion is set to 8.0, this parameter can be set to CreateGdnStandby.
     */
    @JvmName("fptgnpexgvxikvhu")
    public suspend fun creationOption(`value`: Output<String>) {
        this.creationOption = value
    }

    /**
     * @param value db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    @JvmName("jjyitmyigugknkba")
    public suspend fun dbClusterIpArrays(`value`: Output<List<ClusterDbClusterIpArrayArgs>>) {
        this.dbClusterIpArrays = value
    }

    @JvmName("jawnoksqampafmul")
    public suspend fun dbClusterIpArrays(vararg values: Output<ClusterDbClusterIpArrayArgs>) {
        this.dbClusterIpArrays = Output.all(values.asList())
    }

    /**
     * @param values db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    @JvmName("vvvwmfyswqafxkjb")
    public suspend fun dbClusterIpArrays(values: List<Output<ClusterDbClusterIpArrayArgs>>) {
        this.dbClusterIpArrays = Output.all(values)
    }

    /**
     * @param value The db_node_class of cluster node.
     * > **NOTE:** Node specifications are divided into cluster version, single node version and History Library version. They can't change each other, but the general specification and exclusive specification of cluster version can be changed.
     * From version 1.204.0, If you need to create a Serverless cluster, `db_node_class` can be set to `polar.mysql.sl.small`.
     */
    @JvmName("tmugrrdvywyoqiiy")
    public suspend fun dbNodeClass(`value`: Output<String>) {
        this.dbNodeClass = value
    }

    /**
     * @param value Number of the PolarDB cluster nodes, default is 2(Each cluster must contain at least a primary node and a read-only node). Add/remove nodes by modifying this parameter, valid values: [2~16].
     * > **NOTE:** To avoid adding or removing multiple read-only nodes by mistake, the system allows you to add or remove one read-only node at a time.
     */
    @JvmName("xnukhceugmsxtdbh")
    public suspend fun dbNodeCount(`value`: Output<Int>) {
        this.dbNodeCount = value
    }

    /**
     * @param value The ID of the node or node subscript. Node subscript values: 1 to 15.
     */
    @JvmName("khvmtgpxyetxamxf")
    public suspend fun dbNodeId(`value`: Output<String>) {
        this.dbNodeId = value
    }

    /**
     * @param value The number of Standard Edition nodes. Default value: `1`. Valid values are `1`, `2`.
     */
    @JvmName("nbnqffsteuvbwdxd")
    public suspend fun dbNodeNum(`value`: Output<Int>) {
        this.dbNodeNum = value
    }

    /**
     * @param value Database type. Value options: MySQL, Oracle, PostgreSQL.
     */
    @JvmName("ehgaavkmihdrnlyr")
    public suspend fun dbType(`value`: Output<String>) {
        this.dbType = value
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
     */
    @JvmName("fcwkwbnvbqrashxy")
    public suspend fun dbVersion(`value`: Output<String>) {
        this.dbVersion = value
    }

    /**
     * @param value The time zone of the cluster. You can set the parameter to a value that is on the hour from -12:00 to +13:00 based on UTC. Example: 00:00. Default value: SYSTEM. This value indicates that the time zone of the cluster is the same as the time zone of the region.
     * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
     */
    @JvmName("efbvhhnaivlcakay")
    public suspend fun defaultTimeZone(`value`: Output<String>) {
        this.defaultTimeZone = value
    }

    /**
     * @param value turn on table deletion_lock. Valid values are 0, 1. 1 means to open the cluster protection lock, 0 means to close the cluster protection lock
     * > **NOTE:**  Cannot modify after created when `pay_type` is `Prepaid` .`deletion_lock` the cluster protection lock can be turned on or off when `pay_type` is `Postpaid`.
     */
    @JvmName("fxwrxreowoddaxgp")
    public suspend fun deletionLock(`value`: Output<Int>) {
        this.deletionLock = value
    }

    /**
     * @param value The description of cluster.
     */
    @JvmName("vmbcfjxdjmaohwjb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value turn on table auto encryption. Valid values are `ON`, `OFF`. Only MySQL 8.0 supports.
     * > **NOTE:** `encrypt_new_tables` Polardb MySQL 8.0 cluster, after TDE and Automatic Encryption are enabled, all newly created tables are automatically encrypted in the cluster.
     */
    @JvmName("awohcwmarhryiwad")
    public suspend fun encryptNewTables(`value`: Output<String>) {
        this.encryptNewTables = value
    }

    /**
     * @param value The ID of the custom key. `encryption_key` cannot be modified after TDE is opened.
     */
    @JvmName("jrqcmpmiqlnqtyud")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Immediate or scheduled kernel version upgrade. Valid values are `true`, `false`. True means immediate execution, False means scheduled execution.
     */
    @JvmName("eghdsbceqnkokiji")
    public suspend fun fromTimeService(`value`: Output<String>) {
        this.fromTimeService = value
    }

    /**
     * @param value The ID of the global database network (GDN).
     * > **NOTE:** This parameter is required if CreationOption is set to CreateGdnStandby.
     */
    @JvmName("pbsylxussnephhhg")
    public suspend fun gdnId(`value`: Output<String>) {
        this.gdnId = value
    }

    /**
     * @param value Indicates whether the hot standby feature is enabled. Valid values are `ON`, `OFF`. Only MySQL supports.
     */
    @JvmName("nkthunijoxgxfxrw")
    public suspend fun hotReplicaMode(`value`: Output<String>) {
        this.hotReplicaMode = value
    }

    /**
     * @param value Whether to enable the hot standby cluster. Valid values are `ON`, `OFF`. Only MySQL supports.
     */
    @JvmName("hfliryxqbtlgrkqr")
    public suspend fun hotStandbyCluster(`value`: Output<String>) {
        this.hotStandbyCluster = value
    }

    /**
     * @param value Specifies whether to enable the In-Memory Column Index (IMCI) feature. Valid values are `ON`, `OFF`.
     * > **NOTE:**  Only polardb MySQL Cluster version is available. The cluster with minor version number of 8.0.1 supports the column index feature, and the specific kernel version must be 8.0.1.1.22 or above.
     * > **NOTE:**  The single node, the single node version of the history library, and the cluster version of the history library do not support column save indexes.
     */
    @JvmName("gjyxwjaugaqotxnb")
    public suspend fun imciSwitch(`value`: Output<String>) {
        this.imciSwitch = value
    }

    /**
     * @param value Enable the Binlog function. Default value: `OFF`. Valid values are `OFF`, `ON`.
     * > **NOTE:** This parameter is valid only MySQL Engine supports.
     */
    @JvmName("eoyitajfyrtqicva")
    public suspend fun loosePolarLogBin(`value`: Output<String>) {
        this.loosePolarLogBin = value
    }

    /**
     * @param value Specifies whether the table names are case-sensitive. Default value: `1`.  Valid values are `1`, `0`.
     * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
     */
    @JvmName("gplyrjrnlvufnobl")
    public suspend fun lowerCaseTableNames(`value`: Output<Int>) {
        this.lowerCaseTableNames = value
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("uowcxbpkiivobaas")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value Use as `db_node_class` change class, define upgrade or downgrade. Valid values are `Upgrade`, `Downgrade`, Default to `Upgrade`.
     */
    @JvmName("cklcgqwofskjaedn")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value The ID of the parameter template
     * > **NOTE:** You can call the [DescribeParameterGroups](https://www.alibabacloud.com/help/en/polardb/latest/describeparametergroups) operation to query the details of all parameter templates of a specified region, such as the ID of a parameter template.
     */
    @JvmName("vbdamfeqjfxcgghn")
    public suspend fun parameterGroupId(`value`: Output<String>) {
        this.parameterGroupId = value
    }

    /**
     * @param value Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    @JvmName("gbwpdnuafdrseoqc")
    public suspend fun parameters(`value`: Output<List<ClusterParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("qckxmgxtijkwqvch")
    public suspend fun parameters(vararg values: Output<ClusterParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    @JvmName("wbfvuovhswuxwlum")
    public suspend fun parameters(values: List<Output<ClusterParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
     */
    @JvmName("jhvlmwqqgcqkudbd")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("jkpoeqtcjvvvbjlu")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The latest time to start executing the target scheduled task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
     * > **NOTE:** The latest time must be 30 minutes or more later than the start time. If PlannedStartTime is set but this parameter is not specified, the latest time to execute the target task defaults to the start time+30 minutes. For example, when the PlannedStartTime is set to 2021-01-14T09:00:00Z and this parameter is left blank, the target task will start executing at the latest on 2021-01-14T09:30:00Z.
     */
    @JvmName("uskiebqxtwetodya")
    public suspend fun plannedEndTime(`value`: Output<String>) {
        this.plannedEndTime = value
    }

    /**
     * @param value The earliest time to start executing a scheduled (i.e. within the target time period) kernel version upgrade task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
     * > **NOTE:** The starting time range is any time point within the next 24 hours. For example, the current time is 2021-01-14T09:00:00Z, and the allowed start time range for filling in here is 2021-01-14T09:00:00Z~2021-01-15T09:00:00Z. If this parameter is left blank, the kernel version upgrade task will be executed immediately by default.
     */
    @JvmName("hcertkgbndwvespe")
    public suspend fun plannedStartTime(`value`: Output<String>) {
        this.plannedStartTime = value
    }

    /**
     * @param value The specifications of the Standard Edition PolarProxy. Available parameters can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1)
     * > **NOTE:** This parameter is valid only for standard edition clusters.
     */
    @JvmName("jcmtshghluamfcnc")
    public suspend fun proxyClass(`value`: Output<String>) {
        this.proxyClass = value
    }

    /**
     * @param value The type of PolarProxy. Valid values are `EXCLUSIVE` `GENERAL`.
     * > **NOTE:** This parameter is valid for both standard and enterprise clusters.
     */
    @JvmName("saqpvksxaqgybfol")
    public suspend fun proxyType(`value`: Output<String>) {
        this.proxyType = value
    }

    /**
     * @param value Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    @JvmName("cdmcggttmbnxfkvv")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The ID of resource group which the PolarDB cluster belongs. If not specified, then it belongs to the default resource group.
     */
    @JvmName("oumgupexphrlnofc")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the RAM role. A RAM role is a virtual identity that you can create within your Alibaba Cloud account. For more information see [RAM role overview](https://www.alibabacloud.com/help/en/resource-access-management/latest/ram-role-overview).
     */
    @JvmName("ijwqmthyiqoxnrlj")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
     */
    @JvmName("jxnekmrswtqmnsfh")
    public suspend fun scaleApRoNumMax(`value`: Output<Int>) {
        this.scaleApRoNumMax = value
    }

    /**
     * @param value Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
     */
    @JvmName("klgptrilxqdmqica")
    public suspend fun scaleApRoNumMin(`value`: Output<Int>) {
        this.scaleApRoNumMin = value
    }

    /**
     * @param value The maximum number of PCUs per node for scaling. Valid values: 1 PCU to 32 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("eavnwxvxbqysagna")
    public suspend fun scaleMax(`value`: Output<Int>) {
        this.scaleMax = value
    }

    /**
     * @param value The minimum number of PCUs per node for scaling. Valid values: 1 PCU to 31 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`.  This parameter is valid only for serverless clusters.
     */
    @JvmName("yimtnbirkjbmjyds")
    public suspend fun scaleMin(`value`: Output<Int>) {
        this.scaleMin = value
    }

    /**
     * @param value The maximum number of read-only nodes for scaling. Valid values: 0 to 15. It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7. It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("pxagfghrvruicmts")
    public suspend fun scaleRoNumMax(`value`: Output<Int>) {
        this.scaleRoNumMax = value
    }

    /**
     * @param value The minimum number of read-only nodes for scaling. Valid values: 0 to 15 . It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7 .It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("ydwiqhexyjagiwqm")
    public suspend fun scaleRoNumMin(`value`: Output<Int>) {
        this.scaleRoNumMin = value
    }

    /**
     * @param value The detection period for No-activity Suspension. Valid values: 300 to 86,4005. Unit: seconds. The detection duration must be a multiple of 300 seconds. This parameter is valid only for serverless clusters.
     */
    @JvmName("dokpsxsnwjsinkpw")
    public suspend fun secondsUntilAutoPause(`value`: Output<Int>) {
        this.secondsUntilAutoPause = value
    }

    /**
     * @param value The ID of the security group. Separate multiple security groups with commas (,). You can add a maximum of three security groups to a cluster.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("qcqxdvvxxlkarasl")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("gwdlleojlqopkiuu")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of the security group. Separate multiple security groups with commas (,). You can add a maximum of three security groups to a cluster.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("wxlfotyhcqpwpwwf")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value This attribute has been deprecated from v1.130.0 and using `db_cluster_ip_array` sub-element `security_ips` instead.
     * Its value is same as `db_cluster_ip_array` sub-element `security_ips` value and its db_cluster_ip_array_name is "default".
     */
    @JvmName("kofbiodcbdwfyrun")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("slenyainvowddpii")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values This attribute has been deprecated from v1.130.0 and using `db_cluster_ip_array` sub-element `security_ips` instead.
     * Its value is same as `db_cluster_ip_array` sub-element `security_ips` value and its db_cluster_ip_array_name is "default".
     */
    @JvmName("kcveelrrjyajfwjc")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value Serverless steady-state switch. Valid values are `ON`, `OFF`. This parameter is valid only for serverless clusters.
     * > **NOTE:** When serverless_steady_switch is `ON` and serverless_type is `SteadyServerless`, parameters `scale_min`, `scale_max`, `scale_ro_num_min` and `scale_ro_num_max` are all required.
     */
    @JvmName("iwyroxkxlruambpa")
    public suspend fun serverlessSteadySwitch(`value`: Output<String>) {
        this.serverlessSteadySwitch = value
    }

    /**
     * @param value The type of the serverless cluster. Valid values `AgileServerless`, `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("fnqvaivmjjwhjtnq")
    public suspend fun serverlessType(`value`: Output<String>) {
        this.serverlessType = value
    }

    /**
     * @param value The ID of the source RDS instance or the ID of the source PolarDB cluster. This parameter is required only when CreationOption is set to MigrationFromRDS, CloneFromRDS, or CloneFromPolarDB.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `SourceResourceId`.
     */
    @JvmName("itrnctexcbyanqft")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value The billing method of the storage. Valid values `Postpaid`, `Prepaid`.
     */
    @JvmName("ywdisxmqifhnegpm")
    public suspend fun storagePayType(`value`: Output<String>) {
        this.storagePayType = value
    }

    /**
     * @param value Storage space charged by space (monthly package). Unit: GB.
     * > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
     * > **NOTE:**  Valid values for PolarDB for MySQL Enterprise Edition: 50 to 100000.It is valid when pay_type is `PrePaid`.
     */
    @JvmName("sefdmghnwotuglke")
    public suspend fun storageSpace(`value`: Output<Int>) {
        this.storageSpace = value
    }

    /**
     * @param value The storage type of the cluster. Enterprise storage type values are `PSL5`, `PSL4`. The standard version storage type values are `ESSDPL1`, `ESSDPL2`, `ESSDPL3`. The standard version only supports MySQL.
     * > **NOTE:** Serverless cluster does not support this parameter.
     */
    @JvmName("vogicxcoanrerojh")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value The category of the cluster. Valid values are `Exclusive`, `General`. Only MySQL supports.
     */
    @JvmName("ksgpfuykptvqtyth")
    public suspend fun subCategory(`value`: Output<String>) {
        this.subCategory = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("nrjsuwawdxcariej")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersion](https://www.alibabacloud.com/help/en/polardb/latest/describedbclusterversion) interface.
     */
    @JvmName("ijvbbxevwhjrpakq")
    public suspend fun targetDbRevisionVersionCode(`value`: Output<String>) {
        this.targetDbRevisionVersionCode = value
    }

    /**
     * @param value turn on TDE encryption. Valid values are `Enabled`, `Disabled`. Default to `Disabled`. TDE cannot be closed after it is turned on.
     * > **NOTE:** `tde_status` Cannot modify after created when `db_type` is `PostgreSQL` or `Oracle`.`tde_status` only support modification from `Disabled` to `Enabled` when `db_type` is `MySQL`.
     */
    @JvmName("ikidadrjydkfxdgf")
    public suspend fun tdeStatus(`value`: Output<String>) {
        this.tdeStatus = value
    }

    /**
     * @param value Version upgrade type. Valid values are PROXY, DB, ALL. PROXY means upgrading the proxy version, DB means upgrading the db version, ALL means upgrading both db and proxy versions simultaneously.
     */
    @JvmName("esfgqpcfcwmfjyou")
    public suspend fun upgradeType(`value`: Output<String>) {
        this.upgradeType = value
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("abvublifofvuubvl")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     * > **NOTE:** If vswitch_id is not specified, system will get a vswitch belongs to the user automatically.
     */
    @JvmName("fdbmmvgrmaahexfm")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the DB cluster. it supports multiple zone.
     */
    @JvmName("tcqitxphhdxermvj")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Specifies whether to enable the no-activity suspension feature. Default value: false. Valid values are `true`, `false`. This parameter is valid only for serverless clusters.
     */
    @JvmName("jkhqaubskderjing")
    public suspend fun allowShutDown(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowShutDown = mapped
    }

    /**
     * @param value Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
     */
    @JvmName("vaflqsukccwrjiii")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The retention policy for the backup sets when you delete the cluster.  Valid values are `ALL`, `LATEST`, `NONE`. Value options can refer to the latest docs [DeleteDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/deletedbcluster-1)
     */
    @JvmName("cqluyrweomwswrfe")
    public suspend fun backupRetentionPolicyOnClusterDeletion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPolicyOnClusterDeletion = mapped
    }

    /**
     * @param value The time point of data to be cloned. Valid values are `LATEST`,`BackupID`,`Timestamp`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CloneDataPoint`.
     * > **NOTE:** If CreationOption is set to CloneFromRDS, the value of this parameter must be LATEST.
     */
    @JvmName("ygeatwcacbhpnfaw")
    public suspend fun cloneDataPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloneDataPoint = mapped
    }

    /**
     * @param value Specifies whether to enable or disable SQL data collector. Valid values are `Enable`, `Disabled`.
     */
    @JvmName("kceqgwgbewnydyma")
    public suspend fun collectorStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectorStatus = mapped
    }

    /**
     * @param value The edition of the PolarDB service. Valid values are `Normal`,`Basic`,`ArchiveNormal`,`NormalMultimaster`,`SENormal`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationCategory`.
     * > **NOTE:** You can set this parameter to Basic only when DBType is set to MySQL and DBVersion is set to 5.6, 5.7, or 8.0. You can set this parameter to Archive only when DBType is set to MySQL and DBVersion is set to 8.0. From version 1.188.0, `creation_category` can be set to `NormalMultimaster`. From version 1.203.0, `creation_category` can be set to `SENormal`.
     */
    @JvmName("clnfrkxlwkbyenow")
    public suspend fun creationCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationCategory = mapped
    }

    /**
     * @param value The method that is used to create a cluster. Valid values are `Normal`,`CloneFromPolarDB`,`CloneFromRDS`,`MigrationFromRDS`,`CreateGdnStandby`.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `CreationOption`.
     * > **NOTE:** The default value is Normal. If DBType is set to MySQL and DBVersion is set to 5.6 or 5.7, this parameter can be set to CloneFromRDS or MigrationFromRDS. If DBType is set to MySQL and DBVersion is set to 8.0, this parameter can be set to CreateGdnStandby.
     */
    @JvmName("uaomwcrxtwkvlewa")
    public suspend fun creationOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationOption = mapped
    }

    /**
     * @param value db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    @JvmName("avxohiyuftqwayxi")
    public suspend fun dbClusterIpArrays(`value`: List<ClusterDbClusterIpArrayArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIpArrays = mapped
    }

    /**
     * @param argument db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    @JvmName("qylungdnxonavavq")
    public suspend fun dbClusterIpArrays(argument: List<suspend ClusterDbClusterIpArrayArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterDbClusterIpArrayArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dbClusterIpArrays = mapped
    }

    /**
     * @param argument db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    @JvmName("hibexhwlqlowetrm")
    public suspend fun dbClusterIpArrays(vararg argument: suspend ClusterDbClusterIpArrayArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterDbClusterIpArrayArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dbClusterIpArrays = mapped
    }

    /**
     * @param argument db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    @JvmName("ooacaimcqlvmumuy")
    public suspend fun dbClusterIpArrays(argument: suspend ClusterDbClusterIpArrayArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterDbClusterIpArrayArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dbClusterIpArrays = mapped
    }

    /**
     * @param values db_cluster_ip_array defines how users can send requests to your API. See `db_cluster_ip_array` below.
     */
    @JvmName("pnnjvqwpwuneiufu")
    public suspend fun dbClusterIpArrays(vararg values: ClusterDbClusterIpArrayArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbClusterIpArrays = mapped
    }

    /**
     * @param value The db_node_class of cluster node.
     * > **NOTE:** Node specifications are divided into cluster version, single node version and History Library version. They can't change each other, but the general specification and exclusive specification of cluster version can be changed.
     * From version 1.204.0, If you need to create a Serverless cluster, `db_node_class` can be set to `polar.mysql.sl.small`.
     */
    @JvmName("dvkfveomkmmkwlss")
    public suspend fun dbNodeClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeClass = mapped
    }

    /**
     * @param value Number of the PolarDB cluster nodes, default is 2(Each cluster must contain at least a primary node and a read-only node). Add/remove nodes by modifying this parameter, valid values: [2~16].
     * > **NOTE:** To avoid adding or removing multiple read-only nodes by mistake, the system allows you to add or remove one read-only node at a time.
     */
    @JvmName("dlepymgbsremieqo")
    public suspend fun dbNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeCount = mapped
    }

    /**
     * @param value The ID of the node or node subscript. Node subscript values: 1 to 15.
     */
    @JvmName("gkgiiriqepkjboqp")
    public suspend fun dbNodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeId = mapped
    }

    /**
     * @param value The number of Standard Edition nodes. Default value: `1`. Valid values are `1`, `2`.
     */
    @JvmName("ggsklrkmogrxeqmv")
    public suspend fun dbNodeNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeNum = mapped
    }

    /**
     * @param value Database type. Value options: MySQL, Oracle, PostgreSQL.
     */
    @JvmName("fvwmtjrgestinfwh")
    public suspend fun dbType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbType = mapped
    }

    /**
     * @param value Database version. Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `DBVersion`.
     */
    @JvmName("ylkksripkypojurr")
    public suspend fun dbVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbVersion = mapped
    }

    /**
     * @param value The time zone of the cluster. You can set the parameter to a value that is on the hour from -12:00 to +13:00 based on UTC. Example: 00:00. Default value: SYSTEM. This value indicates that the time zone of the cluster is the same as the time zone of the region.
     * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
     */
    @JvmName("dxwmvrxikgktjcqb")
    public suspend fun defaultTimeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTimeZone = mapped
    }

    /**
     * @param value turn on table deletion_lock. Valid values are 0, 1. 1 means to open the cluster protection lock, 0 means to close the cluster protection lock
     * > **NOTE:**  Cannot modify after created when `pay_type` is `Prepaid` .`deletion_lock` the cluster protection lock can be turned on or off when `pay_type` is `Postpaid`.
     */
    @JvmName("iyjkkkohuiegbyfn")
    public suspend fun deletionLock(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionLock = mapped
    }

    /**
     * @param value The description of cluster.
     */
    @JvmName("yfxukhpmirqyjsma")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value turn on table auto encryption. Valid values are `ON`, `OFF`. Only MySQL 8.0 supports.
     * > **NOTE:** `encrypt_new_tables` Polardb MySQL 8.0 cluster, after TDE and Automatic Encryption are enabled, all newly created tables are automatically encrypted in the cluster.
     */
    @JvmName("eqtfunytfbotwklp")
    public suspend fun encryptNewTables(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptNewTables = mapped
    }

    /**
     * @param value The ID of the custom key. `encryption_key` cannot be modified after TDE is opened.
     */
    @JvmName("kristshwgveyjhnl")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Immediate or scheduled kernel version upgrade. Valid values are `true`, `false`. True means immediate execution, False means scheduled execution.
     */
    @JvmName("swyketmndbketykd")
    public suspend fun fromTimeService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromTimeService = mapped
    }

    /**
     * @param value The ID of the global database network (GDN).
     * > **NOTE:** This parameter is required if CreationOption is set to CreateGdnStandby.
     */
    @JvmName("tkwycpiwdvhpeapt")
    public suspend fun gdnId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gdnId = mapped
    }

    /**
     * @param value Indicates whether the hot standby feature is enabled. Valid values are `ON`, `OFF`. Only MySQL supports.
     */
    @JvmName("jdxoxeajtlnragrl")
    public suspend fun hotReplicaMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hotReplicaMode = mapped
    }

    /**
     * @param value Whether to enable the hot standby cluster. Valid values are `ON`, `OFF`. Only MySQL supports.
     */
    @JvmName("vfssisydubmxfgwo")
    public suspend fun hotStandbyCluster(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hotStandbyCluster = mapped
    }

    /**
     * @param value Specifies whether to enable the In-Memory Column Index (IMCI) feature. Valid values are `ON`, `OFF`.
     * > **NOTE:**  Only polardb MySQL Cluster version is available. The cluster with minor version number of 8.0.1 supports the column index feature, and the specific kernel version must be 8.0.1.1.22 or above.
     * > **NOTE:**  The single node, the single node version of the history library, and the cluster version of the history library do not support column save indexes.
     */
    @JvmName("pamposxpytiexuuf")
    public suspend fun imciSwitch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imciSwitch = mapped
    }

    /**
     * @param value Enable the Binlog function. Default value: `OFF`. Valid values are `OFF`, `ON`.
     * > **NOTE:** This parameter is valid only MySQL Engine supports.
     */
    @JvmName("dehquhwrtwgtyfbm")
    public suspend fun loosePolarLogBin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loosePolarLogBin = mapped
    }

    /**
     * @param value Specifies whether the table names are case-sensitive. Default value: `1`.  Valid values are `1`, `0`.
     * > **NOTE:** This parameter is valid only when the DBType parameter is set to MySQL.
     */
    @JvmName("daokscmmmuwmyltr")
    public suspend fun lowerCaseTableNames(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lowerCaseTableNames = mapped
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("efyleakrigpbireo")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value Use as `db_node_class` change class, define upgrade or downgrade. Valid values are `Upgrade`, `Downgrade`, Default to `Upgrade`.
     */
    @JvmName("qwhweqgqrvwrlhpy")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value The ID of the parameter template
     * > **NOTE:** You can call the [DescribeParameterGroups](https://www.alibabacloud.com/help/en/polardb/latest/describeparametergroups) operation to query the details of all parameter templates of a specified region, such as the ID of a parameter template.
     */
    @JvmName("npfuesogqrohgpkd")
    public suspend fun parameterGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterGroupId = mapped
    }

    /**
     * @param value Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    @JvmName("nlojilqsgbtsngth")
    public suspend fun parameters(`value`: List<ClusterParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    @JvmName("rrjtmhtouientaqn")
    public suspend fun parameters(argument: List<suspend ClusterParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    @JvmName("dvahleirnclelfdx")
    public suspend fun parameters(vararg argument: suspend ClusterParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    @JvmName("yywotmvkwoskxpdb")
    public suspend fun parameters(argument: suspend ClusterParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ClusterParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Set of parameters needs to be set after DB cluster was launched. Available parameters can refer to the latest docs [View database parameter templates](https://www.alibabacloud.com/help/en/polardb/latest/modifydbclusterparameters) .See `parameters` below.
     */
    @JvmName("hukeocwqpoddmygs")
    public suspend fun parameters(vararg values: ClusterParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
     */
    @JvmName("tcomanfmoeunjvxp")
    public suspend fun payType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    /**
     * @param value The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("otnfbroemqyxpcxd")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The latest time to start executing the target scheduled task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
     * > **NOTE:** The latest time must be 30 minutes or more later than the start time. If PlannedStartTime is set but this parameter is not specified, the latest time to execute the target task defaults to the start time+30 minutes. For example, when the PlannedStartTime is set to 2021-01-14T09:00:00Z and this parameter is left blank, the target task will start executing at the latest on 2021-01-14T09:30:00Z.
     */
    @JvmName("apaimtosaghmntfy")
    public suspend fun plannedEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plannedEndTime = mapped
    }

    /**
     * @param value The earliest time to start executing a scheduled (i.e. within the target time period) kernel version upgrade task. The format is YYYY-MM-DDThh: mm: ssZ (UTC).
     * > **NOTE:** The starting time range is any time point within the next 24 hours. For example, the current time is 2021-01-14T09:00:00Z, and the allowed start time range for filling in here is 2021-01-14T09:00:00Z~2021-01-15T09:00:00Z. If this parameter is left blank, the kernel version upgrade task will be executed immediately by default.
     */
    @JvmName("ligbqijworvhulwy")
    public suspend fun plannedStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plannedStartTime = mapped
    }

    /**
     * @param value The specifications of the Standard Edition PolarProxy. Available parameters can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1)
     * > **NOTE:** This parameter is valid only for standard edition clusters.
     */
    @JvmName("bpfcurqfxickdnim")
    public suspend fun proxyClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyClass = mapped
    }

    /**
     * @param value The type of PolarProxy. Valid values are `EXCLUSIVE` `GENERAL`.
     * > **NOTE:** This parameter is valid for both standard and enterprise clusters.
     */
    @JvmName("tbbcltaqpkmctvfd")
    public suspend fun proxyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyType = mapped
    }

    /**
     * @param value Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    @JvmName("wygjnqvcaposaytl")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The ID of resource group which the PolarDB cluster belongs. If not specified, then it belongs to the default resource group.
     */
    @JvmName("luyywabwtyfeuoui")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the RAM role. A RAM role is a virtual identity that you can create within your Alibaba Cloud account. For more information see [RAM role overview](https://www.alibabacloud.com/help/en/resource-access-management/latest/ram-role-overview).
     */
    @JvmName("ynahdolyedrkjihs")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
     */
    @JvmName("qwsdxvwhcevrvibf")
    public suspend fun scaleApRoNumMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleApRoNumMax = mapped
    }

    /**
     * @param value Number of Read-only Columnar Nodes. Valid values: 0 to 7. This parameter is valid only for serverless clusters. This parameter is required when there are column nodes that support steady-state serverless.
     */
    @JvmName("sxndmysdsvlqvvvy")
    public suspend fun scaleApRoNumMin(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleApRoNumMin = mapped
    }

    /**
     * @param value The maximum number of PCUs per node for scaling. Valid values: 1 PCU to 32 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("kpxowxgwyhwucglc")
    public suspend fun scaleMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleMax = mapped
    }

    /**
     * @param value The minimum number of PCUs per node for scaling. Valid values: 1 PCU to 31 PCUs. It is valid when serverless_type is `AgileServerless`. Valid values: 1 PCU to 8 PCUs.It is valid when serverless_type is `SteadyServerless`.  This parameter is valid only for serverless clusters.
     */
    @JvmName("pjihkdgxscpcotvh")
    public suspend fun scaleMin(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleMin = mapped
    }

    /**
     * @param value The maximum number of read-only nodes for scaling. Valid values: 0 to 15. It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7. It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("irgbpbvpyrxjioae")
    public suspend fun scaleRoNumMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleRoNumMax = mapped
    }

    /**
     * @param value The minimum number of read-only nodes for scaling. Valid values: 0 to 15 . It is valid when serverless_type is `AgileServerless`. Valid values: 0 to 7 .It is valid when serverless_type is `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("jluvcormcbvbeffj")
    public suspend fun scaleRoNumMin(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleRoNumMin = mapped
    }

    /**
     * @param value The detection period for No-activity Suspension. Valid values: 300 to 86,4005. Unit: seconds. The detection duration must be a multiple of 300 seconds. This parameter is valid only for serverless clusters.
     */
    @JvmName("ehqjrpwkxcifaiou")
    public suspend fun secondsUntilAutoPause(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondsUntilAutoPause = mapped
    }

    /**
     * @param value The ID of the security group. Separate multiple security groups with commas (,). You can add a maximum of three security groups to a cluster.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("cwiltokwdwvkilqs")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The ID of the security group. Separate multiple security groups with commas (,). You can add a maximum of three security groups to a cluster.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~20 minutes. Please make full preparation before changing them.
     */
    @JvmName("jofbmwnhyeckshpq")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value This attribute has been deprecated from v1.130.0 and using `db_cluster_ip_array` sub-element `security_ips` instead.
     * Its value is same as `db_cluster_ip_array` sub-element `security_ips` value and its db_cluster_ip_array_name is "default".
     */
    @JvmName("pawqoaqbuebnqdiw")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values This attribute has been deprecated from v1.130.0 and using `db_cluster_ip_array` sub-element `security_ips` instead.
     * Its value is same as `db_cluster_ip_array` sub-element `security_ips` value and its db_cluster_ip_array_name is "default".
     */
    @JvmName("tbcrfknsuskjsxcl")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value Serverless steady-state switch. Valid values are `ON`, `OFF`. This parameter is valid only for serverless clusters.
     * > **NOTE:** When serverless_steady_switch is `ON` and serverless_type is `SteadyServerless`, parameters `scale_min`, `scale_max`, `scale_ro_num_min` and `scale_ro_num_max` are all required.
     */
    @JvmName("oxwsicutreuhklxn")
    public suspend fun serverlessSteadySwitch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessSteadySwitch = mapped
    }

    /**
     * @param value The type of the serverless cluster. Valid values `AgileServerless`, `SteadyServerless`. This parameter is valid only for serverless clusters.
     */
    @JvmName("hyhygjcijobfnqct")
    public suspend fun serverlessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessType = mapped
    }

    /**
     * @param value The ID of the source RDS instance or the ID of the source PolarDB cluster. This parameter is required only when CreationOption is set to MigrationFromRDS, CloneFromRDS, or CloneFromPolarDB.Value options can refer to the latest docs [CreateDBCluster](https://www.alibabacloud.com/help/en/polardb/latest/createdbcluster-1) `SourceResourceId`.
     */
    @JvmName("bdaljunfmqfsgwlx")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value The billing method of the storage. Valid values `Postpaid`, `Prepaid`.
     */
    @JvmName("hqitnfwurattthno")
    public suspend fun storagePayType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storagePayType = mapped
    }

    /**
     * @param value Storage space charged by space (monthly package). Unit: GB.
     * > **NOTE:**  Valid values for PolarDB for MySQL Standard Edition: 20 to 32000. It is valid when pay_type are `PrePaid` ,`PostPaid`.
     * > **NOTE:**  Valid values for PolarDB for MySQL Enterprise Edition: 50 to 100000.It is valid when pay_type is `PrePaid`.
     */
    @JvmName("ocdqumesthovqmpi")
    public suspend fun storageSpace(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSpace = mapped
    }

    /**
     * @param value The storage type of the cluster. Enterprise storage type values are `PSL5`, `PSL4`. The standard version storage type values are `ESSDPL1`, `ESSDPL2`, `ESSDPL3`. The standard version only supports MySQL.
     * > **NOTE:** Serverless cluster does not support this parameter.
     */
    @JvmName("jrhtcghtjpssrjwi")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value The category of the cluster. Valid values are `Exclusive`, `General`. Only MySQL supports.
     */
    @JvmName("sxiqvagybeedptsp")
    public suspend fun subCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subCategory = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("xlttnpalkytdpuos")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("kyqpwailxouahqho")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Version Code of the target version, whose parameter values can be obtained from the [DescribeDBClusterVersion](https://www.alibabacloud.com/help/en/polardb/latest/describedbclusterversion) interface.
     */
    @JvmName("jwnnicnuwuqmpttt")
    public suspend fun targetDbRevisionVersionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDbRevisionVersionCode = mapped
    }

    /**
     * @param value turn on TDE encryption. Valid values are `Enabled`, `Disabled`. Default to `Disabled`. TDE cannot be closed after it is turned on.
     * > **NOTE:** `tde_status` Cannot modify after created when `db_type` is `PostgreSQL` or `Oracle`.`tde_status` only support modification from `Disabled` to `Enabled` when `db_type` is `MySQL`.
     */
    @JvmName("ntxpuetspxpwwchm")
    public suspend fun tdeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tdeStatus = mapped
    }

    /**
     * @param value Version upgrade type. Valid values are PROXY, DB, ALL. PROXY means upgrading the proxy version, DB means upgrading the db version, ALL means upgrading both db and proxy versions simultaneously.
     */
    @JvmName("hysltyjmgbjdmchg")
    public suspend fun upgradeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeType = mapped
    }

    /**
     * @param value The id of the VPC.
     */
    @JvmName("benppwvigvvejros")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     * > **NOTE:** If vswitch_id is not specified, system will get a vswitch belongs to the user automatically.
     */
    @JvmName("sxyqktvjhwtcvnvh")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the DB cluster. it supports multiple zone.
     */
    @JvmName("sggtdwtvrynkpoyw")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        allowShutDown = allowShutDown,
        autoRenewPeriod = autoRenewPeriod,
        backupRetentionPolicyOnClusterDeletion = backupRetentionPolicyOnClusterDeletion,
        cloneDataPoint = cloneDataPoint,
        collectorStatus = collectorStatus,
        creationCategory = creationCategory,
        creationOption = creationOption,
        dbClusterIpArrays = dbClusterIpArrays,
        dbNodeClass = dbNodeClass,
        dbNodeCount = dbNodeCount,
        dbNodeId = dbNodeId,
        dbNodeNum = dbNodeNum,
        dbType = dbType,
        dbVersion = dbVersion,
        defaultTimeZone = defaultTimeZone,
        deletionLock = deletionLock,
        description = description,
        encryptNewTables = encryptNewTables,
        encryptionKey = encryptionKey,
        fromTimeService = fromTimeService,
        gdnId = gdnId,
        hotReplicaMode = hotReplicaMode,
        hotStandbyCluster = hotStandbyCluster,
        imciSwitch = imciSwitch,
        loosePolarLogBin = loosePolarLogBin,
        lowerCaseTableNames = lowerCaseTableNames,
        maintainTime = maintainTime,
        modifyType = modifyType,
        parameterGroupId = parameterGroupId,
        parameters = parameters,
        payType = payType,
        period = period,
        plannedEndTime = plannedEndTime,
        plannedStartTime = plannedStartTime,
        proxyClass = proxyClass,
        proxyType = proxyType,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        roleArn = roleArn,
        scaleApRoNumMax = scaleApRoNumMax,
        scaleApRoNumMin = scaleApRoNumMin,
        scaleMax = scaleMax,
        scaleMin = scaleMin,
        scaleRoNumMax = scaleRoNumMax,
        scaleRoNumMin = scaleRoNumMin,
        secondsUntilAutoPause = secondsUntilAutoPause,
        securityGroupIds = securityGroupIds,
        securityIps = securityIps,
        serverlessSteadySwitch = serverlessSteadySwitch,
        serverlessType = serverlessType,
        sourceResourceId = sourceResourceId,
        storagePayType = storagePayType,
        storageSpace = storageSpace,
        storageType = storageType,
        subCategory = subCategory,
        tags = tags,
        targetDbRevisionVersionCode = targetDbRevisionVersionCode,
        tdeStatus = tdeStatus,
        upgradeType = upgradeType,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
