@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EndpointAddress].
 */
@PulumiTagMarker
public class EndpointAddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointAddressArgs = EndpointAddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointAddressArgsBuilder.() -> Unit) {
        val builder = EndpointAddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointAddress {
        val builtJavaResource = com.pulumi.alicloud.polardb.EndpointAddress(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EndpointAddress(builtJavaResource)
    }
}

/**
 * Provides a PolarDB endpoint address resource to allocate an Internet endpoint address string for PolarDB instance.
 * > **NOTE:** Available since v1.68.0. Each PolarDB instance will allocate a intranet connection string automatically and its prefix is Cluster ID.
 *  To avoid unnecessary conflict, please specified a internet connection prefix before applying the resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.polardb.getNodeClasses({
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     payType: "PostPaid",
 *     category: "Normal",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.classes?.[0]?.zoneId),
 *     vswitchName: "terraform-example",
 * });
 * const defaultCluster = new alicloud.polardb.Cluster("default", {
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     dbNodeClass: _default.then(_default => _default.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
 *     payType: "PostPaid",
 *     vswitchId: defaultSwitch.id,
 *     description: "terraform-example",
 * });
 * const defaultGetEndpoints = alicloud.polardb.getEndpointsOutput({
 *     dbClusterId: defaultCluster.id,
 * });
 * const defaultEndpointAddress = new alicloud.polardb.EndpointAddress("default", {
 *     dbClusterId: defaultCluster.id,
 *     dbEndpointId: defaultGetEndpoints.apply(defaultGetEndpoints => defaultGetEndpoints.endpoints?.[0]?.dbEndpointId),
 *     connectionPrefix: "polardbexample",
 *     netType: "Public",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.polardb.get_node_classes(db_type="MySQL",
 *     db_version="8.0",
 *     pay_type="PostPaid",
 *     category="Normal")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.classes[0].zone_id,
 *     vswitch_name="terraform-example")
 * default_cluster = alicloud.polardb.Cluster("default",
 *     db_type="MySQL",
 *     db_version="8.0",
 *     db_node_class=default.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
 *     pay_type="PostPaid",
 *     vswitch_id=default_switch.id,
 *     description="terraform-example")
 * default_get_endpoints = alicloud.polardb.get_endpoints_output(db_cluster_id=default_cluster.id)
 * default_endpoint_address = alicloud.polardb.EndpointAddress("default",
 *     db_cluster_id=default_cluster.id,
 *     db_endpoint_id=default_get_endpoints.endpoints[0].db_endpoint_id,
 *     connection_prefix="polardbexample",
 *     net_type="Public")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         PayType = "PostPaid",
 *         Category = "Normal",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
 *         VswitchName = "terraform-example",
 *     });
 *     var defaultCluster = new AliCloud.PolarDB.Cluster("default", new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         DbNodeClass = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
 *         PayType = "PostPaid",
 *         VswitchId = defaultSwitch.Id,
 *         Description = "terraform-example",
 *     });
 *     var defaultGetEndpoints = AliCloud.PolarDB.GetEndpoints.Invoke(new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *     });
 *     var defaultEndpointAddress = new AliCloud.PolarDB.EndpointAddress("default", new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *         DbEndpointId = defaultGetEndpoints.Apply(getEndpointsResult => getEndpointsResult.Endpoints[0]?.DbEndpointId),
 *         ConnectionPrefix = "polardbexample",
 *         NetType = "Public",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
 * 			DbType:    pulumi.StringRef("MySQL"),
 * 			DbVersion: pulumi.StringRef("8.0"),
 * 			PayType:   "PostPaid",
 * 			Category:  pulumi.StringRef("Normal"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Classes[0].ZoneId),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCluster, err := polardb.NewCluster(ctx, "default", &polardb.ClusterArgs{
 * 			DbType:      pulumi.String("MySQL"),
 * 			DbVersion:   pulumi.String("8.0"),
 * 			DbNodeClass: pulumi.String(_default.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
 * 			PayType:     pulumi.String("PostPaid"),
 * 			VswitchId:   defaultSwitch.ID(),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetEndpoints := polardb.GetEndpointsOutput(ctx, polardb.GetEndpointsOutputArgs{
 * 			DbClusterId: defaultCluster.ID(),
 * 		}, nil)
 * 		_, err = polardb.NewEndpointAddress(ctx, "default", &polardb.EndpointAddressArgs{
 * 			DbClusterId: defaultCluster.ID(),
 * 			DbEndpointId: pulumi.String(defaultGetEndpoints.ApplyT(func(defaultGetEndpoints polardb.GetEndpointsResult) (*string, error) {
 * 				return &defaultGetEndpoints.Endpoints[0].DbEndpointId, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 			ConnectionPrefix: pulumi.String("polardbexample"),
 * 			NetType:          pulumi.String("Public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.polardb.PolardbFunctions;
 * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.polardb.Cluster;
 * import com.pulumi.alicloud.polardb.ClusterArgs;
 * import com.pulumi.alicloud.polardb.inputs.GetEndpointsArgs;
 * import com.pulumi.alicloud.polardb.EndpointAddress;
 * import com.pulumi.alicloud.polardb.EndpointAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .payType("PostPaid")
 *             .category("Normal")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.classes()[0].zoneId())
 *             .vswitchName("terraform-example")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .dbNodeClass(default_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
 *             .payType("PostPaid")
 *             .vswitchId(defaultSwitch.id())
 *             .description("terraform-example")
 *             .build());
 *         final var defaultGetEndpoints = PolardbFunctions.getEndpoints(GetEndpointsArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .build());
 *         var defaultEndpointAddress = new EndpointAddress("defaultEndpointAddress", EndpointAddressArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .dbEndpointId(defaultGetEndpoints.applyValue(getEndpointsResult -> getEndpointsResult).applyValue(defaultGetEndpoints -> defaultGetEndpoints.applyValue(getEndpointsResult -> getEndpointsResult.endpoints()[0].dbEndpointId())))
 *             .connectionPrefix("polardbexample")
 *             .netType("Public")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.classes[0].zoneId}
 *       vswitchName: terraform-example
 *   defaultCluster:
 *     type: alicloud:polardb:Cluster
 *     name: default
 *     properties:
 *       dbType: MySQL
 *       dbVersion: '8.0'
 *       dbNodeClass: ${default.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
 *       payType: PostPaid
 *       vswitchId: ${defaultSwitch.id}
 *       description: terraform-example
 *   defaultEndpointAddress:
 *     type: alicloud:polardb:EndpointAddress
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultCluster.id}
 *       dbEndpointId: ${defaultGetEndpoints.endpoints[0].dbEndpointId}
 *       connectionPrefix: polardbexample
 *       netType: Public
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:polardb:getNodeClasses
 *       Arguments:
 *         dbType: MySQL
 *         dbVersion: '8.0'
 *         payType: PostPaid
 *         category: Normal
 *   defaultGetEndpoints:
 *     fn::invoke:
 *       Function: alicloud:polardb:getEndpoints
 *       Arguments:
 *         dbClusterId: ${defaultCluster.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * PolarDB endpoint address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/endpointAddress:EndpointAddress example pc-abc123456:pe-abc123456
 * ```
 */
public class EndpointAddress internal constructor(
    override val javaResource: com.pulumi.alicloud.polardb.EndpointAddress,
) : KotlinCustomResource(javaResource, EndpointAddressMapper) {
    /**
     * Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
     */
    public val connectionPrefix: Output<String>
        get() = javaResource.connectionPrefix().applyValue({ args0 -> args0 })

    /**
     * Connection cluster or endpoint string.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The Id of cluster that can run database.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * The Id of endpoint that can run database.
     */
    public val dbEndpointId: Output<String>
        get() = javaResource.dbEndpointId().applyValue({ args0 -> args0 })

    /**
     * The ip address of connection string.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * Internet connection net type. Valid value: `Public`. Default to `Public`. Currently supported only `Public`.
     */
    public val netType: Output<String>?
        get() = javaResource.netType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Port of the specified endpoint. Valid values: 3000 to 5999.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })
}

public object EndpointAddressMapper : ResourceMapper<EndpointAddress> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.polardb.EndpointAddress::class == javaResource::class

    override fun map(javaResource: Resource): EndpointAddress = EndpointAddress(
        javaResource as
            com.pulumi.alicloud.polardb.EndpointAddress,
    )
}

/**
 * @see [EndpointAddress].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointAddress].
 */
public suspend fun endpointAddress(
    name: String,
    block: suspend EndpointAddressResourceBuilder.() -> Unit,
): EndpointAddress {
    val builder = EndpointAddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointAddress].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointAddress(name: String): EndpointAddress {
    val builder = EndpointAddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
