@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.EndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a PolarDB endpoint resource to manage custom endpoint of PolarDB cluster.
 * > **NOTE:** Available since v1.80.0.
 * > **NOTE:** After v1.80.0 and before v1.121.0, you can only use this resource to manage the custom endpoint. Since v1.121.0, you also can import the primary endpoint and the cluster endpoint, to modify their ssl status and so on.
 * > **NOTE:** The primary endpoint and the default cluster endpoint can not be created or deleted manually.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.polardb.getNodeClasses({
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     payType: "PostPaid",
 *     category: "Normal",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.classes?.[0]?.zoneId),
 *     vswitchName: "terraform-example",
 * });
 * const defaultCluster = new alicloud.polardb.Cluster("default", {
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     dbNodeClass: _default.then(_default => _default.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
 *     payType: "PostPaid",
 *     vswitchId: defaultSwitch.id,
 *     description: "terraform-example",
 * });
 * const defaultEndpoint = new alicloud.polardb.Endpoint("default", {
 *     dbClusterId: defaultCluster.id,
 *     endpointType: "Custom",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.polardb.get_node_classes(db_type="MySQL",
 *     db_version="8.0",
 *     pay_type="PostPaid",
 *     category="Normal")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.classes[0].zone_id,
 *     vswitch_name="terraform-example")
 * default_cluster = alicloud.polardb.Cluster("default",
 *     db_type="MySQL",
 *     db_version="8.0",
 *     db_node_class=default.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
 *     pay_type="PostPaid",
 *     vswitch_id=default_switch.id,
 *     description="terraform-example")
 * default_endpoint = alicloud.polardb.Endpoint("default",
 *     db_cluster_id=default_cluster.id,
 *     endpoint_type="Custom")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         PayType = "PostPaid",
 *         Category = "Normal",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
 *         VswitchName = "terraform-example",
 *     });
 *     var defaultCluster = new AliCloud.PolarDB.Cluster("default", new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         DbNodeClass = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
 *         PayType = "PostPaid",
 *         VswitchId = defaultSwitch.Id,
 *         Description = "terraform-example",
 *     });
 *     var defaultEndpoint = new AliCloud.PolarDB.Endpoint("default", new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *         EndpointType = "Custom",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
 * 			DbType:    pulumi.StringRef("MySQL"),
 * 			DbVersion: pulumi.StringRef("8.0"),
 * 			PayType:   "PostPaid",
 * 			Category:  pulumi.StringRef("Normal"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Classes[0].ZoneId),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCluster, err := polardb.NewCluster(ctx, "default", &polardb.ClusterArgs{
 * 			DbType:      pulumi.String("MySQL"),
 * 			DbVersion:   pulumi.String("8.0"),
 * 			DbNodeClass: pulumi.String(_default.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
 * 			PayType:     pulumi.String("PostPaid"),
 * 			VswitchId:   defaultSwitch.ID(),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = polardb.NewEndpoint(ctx, "default", &polardb.EndpointArgs{
 * 			DbClusterId:  defaultCluster.ID(),
 * 			EndpointType: pulumi.String("Custom"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.polardb.PolardbFunctions;
 * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.polardb.Cluster;
 * import com.pulumi.alicloud.polardb.ClusterArgs;
 * import com.pulumi.alicloud.polardb.Endpoint;
 * import com.pulumi.alicloud.polardb.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .payType("PostPaid")
 *             .category("Normal")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.classes()[0].zoneId())
 *             .vswitchName("terraform-example")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .dbNodeClass(default_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
 *             .payType("PostPaid")
 *             .vswitchId(defaultSwitch.id())
 *             .description("terraform-example")
 *             .build());
 *         var defaultEndpoint = new Endpoint("defaultEndpoint", EndpointArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .endpointType("Custom")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.classes[0].zoneId}
 *       vswitchName: terraform-example
 *   defaultCluster:
 *     type: alicloud:polardb:Cluster
 *     name: default
 *     properties:
 *       dbType: MySQL
 *       dbVersion: '8.0'
 *       dbNodeClass: ${default.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
 *       payType: PostPaid
 *       vswitchId: ${defaultSwitch.id}
 *       description: terraform-example
 *   defaultEndpoint:
 *     type: alicloud:polardb:Endpoint
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultCluster.id}
 *       endpointType: Custom
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:polardb:getNodeClasses
 *       Arguments:
 *         dbType: MySQL
 *         dbVersion: '8.0'
 *         payType: PostPaid
 *         category: Normal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * PolarDB endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/endpoint:Endpoint example pc-abc123456:pe-abc123456
 * ```
 * @property autoAddNewNodes Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Disable`.
 * @property connectionPrefix Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
 * @property dbClusterId The Id of cluster that can run database.
 * @property dbEndpointDescription The name of the endpoint.
 * @property endpointConfig The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
 * @property endpointType Type of the endpoint. Before v1.121.0, it only can be `Custom`. since v1.121.0, `Custom`, `Cluster`, `Primary` are valid, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
 * @property netType The network type of the endpoint address.
 * @property nodes Node id list for endpoint configuration. At least 2 nodes if specified, or if the cluster has more than 3 nodes, read-only endpoint is allowed to mount only one node. Default is all nodes.
 * @property port Port of the specified endpoint. Valid values: 3000 to 5999.
 * @property readWriteMode Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
 * @property sslAutoRotate Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
 * @property sslEnabled Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
 */
public data class EndpointArgs(
    public val autoAddNewNodes: Output<String>? = null,
    public val connectionPrefix: Output<String>? = null,
    public val dbClusterId: Output<String>? = null,
    public val dbEndpointDescription: Output<String>? = null,
    public val endpointConfig: Output<Map<String, String>>? = null,
    public val endpointType: Output<String>? = null,
    public val netType: Output<String>? = null,
    public val nodes: Output<List<String>>? = null,
    public val port: Output<String>? = null,
    public val readWriteMode: Output<String>? = null,
    public val sslAutoRotate: Output<String>? = null,
    public val sslEnabled: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.EndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.EndpointArgs =
        com.pulumi.alicloud.polardb.EndpointArgs.builder()
            .autoAddNewNodes(autoAddNewNodes?.applyValue({ args0 -> args0 }))
            .connectionPrefix(connectionPrefix?.applyValue({ args0 -> args0 }))
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 }))
            .dbEndpointDescription(dbEndpointDescription?.applyValue({ args0 -> args0 }))
            .endpointConfig(
                endpointConfig?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .netType(netType?.applyValue({ args0 -> args0 }))
            .nodes(nodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .readWriteMode(readWriteMode?.applyValue({ args0 -> args0 }))
            .sslAutoRotate(sslAutoRotate?.applyValue({ args0 -> args0 }))
            .sslEnabled(sslEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var autoAddNewNodes: Output<String>? = null

    private var connectionPrefix: Output<String>? = null

    private var dbClusterId: Output<String>? = null

    private var dbEndpointDescription: Output<String>? = null

    private var endpointConfig: Output<Map<String, String>>? = null

    private var endpointType: Output<String>? = null

    private var netType: Output<String>? = null

    private var nodes: Output<List<String>>? = null

    private var port: Output<String>? = null

    private var readWriteMode: Output<String>? = null

    private var sslAutoRotate: Output<String>? = null

    private var sslEnabled: Output<String>? = null

    /**
     * @param value Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Disable`.
     */
    @JvmName("bitycslobcffyqan")
    public suspend fun autoAddNewNodes(`value`: Output<String>) {
        this.autoAddNewNodes = value
    }

    /**
     * @param value Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
     */
    @JvmName("awjmdoigubsxrvtn")
    public suspend fun connectionPrefix(`value`: Output<String>) {
        this.connectionPrefix = value
    }

    /**
     * @param value The Id of cluster that can run database.
     */
    @JvmName("wiaanjwjokilcsag")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("akgiammblxkgbuve")
    public suspend fun dbEndpointDescription(`value`: Output<String>) {
        this.dbEndpointDescription = value
    }

    /**
     * @param value The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
     */
    @JvmName("rnpaqnxgxwpdsvwb")
    public suspend fun endpointConfig(`value`: Output<Map<String, String>>) {
        this.endpointConfig = value
    }

    /**
     * @param value Type of the endpoint. Before v1.121.0, it only can be `Custom`. since v1.121.0, `Custom`, `Cluster`, `Primary` are valid, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
     */
    @JvmName("mahjqxreojbaiyns")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The network type of the endpoint address.
     */
    @JvmName("jcskhpobmonhfovb")
    public suspend fun netType(`value`: Output<String>) {
        this.netType = value
    }

    /**
     * @param value Node id list for endpoint configuration. At least 2 nodes if specified, or if the cluster has more than 3 nodes, read-only endpoint is allowed to mount only one node. Default is all nodes.
     */
    @JvmName("jivawxtwpkiihnkg")
    public suspend fun nodes(`value`: Output<List<String>>) {
        this.nodes = value
    }

    @JvmName("eiyxgpvlaugaanwo")
    public suspend fun nodes(vararg values: Output<String>) {
        this.nodes = Output.all(values.asList())
    }

    /**
     * @param values Node id list for endpoint configuration. At least 2 nodes if specified, or if the cluster has more than 3 nodes, read-only endpoint is allowed to mount only one node. Default is all nodes.
     */
    @JvmName("libhobxcgvxbgpyy")
    public suspend fun nodes(values: List<Output<String>>) {
        this.nodes = Output.all(values)
    }

    /**
     * @param value Port of the specified endpoint. Valid values: 3000 to 5999.
     */
    @JvmName("fhnvhvdlsgrunelq")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
     */
    @JvmName("mruwubjuoyusrxpy")
    public suspend fun readWriteMode(`value`: Output<String>) {
        this.readWriteMode = value
    }

    /**
     * @param value Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
     */
    @JvmName("qjmmjinbycberuta")
    public suspend fun sslAutoRotate(`value`: Output<String>) {
        this.sslAutoRotate = value
    }

    /**
     * @param value Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
     */
    @JvmName("sgltbngshfgyeccp")
    public suspend fun sslEnabled(`value`: Output<String>) {
        this.sslEnabled = value
    }

    /**
     * @param value Whether the new node automatically joins the default cluster address. Valid values are `Enable`, `Disable`. When creating a new custom endpoint, default to `Disable`.
     */
    @JvmName("gdedfnfkuofcefck")
    public suspend fun autoAddNewNodes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAddNewNodes = mapped
    }

    /**
     * @param value Prefix of the specified endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter.
     */
    @JvmName("hsptvknpdxddqnsy")
    public suspend fun connectionPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionPrefix = mapped
    }

    /**
     * @param value The Id of cluster that can run database.
     */
    @JvmName("hucudghtvvqdrpew")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("xxisnpqnitxbiomw")
    public suspend fun dbEndpointDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbEndpointDescription = mapped
    }

    /**
     * @param value The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
     */
    @JvmName("rbnqtkcgyjajbcnw")
    public suspend fun endpointConfig(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfig = mapped
    }

    /**
     * @param values The advanced settings of the endpoint of Apsara PolarDB clusters are in JSON format. Including the settings of consistency level, transaction splitting, connection pool, and offload reads from primary node. For more details, see the [description of EndpointConfig in the Request parameters table for details](https://www.alibabacloud.com/help/doc-detail/116593.htm).
     */
    @JvmName("occilikouabtycyy")
    public fun endpointConfig(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointConfig = mapped
    }

    /**
     * @param value Type of the endpoint. Before v1.121.0, it only can be `Custom`. since v1.121.0, `Custom`, `Cluster`, `Primary` are valid, default to `Custom`. However when creating a new endpoint, it also only can be `Custom`.
     */
    @JvmName("aslrgfumjxpvxcqx")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The network type of the endpoint address.
     */
    @JvmName("jsoqstrkvqkrqumo")
    public suspend fun netType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netType = mapped
    }

    /**
     * @param value Node id list for endpoint configuration. At least 2 nodes if specified, or if the cluster has more than 3 nodes, read-only endpoint is allowed to mount only one node. Default is all nodes.
     */
    @JvmName("qtwccrkoyillsyij")
    public suspend fun nodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodes = mapped
    }

    /**
     * @param values Node id list for endpoint configuration. At least 2 nodes if specified, or if the cluster has more than 3 nodes, read-only endpoint is allowed to mount only one node. Default is all nodes.
     */
    @JvmName("wdytarkfldwsrkqn")
    public suspend fun nodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodes = mapped
    }

    /**
     * @param value Port of the specified endpoint. Valid values: 3000 to 5999.
     */
    @JvmName("vnicvpabpodhkkgw")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Read or write mode. Valid values are `ReadWrite`, `ReadOnly`. When creating a new custom endpoint, default to `ReadOnly`.
     */
    @JvmName("cesrrgtmggoddivr")
    public suspend fun readWriteMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readWriteMode = mapped
    }

    /**
     * @param value Specifies whether automatic rotation of SSL certificates is enabled. Valid values: `Enable`,`Disable`.
     */
    @JvmName("vocnknkfnyhlftsk")
    public suspend fun sslAutoRotate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslAutoRotate = mapped
    }

    /**
     * @param value Specifies how to modify the SSL encryption status. Valid values: `Disable`, `Enable`, `Update`.
     */
    @JvmName("gviimnpkbhfuraow")
    public suspend fun sslEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslEnabled = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        autoAddNewNodes = autoAddNewNodes,
        connectionPrefix = connectionPrefix,
        dbClusterId = dbClusterId,
        dbEndpointDescription = dbEndpointDescription,
        endpointConfig = endpointConfig,
        endpointType = endpointType,
        netType = netType,
        nodes = nodes,
        port = port,
        readWriteMode = readWriteMode,
        sslAutoRotate = sslAutoRotate,
        sslEnabled = sslEnabled,
    )
}
