@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.GlobalDatabaseNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a PolarDB Global Database Network resource.
 * For information about PolarDB Global Database Network and how to use it, see [What is Global Database Network](https://www.alibabacloud.com/help/en/polardb/api-polardb-2017-08-01-createglobaldatabasenetwork).
 * > **NOTE:** Available since v1.181.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.polardb.getNodeClasses({
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     category: "Normal",
 *     payType: "PostPaid",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: "terraform-example",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.classes?.[0]?.zoneId),
 *     vswitchName: "terraform-example",
 * });
 * const defaultCluster = new alicloud.polardb.Cluster("default", {
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     dbNodeClass: _default.then(_default => _default.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
 *     payType: "PostPaid",
 *     vswitchId: defaultSwitch.id,
 *     description: "terraform-example",
 * });
 * const defaultGlobalDatabaseNetwork = new alicloud.polardb.GlobalDatabaseNetwork("default", {
 *     dbClusterId: defaultCluster.id,
 *     description: "terraform-example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.polardb.get_node_classes(db_type="MySQL",
 *     db_version="8.0",
 *     category="Normal",
 *     pay_type="PostPaid")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name="terraform-example",
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.classes[0].zone_id,
 *     vswitch_name="terraform-example")
 * default_cluster = alicloud.polardb.Cluster("default",
 *     db_type="MySQL",
 *     db_version="8.0",
 *     db_node_class=default.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
 *     pay_type="PostPaid",
 *     vswitch_id=default_switch.id,
 *     description="terraform-example")
 * default_global_database_network = alicloud.polardb.GlobalDatabaseNetwork("default",
 *     db_cluster_id=default_cluster.id,
 *     description="terraform-example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         Category = "Normal",
 *         PayType = "PostPaid",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = "terraform-example",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
 *         VswitchName = "terraform-example",
 *     });
 *     var defaultCluster = new AliCloud.PolarDB.Cluster("default", new()
 *     {
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         DbNodeClass = @default.Apply(@default => @default.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
 *         PayType = "PostPaid",
 *         VswitchId = defaultSwitch.Id,
 *         Description = "terraform-example",
 *     });
 *     var defaultGlobalDatabaseNetwork = new AliCloud.PolarDB.GlobalDatabaseNetwork("default", new()
 *     {
 *         DbClusterId = defaultCluster.Id,
 *         Description = "terraform-example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
 * 			DbType:    pulumi.StringRef("MySQL"),
 * 			DbVersion: pulumi.StringRef("8.0"),
 * 			Category:  pulumi.StringRef("Normal"),
 * 			PayType:   "PostPaid",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("terraform-example"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Classes[0].ZoneId),
 * 			VswitchName: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultCluster, err := polardb.NewCluster(ctx, "default", &polardb.ClusterArgs{
 * 			DbType:      pulumi.String("MySQL"),
 * 			DbVersion:   pulumi.String("8.0"),
 * 			DbNodeClass: pulumi.String(_default.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
 * 			PayType:     pulumi.String("PostPaid"),
 * 			VswitchId:   defaultSwitch.ID(),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = polardb.NewGlobalDatabaseNetwork(ctx, "default", &polardb.GlobalDatabaseNetworkArgs{
 * 			DbClusterId: defaultCluster.ID(),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.polardb.PolardbFunctions;
 * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.polardb.Cluster;
 * import com.pulumi.alicloud.polardb.ClusterArgs;
 * import com.pulumi.alicloud.polardb.GlobalDatabaseNetwork;
 * import com.pulumi.alicloud.polardb.GlobalDatabaseNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .category("Normal")
 *             .payType("PostPaid")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName("terraform-example")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.classes()[0].zoneId())
 *             .vswitchName("terraform-example")
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .dbNodeClass(default_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
 *             .payType("PostPaid")
 *             .vswitchId(defaultSwitch.id())
 *             .description("terraform-example")
 *             .build());
 *         var defaultGlobalDatabaseNetwork = new GlobalDatabaseNetwork("defaultGlobalDatabaseNetwork", GlobalDatabaseNetworkArgs.builder()
 *             .dbClusterId(defaultCluster.id())
 *             .description("terraform-example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: terraform-example
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.classes[0].zoneId}
 *       vswitchName: terraform-example
 *   defaultCluster:
 *     type: alicloud:polardb:Cluster
 *     name: default
 *     properties:
 *       dbType: MySQL
 *       dbVersion: '8.0'
 *       dbNodeClass: ${default.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
 *       payType: PostPaid
 *       vswitchId: ${defaultSwitch.id}
 *       description: terraform-example
 *   defaultGlobalDatabaseNetwork:
 *     type: alicloud:polardb:GlobalDatabaseNetwork
 *     name: default
 *     properties:
 *       dbClusterId: ${defaultCluster.id}
 *       description: terraform-example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:polardb:getNodeClasses
 *       Arguments:
 *         dbType: MySQL
 *         dbVersion: '8.0'
 *         category: Normal
 *         payType: PostPaid
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * PolarDB Global Database Network can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/globalDatabaseNetwork:GlobalDatabaseNetwork example <id>
 * ```
 * @property dbClusterId The ID of the primary cluster.
 * @property description The description of the Global Database Network.
 */
public data class GlobalDatabaseNetworkArgs(
    public val dbClusterId: Output<String>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.GlobalDatabaseNetworkArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.GlobalDatabaseNetworkArgs =
        com.pulumi.alicloud.polardb.GlobalDatabaseNetworkArgs.builder()
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalDatabaseNetworkArgs].
 */
@PulumiTagMarker
public class GlobalDatabaseNetworkArgsBuilder internal constructor() {
    private var dbClusterId: Output<String>? = null

    private var description: Output<String>? = null

    /**
     * @param value The ID of the primary cluster.
     */
    @JvmName("gbmrdwcvegtgujjn")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value The description of the Global Database Network.
     */
    @JvmName("aypcytewyvuxbmac")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the primary cluster.
     */
    @JvmName("pmifokitxxlofygd")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    /**
     * @param value The description of the Global Database Network.
     */
    @JvmName("wlluogjelwqswori")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): GlobalDatabaseNetworkArgs = GlobalDatabaseNetworkArgs(
        dbClusterId = dbClusterId,
        description = description,
    )
}
