@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.kotlin.outputs.ParameterGroupParameter
import com.pulumi.alicloud.polardb.kotlin.outputs.ParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ParameterGroup].
 */
@PulumiTagMarker
public class ParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ParameterGroupArgs = ParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ParameterGroupArgsBuilder.() -> Unit) {
        val builder = ParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ParameterGroup {
        val builtJavaResource = com.pulumi.alicloud.polardb.ParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ParameterGroup(builtJavaResource)
    }
}

/**
 * Provides a PolarDB Parameter Group resource.
 * For information about PolarDB Parameter Group and how to use it, see [What is Parameter Group](https://www.alibabacloud.com/help/en/polardb/polardb-for-mysql/user-guide/apply-a-parameter-template).
 * > **NOTE:** Available in v1.183.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.polardb.ParameterGroup("example", {
 *     name: "example_value",
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     parameters: [{
 *         paramName: "wait_timeout",
 *         paramValue: "86400",
 *     }],
 *     description: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.polardb.ParameterGroup("example",
 *     name="example_value",
 *     db_type="MySQL",
 *     db_version="8.0",
 *     parameters=[{
 *         "param_name": "wait_timeout",
 *         "param_value": "86400",
 *     }],
 *     description="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.PolarDB.ParameterGroup("example", new()
 *     {
 *         Name = "example_value",
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         Parameters = new[]
 *         {
 *             new AliCloud.PolarDB.Inputs.ParameterGroupParameterArgs
 *             {
 *                 ParamName = "wait_timeout",
 *                 ParamValue = "86400",
 *             },
 *         },
 *         Description = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := polardb.NewParameterGroup(ctx, "example", &polardb.ParameterGroupArgs{
 * 			Name:      pulumi.String("example_value"),
 * 			DbType:    pulumi.String("MySQL"),
 * 			DbVersion: pulumi.String("8.0"),
 * 			Parameters: polardb.ParameterGroupParameterArray{
 * 				&polardb.ParameterGroupParameterArgs{
 * 					ParamName:  pulumi.String("wait_timeout"),
 * 					ParamValue: pulumi.String("86400"),
 * 				},
 * 			},
 * 			Description: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.polardb.ParameterGroup;
 * import com.pulumi.alicloud.polardb.ParameterGroupArgs;
 * import com.pulumi.alicloud.polardb.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ParameterGroup("example", ParameterGroupArgs.builder()
 *             .name("example_value")
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .parameters(ParameterGroupParameterArgs.builder()
 *                 .paramName("wait_timeout")
 *                 .paramValue("86400")
 *                 .build())
 *             .description("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:polardb:ParameterGroup
 *     properties:
 *       name: example_value
 *       dbType: MySQL
 *       dbVersion: '8.0'
 *       parameters:
 *         - paramName: wait_timeout
 *           paramValue: '86400'
 *       description: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * PolarDB Parameter Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/parameterGroup:ParameterGroup example <id>
 * ```
 */
public class ParameterGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.polardb.ParameterGroup,
) : KotlinCustomResource(javaResource, ParameterGroupMapper) {
    /**
     * The type of the database engine. Only `MySQL` is supported.
     */
    public val dbType: Output<String>
        get() = javaResource.dbType().applyValue({ args0 -> args0 })

    /**
     * The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
     */
    public val dbVersion: Output<String>
        get() = javaResource.dbVersion().applyValue({ args0 -> args0 })

    /**
     * The description of the parameter template. It must be 0 to 200 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the parameter template. It must be 8 to 64 characters in length, and can contain letters, digits, and underscores (_). It must start with a letter and cannot contain Chinese characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameter template. See the following `Block parameters`.
     */
    public val parameters: Output<List<ParameterGroupParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object ParameterGroupMapper : ResourceMapper<ParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.polardb.ParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ParameterGroup = ParameterGroup(
        javaResource as
            com.pulumi.alicloud.polardb.ParameterGroup,
    )
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ParameterGroup].
 */
public suspend fun parameterGroup(
    name: String,
    block: suspend ParameterGroupResourceBuilder.() -> Unit,
): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun parameterGroup(name: String): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
