@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.ParameterGroupArgs.builder
import com.pulumi.alicloud.polardb.kotlin.inputs.ParameterGroupParameterArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.ParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a PolarDB Parameter Group resource.
 * For information about PolarDB Parameter Group and how to use it, see [What is Parameter Group](https://www.alibabacloud.com/help/en/polardb/polardb-for-mysql/user-guide/apply-a-parameter-template).
 * > **NOTE:** Available in v1.183.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.polardb.ParameterGroup("example", {
 *     name: "example_value",
 *     dbType: "MySQL",
 *     dbVersion: "8.0",
 *     parameters: [{
 *         paramName: "wait_timeout",
 *         paramValue: "86400",
 *     }],
 *     description: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.polardb.ParameterGroup("example",
 *     name="example_value",
 *     db_type="MySQL",
 *     db_version="8.0",
 *     parameters=[{
 *         "param_name": "wait_timeout",
 *         "param_value": "86400",
 *     }],
 *     description="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.PolarDB.ParameterGroup("example", new()
 *     {
 *         Name = "example_value",
 *         DbType = "MySQL",
 *         DbVersion = "8.0",
 *         Parameters = new[]
 *         {
 *             new AliCloud.PolarDB.Inputs.ParameterGroupParameterArgs
 *             {
 *                 ParamName = "wait_timeout",
 *                 ParamValue = "86400",
 *             },
 *         },
 *         Description = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := polardb.NewParameterGroup(ctx, "example", &polardb.ParameterGroupArgs{
 * 			Name:      pulumi.String("example_value"),
 * 			DbType:    pulumi.String("MySQL"),
 * 			DbVersion: pulumi.String("8.0"),
 * 			Parameters: polardb.ParameterGroupParameterArray{
 * 				&polardb.ParameterGroupParameterArgs{
 * 					ParamName:  pulumi.String("wait_timeout"),
 * 					ParamValue: pulumi.String("86400"),
 * 				},
 * 			},
 * 			Description: pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.polardb.ParameterGroup;
 * import com.pulumi.alicloud.polardb.ParameterGroupArgs;
 * import com.pulumi.alicloud.polardb.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ParameterGroup("example", ParameterGroupArgs.builder()
 *             .name("example_value")
 *             .dbType("MySQL")
 *             .dbVersion("8.0")
 *             .parameters(ParameterGroupParameterArgs.builder()
 *                 .paramName("wait_timeout")
 *                 .paramValue("86400")
 *                 .build())
 *             .description("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:polardb:ParameterGroup
 *     properties:
 *       name: example_value
 *       dbType: MySQL
 *       dbVersion: '8.0'
 *       parameters:
 *         - paramName: wait_timeout
 *           paramValue: '86400'
 *       description: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * PolarDB Parameter Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:polardb/parameterGroup:ParameterGroup example <id>
 * ```
 * @property dbType The type of the database engine. Only `MySQL` is supported.
 * @property dbVersion The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
 * @property description The description of the parameter template. It must be 0 to 200 characters in length.
 * @property name The name of the parameter template. It must be 8 to 64 characters in length, and can contain letters, digits, and underscores (_). It must start with a letter and cannot contain Chinese characters.
 * @property parameters The parameter template. See the following `Block parameters`.
 */
public data class ParameterGroupArgs(
    public val dbType: Output<String>? = null,
    public val dbVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<List<ParameterGroupParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.ParameterGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.ParameterGroupArgs =
        com.pulumi.alicloud.polardb.ParameterGroupArgs.builder()
            .dbType(dbType?.applyValue({ args0 -> args0 }))
            .dbVersion(dbVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ParameterGroupArgs].
 */
@PulumiTagMarker
public class ParameterGroupArgsBuilder internal constructor() {
    private var dbType: Output<String>? = null

    private var dbVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ParameterGroupParameterArgs>>? = null

    /**
     * @param value The type of the database engine. Only `MySQL` is supported.
     */
    @JvmName("ieyaxhxnktpehulr")
    public suspend fun dbType(`value`: Output<String>) {
        this.dbType = value
    }

    /**
     * @param value The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
     */
    @JvmName("xcfwlyjcouvagmtq")
    public suspend fun dbVersion(`value`: Output<String>) {
        this.dbVersion = value
    }

    /**
     * @param value The description of the parameter template. It must be 0 to 200 characters in length.
     */
    @JvmName("mvrtxkjkawckcaif")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the parameter template. It must be 8 to 64 characters in length, and can contain letters, digits, and underscores (_). It must start with a letter and cannot contain Chinese characters.
     */
    @JvmName("lkwvbcryngqgbmhp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameter template. See the following `Block parameters`.
     */
    @JvmName("nrglhlluxcytqimw")
    public suspend fun parameters(`value`: Output<List<ParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("gavrbgfqyjaqjboj")
    public suspend fun parameters(vararg values: Output<ParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameter template. See the following `Block parameters`.
     */
    @JvmName("ssotvcojuooqttnx")
    public suspend fun parameters(values: List<Output<ParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The type of the database engine. Only `MySQL` is supported.
     */
    @JvmName("ksfwlqvdnstjkswm")
    public suspend fun dbType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbType = mapped
    }

    /**
     * @param value The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
     */
    @JvmName("aaqhpcquxxvtusvx")
    public suspend fun dbVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbVersion = mapped
    }

    /**
     * @param value The description of the parameter template. It must be 0 to 200 characters in length.
     */
    @JvmName("rhoxfyeuxycjekhq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the parameter template. It must be 8 to 64 characters in length, and can contain letters, digits, and underscores (_). It must start with a letter and cannot contain Chinese characters.
     */
    @JvmName("ihnfjthhlqljdryj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameter template. See the following `Block parameters`.
     */
    @JvmName("cvnuntavrtwtxndf")
    public suspend fun parameters(`value`: List<ParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameter template. See the following `Block parameters`.
     */
    @JvmName("idgjntcjccrfpepg")
    public suspend fun parameters(argument: List<suspend ParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameter template. See the following `Block parameters`.
     */
    @JvmName("rkldxxisoejpkwbr")
    public suspend fun parameters(vararg argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameter template. See the following `Block parameters`.
     */
    @JvmName("espobdmnnggorlsk")
    public suspend fun parameters(argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameter template. See the following `Block parameters`.
     */
    @JvmName("phoosetacvqgvgvk")
    public suspend fun parameters(vararg values: ParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): ParameterGroupArgs = ParameterGroupArgs(
        dbType = dbType,
        dbVersion = dbVersion,
        description = description,
        name = name,
        parameters = parameters,
    )
}
