@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin

import com.pulumi.alicloud.polardb.PolardbFunctions.getAccountsPlain
import com.pulumi.alicloud.polardb.PolardbFunctions.getClustersPlain
import com.pulumi.alicloud.polardb.PolardbFunctions.getDatabasesPlain
import com.pulumi.alicloud.polardb.PolardbFunctions.getEndpointsPlain
import com.pulumi.alicloud.polardb.PolardbFunctions.getGlobalDatabaseNetworksPlain
import com.pulumi.alicloud.polardb.PolardbFunctions.getNodeClassesPlain
import com.pulumi.alicloud.polardb.PolardbFunctions.getParameterGroupsPlain
import com.pulumi.alicloud.polardb.PolardbFunctions.getZonesPlain
import com.pulumi.alicloud.polardb.kotlin.inputs.GetAccountsPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetAccountsPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.GetDatabasesPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetDatabasesPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.GetEndpointsPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetEndpointsPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.GetGlobalDatabaseNetworksPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetGlobalDatabaseNetworksPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.GetNodeClassesPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetNodeClassesPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.GetParameterGroupsPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetParameterGroupsPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.polardb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.polardb.kotlin.outputs.GetAccountsResult
import com.pulumi.alicloud.polardb.kotlin.outputs.GetClustersResult
import com.pulumi.alicloud.polardb.kotlin.outputs.GetDatabasesResult
import com.pulumi.alicloud.polardb.kotlin.outputs.GetEndpointsResult
import com.pulumi.alicloud.polardb.kotlin.outputs.GetGlobalDatabaseNetworksResult
import com.pulumi.alicloud.polardb.kotlin.outputs.GetNodeClassesResult
import com.pulumi.alicloud.polardb.kotlin.outputs.GetParameterGroupsResult
import com.pulumi.alicloud.polardb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.polardb.kotlin.outputs.GetAccountsResult.Companion.toKotlin as getAccountsResultToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.GetDatabasesResult.Companion.toKotlin as getDatabasesResultToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.GetEndpointsResult.Companion.toKotlin as getEndpointsResultToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.GetGlobalDatabaseNetworksResult.Companion.toKotlin as getGlobalDatabaseNetworksResultToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.GetNodeClassesResult.Companion.toKotlin as getNodeClassesResultToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.GetParameterGroupsResult.Companion.toKotlin as getParameterGroupsResultToKotlin
import com.pulumi.alicloud.polardb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object PolardbFunctions {
    /**
     * The `alicloud.polardb.getAccounts` data source provides a collection of PolarDB cluster database account available in Alibaba Cloud account.
     * Filters support regular expression for the account name, searches by clusterId.
     * > **NOTE:** Available since v1.70.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * export = async () => {
     *     const this = await alicloud.polardb.getNodeClasses({
     *         dbType: "MySQL",
     *         dbVersion: "8.0",
     *         payType: "PostPaid",
     *         category: "Normal",
     *     });
     *     const defaultNetwork = new alicloud.vpc.Network("default", {
     *         vpcName: "terraform-example",
     *         cidrBlock: "172.16.0.0/16",
     *     });
     *     const defaultSwitch = new alicloud.vpc.Switch("default", {
     *         vpcId: defaultNetwork.id,
     *         cidrBlock: "172.16.0.0/24",
     *         zoneId: _this.classes?.[0]?.zoneId,
     *         vswitchName: "terraform-example",
     *     });
     *     const cluster = new alicloud.polardb.Cluster("cluster", {
     *         dbType: "MySQL",
     *         dbVersion: "8.0",
     *         payType: "PostPaid",
     *         dbNodeCount: 2,
     *         dbNodeClass: _this.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass,
     *         vswitchId: defaultSwitch.id,
     *     });
     *     const polardbClustersDs = alicloud.polardb.getClustersOutput({
     *         descriptionRegex: cluster.description,
     *         status: "Running",
     *     });
     *     const account = new alicloud.polardb.Account("account", {
     *         dbClusterId: polardbClustersDs.apply(polardbClustersDs => polardbClustersDs.clusters?.[0]?.id),
     *         accountName: "tfnormal_01",
     *         accountPassword: "Test12345",
     *         accountDescription: "tf_account_description",
     *         accountType: "Normal",
     *     });
     *     const default = pulumi.all([polardbClustersDs, account&#46;accountName])&#46;apply(([polardbClustersDs, accountName]) => alicloud.polardb.getAccountsOutput({
     *         dbClusterId: polardbClustersDs.clusters?.[0]?.id,
     *         nameRegex: accountName,
     *     }));
     *     return {
     *         account: _default.apply(_default => _default.accounts?.[0]?.accountName),
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.polardb.get_node_classes(db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     category="Normal")
     * default_network = alicloud.vpc.Network("default",
     *     vpc_name="terraform-example",
     *     cidr_block="172.16.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default_network.id,
     *     cidr_block="172.16.0.0/24",
     *     zone_id=this.classes[0].zone_id,
     *     vswitch_name="terraform-example")
     * cluster = alicloud.polardb.Cluster("cluster",
     *     db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     db_node_count=2,
     *     db_node_class=this.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
     *     vswitch_id=default_switch.id)
     * polardb_clusters_ds = alicloud.polardb.get_clusters_output(description_regex=cluster.description,
     *     status="Running")
     * account = alicloud.polardb.Account("account",
     *     db_cluster_id=polardb_clusters_ds.clusters[0].id,
     *     account_name="tfnormal_01",
     *     account_password="Test12345",
     *     account_description="tf_account_description",
     *     account_type="Normal")
     * default = pulumi.Output.all(
     *     polardb_clusters_ds=polardb_clusters_ds,
     *     account_name=account.account_name
     * ).apply(lambda resolved_outputs: alicloud.polardb.get_accounts_output(db_cluster_id=polardb_clusters_ds.clusters[0].id,
     *     name_regex=resolved_outputs['account_name']))
     * pulumi.export("account", default.accounts[0].account_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         Category = "Normal",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = "terraform-example",
     *         CidrBlock = "172.16.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "172.16.0.0/24",
     *         ZoneId = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
     *         VswitchName = "terraform-example",
     *     });
     *     var cluster = new AliCloud.PolarDB.Cluster("cluster", new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         DbNodeCount = 2,
     *         DbNodeClass = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var polardbClustersDs = AliCloud.PolarDB.GetClusters.Invoke(new()
     *     {
     *         DescriptionRegex = cluster.Description,
     *         Status = "Running",
     *     });
     *     var account = new AliCloud.PolarDB.Account("account", new()
     *     {
     *         DbClusterId = polardbClustersDs.Apply(getClustersResult => getClustersResult.Clusters[0]?.Id),
     *         AccountName = "tfnormal_01",
     *         AccountPassword = "Test12345",
     *         AccountDescription = "tf_account_description",
     *         AccountType = "Normal",
     *     });
     *     var @default = AliCloud.PolarDB.GetAccounts.Invoke(new()
     *     {
     *         DbClusterId = polardbClustersDs.Apply(getClustersResult => getClustersResult.Clusters[0]?.Id),
     *         NameRegex = account.AccountName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["account"] = @default&#46;Apply(@default => @default&#46;Apply(getAccountsResult => getAccountsResult&#46;Accounts[0]?.AccountName)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * this, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
     * DbType: pulumi.StringRef("MySQL"),
     * DbVersion: pulumi.StringRef("8.0"),
     * PayType: "PostPaid",
     * Category: pulumi.StringRef("Normal"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * VpcName: pulumi.String("terraform-example"),
     * CidrBlock: pulumi.String("172.16.0.0/16"),
     * })
     * if err != nil {
     * return err
     * }
     * defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * VpcId: defaultNetwork.ID(),
     * CidrBlock: pulumi.String("172.16.0.0/24"),
     * ZoneId: pulumi.String(this.Classes[0].ZoneId),
     * VswitchName: pulumi.String("terraform-example"),
     * })
     * if err != nil {
     * return err
     * }
     * cluster, err := polardb.NewCluster(ctx, "cluster", &polardb.ClusterArgs{
     * DbType: pulumi.String("MySQL"),
     * DbVersion: pulumi.String("8.0"),
     * PayType: pulumi.String("PostPaid"),
     * DbNodeCount: pulumi.Int(2),
     * DbNodeClass: pulumi.String(this.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
     * VswitchId: defaultSwitch.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * polardbClustersDs := polardb.GetClustersOutput(ctx, polardb.GetClustersOutputArgs{
     * DescriptionRegex: cluster.Description,
     * Status: pulumi.String("Running"),
     * }, nil);
     * account, err := polardb.NewAccount(ctx, "account", &polardb.AccountArgs{
     * DbClusterId: pulumi.String(polardbClustersDs.ApplyT(func(polardbClustersDs polardb.GetClustersResult) (*string, error) {
     * return &polardbClustersDs.Clusters[0].Id, nil
     * }).(pulumi.StringPtrOutput)),
     * AccountName: pulumi.String("tfnormal_01"),
     * AccountPassword: pulumi.String("Test12345"),
     * AccountDescription: pulumi.String("tf_account_description"),
     * AccountType: pulumi.String("Normal"),
     * })
     * if err != nil {
     * return err
     * }
     * _default := pulumi.All(polardbClustersDs,account.AccountName).ApplyT(func(_args []interface{}) (polardb.GetAccountsResult, error) {
     * polardbClustersDs := _args[0].(polardb.GetClustersResult)
     * accountName := _args[1].(string)
     * return polardb.GetAccountsResult(interface{}(polardb.GetAccountsOutput(ctx, polardb.GetAccountsOutputArgs{
     * DbClusterId: polardbClustersDs.Clusters[0].Id,
     * NameRegex: accountName,
     * }, nil))), nil
     * }).(polardb.GetAccountsResultOutput)
     * ctx.Export("account", _default.ApplyT(func(_default polardb.GetAccountsResult) (*string, error) {
     * return &default.Accounts[0].AccountName, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.polardb.Cluster;
     * import com.pulumi.alicloud.polardb.ClusterArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetClustersArgs;
     * import com.pulumi.alicloud.polardb.Account;
     * import com.pulumi.alicloud.polardb.AccountArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .category("Normal")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .vpcName("terraform-example")
     *             .cidrBlock("172.16.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("172.16.0.0/24")
     *             .zoneId(this_.classes()[0].zoneId())
     *             .vswitchName("terraform-example")
     *             .build());
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .dbNodeCount("2")
     *             .dbNodeClass(this_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         final var polardbClustersDs = PolardbFunctions.getClusters(GetClustersArgs.builder()
     *             .descriptionRegex(cluster.description())
     *             .status("Running")
     *             .build());
     *         var account = new Account("account", AccountArgs.builder()
     *             .dbClusterId(polardbClustersDs.applyValue(getClustersResult -> getClustersResult).applyValue(polardbClustersDs -> polardbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id())))
     *             .accountName("tfnormal_01")
     *             .accountPassword("Test12345")
     *             .accountDescription("tf_account_description")
     *             .accountType("Normal")
     *             .build());
     *         final var default = PolardbFunctions.getAccounts(GetAccountsArgs.builder()
     *             .dbClusterId(polardbClustersDs.applyValue(getClustersResult -> getClustersResult).applyValue(polardbClustersDs -> polardbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id())))
     *             .nameRegex(account.accountName())
     *             .build());
     *         ctx.export("account", default_.applyValue(default_ -> default_.accounts()[0].accountName()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultNetwork:
     *     type: alicloud:vpc:Network
     *     name: default
     *     properties:
     *       vpcName: terraform-example
     *       cidrBlock: 172.16.0.0/16
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       cidrBlock: 172.16.0.0/24
     *       zoneId: ${this.classes[0].zoneId}
     *       vswitchName: terraform-example
     *   cluster:
     *     type: alicloud:polardb:Cluster
     *     properties:
     *       dbType: MySQL
     *       dbVersion: '8.0'
     *       payType: PostPaid
     *       dbNodeCount: '2'
     *       dbNodeClass: ${this.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
     *       vswitchId: ${defaultSwitch.id}
     *   account:
     *     type: alicloud:polardb:Account
     *     properties:
     *       dbClusterId: ${polardbClustersDs.clusters[0].id}
     *       accountName: tfnormal_01
     *       accountPassword: Test12345
     *       accountDescription: tf_account_description
     *       accountType: Normal
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:polardb:getNodeClasses
     *       Arguments:
     *         dbType: MySQL
     *         dbVersion: '8.0'
     *         payType: PostPaid
     *         category: Normal
     *   polardbClustersDs:
     *     fn::invoke:
     *       Function: alicloud:polardb:getClusters
     *       Arguments:
     *         descriptionRegex: ${cluster.description}
     *         status: Running
     *   default:
     *     fn::invoke:
     *       Function: alicloud:polardb:getAccounts
     *       Arguments:
     *         dbClusterId: ${polardbClustersDs.clusters[0].id}
     *         nameRegex: ${account.accountName}
     * outputs:
     *   account: ${default.accounts[0].accountName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccounts.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: GetAccountsPlainArgs): GetAccountsResult =
        getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())

    /**
     * @see [getAccounts].
     * @param dbClusterId The polarDB cluster ID.
     * @param nameRegex A regex string to filter results by account name.
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(dbClusterId: String, nameRegex: String? = null): GetAccountsResult {
        val argument = GetAccountsPlainArgs(
            dbClusterId = dbClusterId,
            nameRegex = nameRegex,
        )
        return getAccountsResultToKotlin(getAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetAccountsPlainArgs].
     * @return A collection of values returned by getAccounts.
     */
    public suspend fun getAccounts(argument: suspend GetAccountsPlainArgsBuilder.() -> Unit): GetAccountsResult {
        val builder = GetAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountsResultToKotlin(getAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.polardb.getClusters` data source provides a collection of PolarDB clusters available in Alibaba Cloud account.
     * Filters support regular expression for the cluster description, searches by tags, and other filters which are listed below.
     * > **NOTE:** Available since v1.66.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const this = alicloud.polardb.getNodeClasses({
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     category: "Normal",
     * });
     * const _default = new alicloud.vpc.Network("default", {
     *     vpcName: "terraform-example",
     *     cidrBlock: "172.16.0.0/16",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: _default.id,
     *     cidrBlock: "172.16.0.0/24",
     *     zoneId: _this.then(_this => _this.classes?.[0]?.zoneId),
     *     vswitchName: "terraform-example",
     * });
     * const cluster = new alicloud.polardb.Cluster("cluster", {
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     dbNodeCount: 2,
     *     dbNodeClass: _this.then(_this => _this.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
     *     vswitchId: defaultSwitch.id,
     * });
     * const polardbClustersDs = alicloud.polardb.getClustersOutput({
     *     descriptionRegex: cluster.id,
     *     status: "Running",
     * });
     * export const firstPolardbClusterId = polardbClustersDs.apply(polardbClustersDs => polardbClustersDs.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.polardb.get_node_classes(db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     category="Normal")
     * default = alicloud.vpc.Network("default",
     *     vpc_name="terraform-example",
     *     cidr_block="172.16.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default.id,
     *     cidr_block="172.16.0.0/24",
     *     zone_id=this.classes[0].zone_id,
     *     vswitch_name="terraform-example")
     * cluster = alicloud.polardb.Cluster("cluster",
     *     db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     db_node_count=2,
     *     db_node_class=this.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
     *     vswitch_id=default_switch.id)
     * polardb_clusters_ds = alicloud.polardb.get_clusters_output(description_regex=cluster.id,
     *     status="Running")
     * pulumi.export("firstPolardbClusterId", polardb_clusters_ds.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         Category = "Normal",
     *     });
     *     var @default = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = "terraform-example",
     *         CidrBlock = "172.16.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = @default.Id,
     *         CidrBlock = "172.16.0.0/24",
     *         ZoneId = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
     *         VswitchName = "terraform-example",
     *     });
     *     var cluster = new AliCloud.PolarDB.Cluster("cluster", new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         DbNodeCount = 2,
     *         DbNodeClass = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var polardbClustersDs = AliCloud.PolarDB.GetClusters.Invoke(new()
     *     {
     *         DescriptionRegex = cluster.Id,
     *         Status = "Running",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPolardbClusterId"] = polardbClustersDs&#46;Apply(getClustersResult => getClustersResult&#46;Clusters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		this, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
     * 			DbType:    pulumi.StringRef("MySQL"),
     * 			DbVersion: pulumi.StringRef("8.0"),
     * 			PayType:   "PostPaid",
     * 			Category:  pulumi.StringRef("Normal"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * 			VpcName:   pulumi.String("terraform-example"),
     * 			CidrBlock: pulumi.String("172.16.0.0/16"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * 			VpcId:       _default.ID(),
     * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
     * 			ZoneId:      pulumi.String(this.Classes[0].ZoneId),
     * 			VswitchName: pulumi.String("terraform-example"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		cluster, err := polardb.NewCluster(ctx, "cluster", &polardb.ClusterArgs{
     * 			DbType:      pulumi.String("MySQL"),
     * 			DbVersion:   pulumi.String("8.0"),
     * 			PayType:     pulumi.String("PostPaid"),
     * 			DbNodeCount: pulumi.Int(2),
     * 			DbNodeClass: pulumi.String(this.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
     * 			VswitchId:   defaultSwitch.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		polardbClustersDs := polardb.GetClustersOutput(ctx, polardb.GetClustersOutputArgs{
     * 			DescriptionRegex: cluster.ID(),
     * 			Status:           pulumi.String("Running"),
     * 		}, nil)
     * 		ctx.Export("firstPolardbClusterId", polardbClustersDs.ApplyT(func(polardbClustersDs polardb.GetClustersResult) (*string, error) {
     * 			return &polardbClustersDs.Clusters[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.polardb.Cluster;
     * import com.pulumi.alicloud.polardb.ClusterArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .category("Normal")
     *             .build());
     *         var default_ = new Network("default", NetworkArgs.builder()
     *             .vpcName("terraform-example")
     *             .cidrBlock("172.16.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(default_.id())
     *             .cidrBlock("172.16.0.0/24")
     *             .zoneId(this_.classes()[0].zoneId())
     *             .vswitchName("terraform-example")
     *             .build());
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .dbNodeCount("2")
     *             .dbNodeClass(this_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         final var polardbClustersDs = PolardbFunctions.getClusters(GetClustersArgs.builder()
     *             .descriptionRegex(cluster.id())
     *             .status("Running")
     *             .build());
     *         ctx.export("firstPolardbClusterId", polardbClustersDs.applyValue(getClustersResult -> getClustersResult).applyValue(polardbClustersDs -> polardbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:vpc:Network
     *     properties:
     *       vpcName: terraform-example
     *       cidrBlock: 172.16.0.0/16
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${default.id}
     *       cidrBlock: 172.16.0.0/24
     *       zoneId: ${this.classes[0].zoneId}
     *       vswitchName: terraform-example
     *   cluster:
     *     type: alicloud:polardb:Cluster
     *     properties:
     *       dbType: MySQL
     *       dbVersion: '8.0'
     *       payType: PostPaid
     *       dbNodeCount: '2'
     *       dbNodeClass: ${this.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
     *       vswitchId: ${defaultSwitch.id}
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:polardb:getNodeClasses
     *       Arguments:
     *         dbType: MySQL
     *         dbVersion: '8.0'
     *         payType: PostPaid
     *         category: Normal
     *   polardbClustersDs:
     *     fn::invoke:
     *       Function: alicloud:polardb:getClusters
     *       Arguments:
     *         descriptionRegex: ${cluster.id}
     *         status: Running
     * outputs:
     *   firstPolardbClusterId: ${polardbClustersDs.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param dbType Database type. Options are `MySQL`, `Oracle` and `PostgreSQL`. If no value is specified, all types are returned.
     * @param descriptionRegex A regex string to filter results by cluster description.
     * @param ids A list of PolarDB cluster IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status status of the cluster.
     * @param tags A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(
        dbType: String? = null,
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetClustersResult {
        val argument = GetClustersPlainArgs(
            dbType = dbType,
            descriptionRegex = descriptionRegex,
            ids = ids,
            outputFile = outputFile,
            status = status,
            tags = tags,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.polardb.getDatabases` data source provides a collection of PolarDB cluster database available in Alibaba Cloud account.
     * Filters support regular expression for the database name, searches by clusterId.
     * > **NOTE:** Available since v1.70.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const this = alicloud.polardb.getNodeClasses({
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     category: "Normal",
     * });
     * const defaultNetwork = new alicloud.vpc.Network("default", {
     *     vpcName: "terraform-example",
     *     cidrBlock: "172.16.0.0/16",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: defaultNetwork.id,
     *     cidrBlock: "172.16.0.0/24",
     *     zoneId: _this.then(_this => _this.classes?.[0]?.zoneId),
     *     vswitchName: "terraform-example",
     * });
     * const cluster = new alicloud.polardb.Cluster("cluster", {
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     dbNodeCount: 2,
     *     dbNodeClass: _this.then(_this => _this.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
     *     vswitchId: defaultSwitch.id,
     * });
     * const polardbClustersDs = alicloud.polardb.getClustersOutput({
     *     descriptionRegex: cluster.description,
     *     status: "Running",
     * });
     * const defaultDatabase = new alicloud.polardb.Database("default", {
     *     dbClusterId: polardbClustersDs.apply(polardbClustersDs => polardbClustersDs.clusters?.[0]?.id),
     *     dbName: polardbClustersDs.apply(polardbClustersDs => `tfaccountpri_${polardbClustersDs.clusters?.[0]?.id}`),
     *     dbDescription: "from terraform",
     * });
     * const default = pulumi.all([polardbClustersDs, defaultDatabase&#46;dbName])&#46;apply(([polardbClustersDs, dbName]) => alicloud.polardb.getDatabasesOutput({
     *     dbClusterId: polardbClustersDs.clusters?.[0]?.id,
     *     nameRegex: dbName,
     * }));
     * export const database = _default.apply(_default => _default.databases?.[0]?.dbName);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.polardb.get_node_classes(db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     category="Normal")
     * default_network = alicloud.vpc.Network("default",
     *     vpc_name="terraform-example",
     *     cidr_block="172.16.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default_network.id,
     *     cidr_block="172.16.0.0/24",
     *     zone_id=this.classes[0].zone_id,
     *     vswitch_name="terraform-example")
     * cluster = alicloud.polardb.Cluster("cluster",
     *     db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     db_node_count=2,
     *     db_node_class=this.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
     *     vswitch_id=default_switch.id)
     * polardb_clusters_ds = alicloud.polardb.get_clusters_output(description_regex=cluster.description,
     *     status="Running")
     * default_database = alicloud.polardb.Database("default",
     *     db_cluster_id=polardb_clusters_ds.clusters[0].id,
     *     db_name=polardb_clusters_ds.apply(lambda polardb_clusters_ds: f"tfaccountpri_{polardb_clusters_ds.clusters[0].id}"),
     *     db_description="from terraform")
     * default = pulumi.Output.all(
     *     polardb_clusters_ds=polardb_clusters_ds,
     *     db_name=default_database.db_name
     * ).apply(lambda resolved_outputs: alicloud.polardb.get_databases_output(db_cluster_id=polardb_clusters_ds.clusters[0].id,
     *     name_regex=resolved_outputs['db_name']))
     * pulumi.export("database", default.databases[0].db_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         Category = "Normal",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = "terraform-example",
     *         CidrBlock = "172.16.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "172.16.0.0/24",
     *         ZoneId = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
     *         VswitchName = "terraform-example",
     *     });
     *     var cluster = new AliCloud.PolarDB.Cluster("cluster", new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         DbNodeCount = 2,
     *         DbNodeClass = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var polardbClustersDs = AliCloud.PolarDB.GetClusters.Invoke(new()
     *     {
     *         DescriptionRegex = cluster.Description,
     *         Status = "Running",
     *     });
     *     var defaultDatabase = new AliCloud.PolarDB.Database("default", new()
     *     {
     *         DbClusterId = polardbClustersDs.Apply(getClustersResult => getClustersResult.Clusters[0]?.Id),
     *         DbName = $"tfaccountpri_{polardbClustersDs.Apply(getClustersResult => getClustersResult.Clusters[0]?.Id)}",
     *         DbDescription = "from terraform",
     *     });
     *     var @default = AliCloud.PolarDB.GetDatabases.Invoke(new()
     *     {
     *         DbClusterId = polardbClustersDs.Apply(getClustersResult => getClustersResult.Clusters[0]?.Id),
     *         NameRegex = defaultDatabase.DbName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["database"] = @default&#46;Apply(@default => @default&#46;Apply(getDatabasesResult => getDatabasesResult&#46;Databases[0]?.DbName)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * this, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
     * DbType: pulumi.StringRef("MySQL"),
     * DbVersion: pulumi.StringRef("8.0"),
     * PayType: "PostPaid",
     * Category: pulumi.StringRef("Normal"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * VpcName: pulumi.String("terraform-example"),
     * CidrBlock: pulumi.String("172.16.0.0/16"),
     * })
     * if err != nil {
     * return err
     * }
     * defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * VpcId: defaultNetwork.ID(),
     * CidrBlock: pulumi.String("172.16.0.0/24"),
     * ZoneId: pulumi.String(this.Classes[0].ZoneId),
     * VswitchName: pulumi.String("terraform-example"),
     * })
     * if err != nil {
     * return err
     * }
     * cluster, err := polardb.NewCluster(ctx, "cluster", &polardb.ClusterArgs{
     * DbType: pulumi.String("MySQL"),
     * DbVersion: pulumi.String("8.0"),
     * PayType: pulumi.String("PostPaid"),
     * DbNodeCount: pulumi.Int(2),
     * DbNodeClass: pulumi.String(this.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
     * VswitchId: defaultSwitch.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * polardbClustersDs := polardb.GetClustersOutput(ctx, polardb.GetClustersOutputArgs{
     * DescriptionRegex: cluster.Description,
     * Status: pulumi.String("Running"),
     * }, nil);
     * defaultDatabase, err := polardb.NewDatabase(ctx, "default", &polardb.DatabaseArgs{
     * DbClusterId: pulumi.String(polardbClustersDs.ApplyT(func(polardbClustersDs polardb.GetClustersResult) (*string, error) {
     * return &polardbClustersDs.Clusters[0].Id, nil
     * }).(pulumi.StringPtrOutput)),
     * DbName: polardbClustersDs.ApplyT(func(polardbClustersDs polardb.GetClustersResult) (string, error) {
     * return fmt.Sprintf("tfaccountpri_%v", polardbClustersDs.Clusters[0].Id), nil
     * }).(pulumi.StringOutput),
     * DbDescription: pulumi.String("from terraform"),
     * })
     * if err != nil {
     * return err
     * }
     * _default := pulumi.All(polardbClustersDs,defaultDatabase.DbName).ApplyT(func(_args []interface{}) (polardb.GetDatabasesResult, error) {
     * polardbClustersDs := _args[0].(polardb.GetClustersResult)
     * dbName := _args[1].(string)
     * return polardb.GetDatabasesResult(interface{}(polardb.GetDatabasesOutput(ctx, polardb.GetDatabasesOutputArgs{
     * DbClusterId: polardbClustersDs.Clusters[0].Id,
     * NameRegex: dbName,
     * }, nil))), nil
     * }).(polardb.GetDatabasesResultOutput)
     * ctx.Export("database", _default.ApplyT(func(_default polardb.GetDatabasesResult) (*string, error) {
     * return &default.Databases[0].DbName, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.polardb.Cluster;
     * import com.pulumi.alicloud.polardb.ClusterArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetClustersArgs;
     * import com.pulumi.alicloud.polardb.Database;
     * import com.pulumi.alicloud.polardb.DatabaseArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetDatabasesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .category("Normal")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .vpcName("terraform-example")
     *             .cidrBlock("172.16.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("172.16.0.0/24")
     *             .zoneId(this_.classes()[0].zoneId())
     *             .vswitchName("terraform-example")
     *             .build());
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .dbNodeCount("2")
     *             .dbNodeClass(this_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         final var polardbClustersDs = PolardbFunctions.getClusters(GetClustersArgs.builder()
     *             .descriptionRegex(cluster.description())
     *             .status("Running")
     *             .build());
     *         var defaultDatabase = new Database("defaultDatabase", DatabaseArgs.builder()
     *             .dbClusterId(polardbClustersDs.applyValue(getClustersResult -> getClustersResult).applyValue(polardbClustersDs -> polardbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id())))
     *             .dbName(polardbClustersDs.applyValue(getClustersResult -> getClustersResult).applyValue(polardbClustersDs -> String.format("tfaccountpri_%s", polardbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id()))))
     *             .dbDescription("from terraform")
     *             .build());
     *         final var default = PolardbFunctions.getDatabases(GetDatabasesArgs.builder()
     *             .dbClusterId(polardbClustersDs.applyValue(getClustersResult -> getClustersResult).applyValue(polardbClustersDs -> polardbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id())))
     *             .nameRegex(defaultDatabase.dbName())
     *             .build());
     *         ctx.export("database", default_.applyValue(default_ -> default_.databases()[0].dbName()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultNetwork:
     *     type: alicloud:vpc:Network
     *     name: default
     *     properties:
     *       vpcName: terraform-example
     *       cidrBlock: 172.16.0.0/16
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       cidrBlock: 172.16.0.0/24
     *       zoneId: ${this.classes[0].zoneId}
     *       vswitchName: terraform-example
     *   cluster:
     *     type: alicloud:polardb:Cluster
     *     properties:
     *       dbType: MySQL
     *       dbVersion: '8.0'
     *       payType: PostPaid
     *       dbNodeCount: '2'
     *       dbNodeClass: ${this.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
     *       vswitchId: ${defaultSwitch.id}
     *   defaultDatabase:
     *     type: alicloud:polardb:Database
     *     name: default
     *     properties:
     *       dbClusterId: ${polardbClustersDs.clusters[0].id}
     *       dbName: tfaccountpri_${polardbClustersDs.clusters[0].id}
     *       dbDescription: from terraform
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:polardb:getNodeClasses
     *       Arguments:
     *         dbType: MySQL
     *         dbVersion: '8.0'
     *         payType: PostPaid
     *         category: Normal
     *   polardbClustersDs:
     *     fn::invoke:
     *       Function: alicloud:polardb:getClusters
     *       Arguments:
     *         descriptionRegex: ${cluster.description}
     *         status: Running
     *   default:
     *     fn::invoke:
     *       Function: alicloud:polardb:getDatabases
     *       Arguments:
     *         dbClusterId: ${polardbClustersDs.clusters[0].id}
     *         nameRegex: ${defaultDatabase.dbName}
     * outputs:
     *   database: ${default.databases[0].dbName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDatabases.
     * @return A collection of values returned by getDatabases.
     */
    public suspend fun getDatabases(argument: GetDatabasesPlainArgs): GetDatabasesResult =
        getDatabasesResultToKotlin(getDatabasesPlain(argument.toJava()).await())

    /**
     * @see [getDatabases].
     * @param dbClusterId The polarDB cluster ID.
     * @param nameRegex A regex string to filter results by database name.
     * @return A collection of values returned by getDatabases.
     */
    public suspend fun getDatabases(dbClusterId: String, nameRegex: String? = null): GetDatabasesResult {
        val argument = GetDatabasesPlainArgs(
            dbClusterId = dbClusterId,
            nameRegex = nameRegex,
        )
        return getDatabasesResultToKotlin(getDatabasesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabases].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetDatabasesPlainArgs].
     * @return A collection of values returned by getDatabases.
     */
    public suspend fun getDatabases(argument: suspend GetDatabasesPlainArgsBuilder.() -> Unit): GetDatabasesResult {
        val builder = GetDatabasesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabasesResultToKotlin(getDatabasesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.polardb.getEndpoints` data source provides a collection of PolarDB endpoints available in Alibaba Cloud account.
     * Filters support regular expression for the cluster name, searches by clusterId, and other filters which are listed below.
     * > **NOTE:** Available since v1.68.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const this = alicloud.polardb.getNodeClasses({
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     category: "Normal",
     * });
     * const defaultNetwork = new alicloud.vpc.Network("default", {
     *     vpcName: "terraform-example",
     *     cidrBlock: "172.16.0.0/16",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: defaultNetwork.id,
     *     cidrBlock: "172.16.0.0/24",
     *     zoneId: _this.then(_this => _this.classes?.[0]?.zoneId),
     *     vswitchName: "terraform-example",
     * });
     * const cluster = new alicloud.polardb.Cluster("cluster", {
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     dbNodeCount: 2,
     *     dbNodeClass: _this.then(_this => _this.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
     *     vswitchId: defaultSwitch.id,
     * });
     * const polardbClustersDs = alicloud.polardb.getClustersOutput({
     *     descriptionRegex: cluster.description,
     *     status: "Running",
     * });
     * const default = polardbClustersDs.apply(polardbClustersDs => alicloud.polardb.getEndpointsOutput({
     *     dbClusterId: polardbClustersDs.clusters?.[0]?.id,
     * }));
     * export const endpoint = _default.apply(_default => _default.endpoints?.[0]?.dbEndpointId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.polardb.get_node_classes(db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     category="Normal")
     * default_network = alicloud.vpc.Network("default",
     *     vpc_name="terraform-example",
     *     cidr_block="172.16.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default_network.id,
     *     cidr_block="172.16.0.0/24",
     *     zone_id=this.classes[0].zone_id,
     *     vswitch_name="terraform-example")
     * cluster = alicloud.polardb.Cluster("cluster",
     *     db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     db_node_count=2,
     *     db_node_class=this.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
     *     vswitch_id=default_switch.id)
     * polardb_clusters_ds = alicloud.polardb.get_clusters_output(description_regex=cluster.description,
     *     status="Running")
     * default = polardb_clusters_ds.apply(lambda polardb_clusters_ds: alicloud.polardb.get_endpoints_output(db_cluster_id=polardb_clusters_ds.clusters[0].id))
     * pulumi.export("endpoint", default.endpoints[0].db_endpoint_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         Category = "Normal",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = "terraform-example",
     *         CidrBlock = "172.16.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "172.16.0.0/24",
     *         ZoneId = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
     *         VswitchName = "terraform-example",
     *     });
     *     var cluster = new AliCloud.PolarDB.Cluster("cluster", new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         DbNodeCount = 2,
     *         DbNodeClass = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var polardbClustersDs = AliCloud.PolarDB.GetClusters.Invoke(new()
     *     {
     *         DescriptionRegex = cluster.Description,
     *         Status = "Running",
     *     });
     *     var @default = AliCloud.PolarDB.GetEndpoints.Invoke(new()
     *     {
     *         DbClusterId = polardbClustersDs.Apply(getClustersResult => getClustersResult.Clusters[0]?.Id),
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["endpoint"] = @default&#46;Apply(@default => @default&#46;Apply(getEndpointsResult => getEndpointsResult&#46;Endpoints[0]?.DbEndpointId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * this, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
     * DbType: pulumi.StringRef("MySQL"),
     * DbVersion: pulumi.StringRef("8.0"),
     * PayType: "PostPaid",
     * Category: pulumi.StringRef("Normal"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * VpcName: pulumi.String("terraform-example"),
     * CidrBlock: pulumi.String("172.16.0.0/16"),
     * })
     * if err != nil {
     * return err
     * }
     * defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * VpcId: defaultNetwork.ID(),
     * CidrBlock: pulumi.String("172.16.0.0/24"),
     * ZoneId: pulumi.String(this.Classes[0].ZoneId),
     * VswitchName: pulumi.String("terraform-example"),
     * })
     * if err != nil {
     * return err
     * }
     * cluster, err := polardb.NewCluster(ctx, "cluster", &polardb.ClusterArgs{
     * DbType: pulumi.String("MySQL"),
     * DbVersion: pulumi.String("8.0"),
     * PayType: pulumi.String("PostPaid"),
     * DbNodeCount: pulumi.Int(2),
     * DbNodeClass: pulumi.String(this.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
     * VswitchId: defaultSwitch.ID(),
     * })
     * if err != nil {
     * return err
     * }
     * polardbClustersDs := polardb.GetClustersOutput(ctx, polardb.GetClustersOutputArgs{
     * DescriptionRegex: cluster.Description,
     * Status: pulumi.String("Running"),
     * }, nil);
     * _default := polardbClustersDs.ApplyT(func(polardbClustersDs polardb.GetClustersResult) (polardb.GetEndpointsResult, error) {
     * return polardb.GetEndpointsResult(interface{}(polardb.GetEndpointsOutput(ctx, polardb.GetEndpointsOutputArgs{
     * DbClusterId: polardbClustersDs.Clusters[0].Id,
     * }, nil))), nil
     * }).(polardb.GetEndpointsResultOutput)
     * ctx.Export("endpoint", _default.ApplyT(func(_default polardb.GetEndpointsResult) (*string, error) {
     * return &default.Endpoints[0].DbEndpointId, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.polardb.Cluster;
     * import com.pulumi.alicloud.polardb.ClusterArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetClustersArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetEndpointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .category("Normal")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .vpcName("terraform-example")
     *             .cidrBlock("172.16.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("172.16.0.0/24")
     *             .zoneId(this_.classes()[0].zoneId())
     *             .vswitchName("terraform-example")
     *             .build());
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .dbNodeCount("2")
     *             .dbNodeClass(this_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         final var polardbClustersDs = PolardbFunctions.getClusters(GetClustersArgs.builder()
     *             .descriptionRegex(cluster.description())
     *             .status("Running")
     *             .build());
     *         final var default = PolardbFunctions.getEndpoints(GetEndpointsArgs.builder()
     *             .dbClusterId(polardbClustersDs.applyValue(getClustersResult -> getClustersResult).applyValue(polardbClustersDs -> polardbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id())))
     *             .build());
     *         ctx.export("endpoint", default_.applyValue(default_ -> default_.endpoints()[0].dbEndpointId()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultNetwork:
     *     type: alicloud:vpc:Network
     *     name: default
     *     properties:
     *       vpcName: terraform-example
     *       cidrBlock: 172.16.0.0/16
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       cidrBlock: 172.16.0.0/24
     *       zoneId: ${this.classes[0].zoneId}
     *       vswitchName: terraform-example
     *   cluster:
     *     type: alicloud:polardb:Cluster
     *     properties:
     *       dbType: MySQL
     *       dbVersion: '8.0'
     *       payType: PostPaid
     *       dbNodeCount: '2'
     *       dbNodeClass: ${this.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
     *       vswitchId: ${defaultSwitch.id}
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:polardb:getNodeClasses
     *       Arguments:
     *         dbType: MySQL
     *         dbVersion: '8.0'
     *         payType: PostPaid
     *         category: Normal
     *   polardbClustersDs:
     *     fn::invoke:
     *       Function: alicloud:polardb:getClusters
     *       Arguments:
     *         descriptionRegex: ${cluster.description}
     *         status: Running
     *   default:
     *     fn::invoke:
     *       Function: alicloud:polardb:getEndpoints
     *       Arguments:
     *         dbClusterId: ${polardbClustersDs.clusters[0].id}
     * outputs:
     *   endpoint: ${default.endpoints[0].dbEndpointId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndpoints.
     * @return A collection of values returned by getEndpoints.
     */
    public suspend fun getEndpoints(argument: GetEndpointsPlainArgs): GetEndpointsResult =
        getEndpointsResultToKotlin(getEndpointsPlain(argument.toJava()).await())

    /**
     * @see [getEndpoints].
     * @param dbClusterId PolarDB cluster ID.
     * @param dbEndpointId endpoint of the cluster.
     * @return A collection of values returned by getEndpoints.
     */
    public suspend fun getEndpoints(dbClusterId: String, dbEndpointId: String? = null): GetEndpointsResult {
        val argument = GetEndpointsPlainArgs(
            dbClusterId = dbClusterId,
            dbEndpointId = dbEndpointId,
        )
        return getEndpointsResultToKotlin(getEndpointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoints].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetEndpointsPlainArgs].
     * @return A collection of values returned by getEndpoints.
     */
    public suspend fun getEndpoints(argument: suspend GetEndpointsPlainArgsBuilder.() -> Unit): GetEndpointsResult {
        val builder = GetEndpointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointsResultToKotlin(getEndpointsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the PolarDB Global Database Networks of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.181.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const this = alicloud.polardb.getNodeClasses({
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     category: "Normal",
     * });
     * const _default = new alicloud.vpc.Network("default", {
     *     vpcName: "terraform-example",
     *     cidrBlock: "172.16.0.0/16",
     * });
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: _default.id,
     *     cidrBlock: "172.16.0.0/24",
     *     zoneId: _this.then(_this => _this.classes?.[0]?.zoneId),
     *     vswitchName: "terraform-example",
     * });
     * const cluster = new alicloud.polardb.Cluster("cluster", {
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     *     payType: "PostPaid",
     *     dbNodeCount: 2,
     *     dbNodeClass: _this.then(_this => _this.classes?.[0]?&#46;supportedEngines?&#46;[0]?&#46;availableResources?&#46;[0]?.dbNodeClass),
     *     vswitchId: defaultSwitch.id,
     * });
     * const defaultGlobalDatabaseNetwork = new alicloud.polardb.GlobalDatabaseNetwork("default", {
     *     dbClusterId: cluster.id,
     *     description: cluster.id,
     * });
     * const ids = alicloud.polardb.getGlobalDatabaseNetworksOutput({
     *     ids: [defaultGlobalDatabaseNetwork&#46;id],
     * });
     * export const polardbGlobalDatabaseNetworkId1 = ids.apply(ids => ids.networks?.[0]?.id);
     * const description = alicloud.polardb.getGlobalDatabaseNetworksOutput({
     *     description: defaultGlobalDatabaseNetwork.description,
     * });
     * export const polardbGlobalDatabaseNetworkId2 = description.apply(description => description.networks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * this = alicloud.polardb.get_node_classes(db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     category="Normal")
     * default = alicloud.vpc.Network("default",
     *     vpc_name="terraform-example",
     *     cidr_block="172.16.0.0/16")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default.id,
     *     cidr_block="172.16.0.0/24",
     *     zone_id=this.classes[0].zone_id,
     *     vswitch_name="terraform-example")
     * cluster = alicloud.polardb.Cluster("cluster",
     *     db_type="MySQL",
     *     db_version="8.0",
     *     pay_type="PostPaid",
     *     db_node_count=2,
     *     db_node_class=this.classes[0]&#46;supported_engines[0]&#46;available_resources[0].db_node_class,
     *     vswitch_id=default_switch.id)
     * default_global_database_network = alicloud.polardb.GlobalDatabaseNetwork("default",
     *     db_cluster_id=cluster.id,
     *     description=cluster.id)
     * ids = alicloud.polardb.get_global_database_networks_output(ids=[default_global_database_network&#46;id])
     * pulumi.export("polardbGlobalDatabaseNetworkId1", ids.networks[0].id)
     * description = alicloud.polardb.get_global_database_networks_output(description=default_global_database_network.description)
     * pulumi.export("polardbGlobalDatabaseNetworkId2", description.networks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         Category = "Normal",
     *     });
     *     var @default = new AliCloud.Vpc.Network("default", new()
     *     {
     *         VpcName = "terraform-example",
     *         CidrBlock = "172.16.0.0/16",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = @default.Id,
     *         CidrBlock = "172.16.0.0/24",
     *         ZoneId = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?.ZoneId)),
     *         VswitchName = "terraform-example",
     *     });
     *     var cluster = new AliCloud.PolarDB.Cluster("cluster", new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *         PayType = "PostPaid",
     *         DbNodeCount = 2,
     *         DbNodeClass = @this.Apply(@this => @this.Apply(getNodeClassesResult => getNodeClassesResult.Classes[0]?&#46;SupportedEngines[0]?&#46;AvailableResources[0]?.DbNodeClass)),
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var defaultGlobalDatabaseNetwork = new AliCloud.PolarDB.GlobalDatabaseNetwork("default", new()
     *     {
     *         DbClusterId = cluster.Id,
     *         Description = cluster.Id,
     *     });
     *     var ids = AliCloud.PolarDB.GetGlobalDatabaseNetworks.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultGlobalDatabaseNetwork.Id,
     *         },
     *     });
     *     var description = AliCloud.PolarDB.GetGlobalDatabaseNetworks.Invoke(new()
     *     {
     *         Description = defaultGlobalDatabaseNetwork.Description,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["polardbGlobalDatabaseNetworkId1"] = ids&#46;Apply(getGlobalDatabaseNetworksResult => getGlobalDatabaseNetworksResult&#46;Networks[0]?.Id),
     *         ["polardbGlobalDatabaseNetworkId2"] = description&#46;Apply(getGlobalDatabaseNetworksResult => getGlobalDatabaseNetworksResult&#46;Networks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		this, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
     * 			DbType:    pulumi.StringRef("MySQL"),
     * 			DbVersion: pulumi.StringRef("8.0"),
     * 			PayType:   "PostPaid",
     * 			Category:  pulumi.StringRef("Normal"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * 			VpcName:   pulumi.String("terraform-example"),
     * 			CidrBlock: pulumi.String("172.16.0.0/16"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * 			VpcId:       _default.ID(),
     * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
     * 			ZoneId:      pulumi.String(this.Classes[0].ZoneId),
     * 			VswitchName: pulumi.String("terraform-example"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		cluster, err := polardb.NewCluster(ctx, "cluster", &polardb.ClusterArgs{
     * 			DbType:      pulumi.String("MySQL"),
     * 			DbVersion:   pulumi.String("8.0"),
     * 			PayType:     pulumi.String("PostPaid"),
     * 			DbNodeCount: pulumi.Int(2),
     * 			DbNodeClass: pulumi.String(this.Classes[0]&#46;SupportedEngines[0]&#46;AvailableResources[0].DbNodeClass),
     * 			VswitchId:   defaultSwitch.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGlobalDatabaseNetwork, err := polardb.NewGlobalDatabaseNetwork(ctx, "default", &polardb.GlobalDatabaseNetworkArgs{
     * 			DbClusterId: cluster.ID(),
     * 			Description: cluster.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids := polardb.GetGlobalDatabaseNetworksOutput(ctx, polardb.GetGlobalDatabaseNetworksOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultGlobalDatabaseNetwork.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("polardbGlobalDatabaseNetworkId1", ids.ApplyT(func(ids polardb.GetGlobalDatabaseNetworksResult) (*string, error) {
     * 			return &ids.Networks[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		description := polardb.GetGlobalDatabaseNetworksOutput(ctx, polardb.GetGlobalDatabaseNetworksOutputArgs{
     * 			Description: defaultGlobalDatabaseNetwork.Description,
     * 		}, nil)
     * 		ctx.Export("polardbGlobalDatabaseNetworkId2", description.ApplyT(func(description polardb.GetGlobalDatabaseNetworksResult) (*string, error) {
     * 			return &description.Networks[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.polardb.Cluster;
     * import com.pulumi.alicloud.polardb.ClusterArgs;
     * import com.pulumi.alicloud.polardb.GlobalDatabaseNetwork;
     * import com.pulumi.alicloud.polardb.GlobalDatabaseNetworkArgs;
     * import com.pulumi.alicloud.polardb.inputs.GetGlobalDatabaseNetworksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .category("Normal")
     *             .build());
     *         var default_ = new Network("default", NetworkArgs.builder()
     *             .vpcName("terraform-example")
     *             .cidrBlock("172.16.0.0/16")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(default_.id())
     *             .cidrBlock("172.16.0.0/24")
     *             .zoneId(this_.classes()[0].zoneId())
     *             .vswitchName("terraform-example")
     *             .build());
     *         var cluster = new Cluster("cluster", ClusterArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .payType("PostPaid")
     *             .dbNodeCount("2")
     *             .dbNodeClass(this_.classes()[0]&#46;supportedEngines()[0]&#46;availableResources()[0].dbNodeClass())
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         var defaultGlobalDatabaseNetwork = new GlobalDatabaseNetwork("defaultGlobalDatabaseNetwork", GlobalDatabaseNetworkArgs.builder()
     *             .dbClusterId(cluster.id())
     *             .description(cluster.id())
     *             .build());
     *         final var ids = PolardbFunctions.getGlobalDatabaseNetworks(GetGlobalDatabaseNetworksArgs.builder()
     *             .ids(defaultGlobalDatabaseNetwork.id())
     *             .build());
     *         ctx.export("polardbGlobalDatabaseNetworkId1", ids.applyValue(getGlobalDatabaseNetworksResult -> getGlobalDatabaseNetworksResult).applyValue(ids -> ids.applyValue(getGlobalDatabaseNetworksResult -> getGlobalDatabaseNetworksResult.networks()[0].id())));
     *         final var description = PolardbFunctions.getGlobalDatabaseNetworks(GetGlobalDatabaseNetworksArgs.builder()
     *             .description(defaultGlobalDatabaseNetwork.description())
     *             .build());
     *         ctx.export("polardbGlobalDatabaseNetworkId2", description.applyValue(getGlobalDatabaseNetworksResult -> getGlobalDatabaseNetworksResult).applyValue(description -> description.applyValue(getGlobalDatabaseNetworksResult -> getGlobalDatabaseNetworksResult.networks()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   default:
     *     type: alicloud:vpc:Network
     *     properties:
     *       vpcName: terraform-example
     *       cidrBlock: 172.16.0.0/16
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${default.id}
     *       cidrBlock: 172.16.0.0/24
     *       zoneId: ${this.classes[0].zoneId}
     *       vswitchName: terraform-example
     *   cluster:
     *     type: alicloud:polardb:Cluster
     *     properties:
     *       dbType: MySQL
     *       dbVersion: '8.0'
     *       payType: PostPaid
     *       dbNodeCount: '2'
     *       dbNodeClass: ${this.classes[0]&#46;supportedEngines[0]&#46;availableResources[0].dbNodeClass}
     *       vswitchId: ${defaultSwitch.id}
     *   defaultGlobalDatabaseNetwork:
     *     type: alicloud:polardb:GlobalDatabaseNetwork
     *     name: default
     *     properties:
     *       dbClusterId: ${cluster.id}
     *       description: ${cluster.id}
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: alicloud:polardb:getNodeClasses
     *       Arguments:
     *         dbType: MySQL
     *         dbVersion: '8.0'
     *         payType: PostPaid
     *         category: Normal
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:polardb:getGlobalDatabaseNetworks
     *       Arguments:
     *         ids:
     *           - ${defaultGlobalDatabaseNetwork.id}
     *   description:
     *     fn::invoke:
     *       Function: alicloud:polardb:getGlobalDatabaseNetworks
     *       Arguments:
     *         description: ${defaultGlobalDatabaseNetwork.description}
     * outputs:
     *   polardbGlobalDatabaseNetworkId1: ${ids.networks[0].id}
     *   polardbGlobalDatabaseNetworkId2: ${description.networks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGlobalDatabaseNetworks.
     * @return A collection of values returned by getGlobalDatabaseNetworks.
     */
    public suspend fun getGlobalDatabaseNetworks(argument: GetGlobalDatabaseNetworksPlainArgs): GetGlobalDatabaseNetworksResult =
        getGlobalDatabaseNetworksResultToKotlin(getGlobalDatabaseNetworksPlain(argument.toJava()).await())

    /**
     * @see [getGlobalDatabaseNetworks].
     * @param dbClusterId The ID of the cluster.
     * @param description The description of the Global Database Network.
     * @param gdnId The ID of the Global Database Network.
     * @param ids A list of Global Database Network IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param status The status of the Global Database Network. Valid values:
     * @return A collection of values returned by getGlobalDatabaseNetworks.
     */
    public suspend fun getGlobalDatabaseNetworks(
        dbClusterId: String? = null,
        description: String? = null,
        gdnId: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetGlobalDatabaseNetworksResult {
        val argument = GetGlobalDatabaseNetworksPlainArgs(
            dbClusterId = dbClusterId,
            description = description,
            gdnId = gdnId,
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            status = status,
        )
        return getGlobalDatabaseNetworksResultToKotlin(getGlobalDatabaseNetworksPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalDatabaseNetworks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetGlobalDatabaseNetworksPlainArgs].
     * @return A collection of values returned by getGlobalDatabaseNetworks.
     */
    public suspend fun getGlobalDatabaseNetworks(argument: suspend GetGlobalDatabaseNetworksPlainArgsBuilder.() -> Unit): GetGlobalDatabaseNetworksResult {
        val builder = GetGlobalDatabaseNetworksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalDatabaseNetworksResultToKotlin(getGlobalDatabaseNetworksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the PolarDB node classes resource available info of Alibaba Cloud.
     * > **NOTE:** Available since v1.81.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const resources = alicloud.polardb.getNodeClasses({
     *     payType: "PostPaid",
     *     dbType: "MySQL",
     *     dbVersion: "5.6",
     * });
     * export const polardbNodeClasses = resources.then(resources => resources.classes);
     * export const polardbAvailableZoneId = resources.then(resources => resources.classes?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * resources = alicloud.polardb.get_node_classes(pay_type="PostPaid",
     *     db_type="MySQL",
     *     db_version="5.6")
     * pulumi.export("polardbNodeClasses", resources.classes)
     * pulumi.export("polardbAvailableZoneId", resources.classes[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var resources = AliCloud.PolarDB.GetNodeClasses.Invoke(new()
     *     {
     *         PayType = "PostPaid",
     *         DbType = "MySQL",
     *         DbVersion = "5.6",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["polardbNodeClasses"] = resources.Apply(getNodeClassesResult => getNodeClassesResult.Classes),
     *         ["polardbAvailableZoneId"] = resources&#46;Apply(getNodeClassesResult => getNodeClassesResult&#46;Classes[0]?.ZoneId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		resources, err := polardb.GetNodeClasses(ctx, &polardb.GetNodeClassesArgs{
     * 			PayType:   "PostPaid",
     * 			DbType:    pulumi.StringRef("MySQL"),
     * 			DbVersion: pulumi.StringRef("5.6"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("polardbNodeClasses", resources.Classes)
     * 		ctx.Export("polardbAvailableZoneId", resources.Classes[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetNodeClassesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var resources = PolardbFunctions.getNodeClasses(GetNodeClassesArgs.builder()
     *             .payType("PostPaid")
     *             .dbType("MySQL")
     *             .dbVersion("5.6")
     *             .build());
     *         ctx.export("polardbNodeClasses", resources.applyValue(getNodeClassesResult -> getNodeClassesResult.classes()));
     *         ctx.export("polardbAvailableZoneId", resources.applyValue(getNodeClassesResult -> getNodeClassesResult.classes()[0].zoneId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   resources:
     *     fn::invoke:
     *       Function: alicloud:polardb:getNodeClasses
     *       Arguments:
     *         payType: PostPaid
     *         dbType: MySQL
     *         dbVersion: '5.6'
     * outputs:
     *   polardbNodeClasses: ${resources.classes}
     *   polardbAvailableZoneId: ${resources.classes[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNodeClasses.
     * @return A collection of values returned by getNodeClasses.
     */
    public suspend fun getNodeClasses(argument: GetNodeClassesPlainArgs): GetNodeClassesResult =
        getNodeClassesResultToKotlin(getNodeClassesPlain(argument.toJava()).await())

    /**
     * @see [getNodeClasses].
     * @param category The PolarDB node cluster series.
     * @param dbNodeClass The PolarDB node class type by the user.
     * @param dbType Database type. Options are `MySQL`, `PostgreSQL`, `Oracle`. If db_type is set, db_version also needs to be set.
     * @param dbVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/98169.htm) `DBVersion`. If db_version is set, db_type also needs to be set.
     * @param outputFile File name where to save data source results (after running `pulumi up`).
     * @param payType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`.
     * @param regionId The Region to launch the PolarDB cluster.
     * @param zoneId The Zone to launch the PolarDB cluster.
     * @return A collection of values returned by getNodeClasses.
     */
    public suspend fun getNodeClasses(
        category: String? = null,
        dbNodeClass: String? = null,
        dbType: String? = null,
        dbVersion: String? = null,
        outputFile: String? = null,
        payType: String,
        regionId: String? = null,
        zoneId: String? = null,
    ): GetNodeClassesResult {
        val argument = GetNodeClassesPlainArgs(
            category = category,
            dbNodeClass = dbNodeClass,
            dbType = dbType,
            dbVersion = dbVersion,
            outputFile = outputFile,
            payType = payType,
            regionId = regionId,
            zoneId = zoneId,
        )
        return getNodeClassesResultToKotlin(getNodeClassesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNodeClasses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetNodeClassesPlainArgs].
     * @return A collection of values returned by getNodeClasses.
     */
    public suspend fun getNodeClasses(argument: suspend GetNodeClassesPlainArgsBuilder.() -> Unit): GetNodeClassesResult {
        val builder = GetNodeClassesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNodeClassesResultToKotlin(getNodeClassesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the PolarDB Parameter Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.183.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.polardb.getParameterGroups({
     *     dbType: "MySQL",
     *     dbVersion: "8.0",
     * });
     * const ids = _default.then(_default => alicloud.polardb.getParameterGroups({
     *     ids: [_default&#46;groups?&#46;[0]?&#46;id],
     * }));
     * export const polardbParameterGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * const nameRegex = _default.then(_default => alicloud.polardb.getParameterGroups({
     *     nameRegex: _default.groups?.[0]?.parameterGroupName,
     * }));
     * export const polardbParameterGroupId2 = nameRegex.then(nameRegex => nameRegex.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.polardb.get_parameter_groups(db_type="MySQL",
     *     db_version="8.0")
     * ids = alicloud.polardb.get_parameter_groups(ids=[default&#46;groups[0]&#46;id])
     * pulumi.export("polardbParameterGroupId1", ids.groups[0].id)
     * name_regex = alicloud.polardb.get_parameter_groups(name_regex=default.groups[0].parameter_group_name)
     * pulumi.export("polardbParameterGroupId2", name_regex.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.PolarDB.GetParameterGroups.Invoke(new()
     *     {
     *         DbType = "MySQL",
     *         DbVersion = "8.0",
     *     });
     *     var ids = AliCloud.PolarDB.GetParameterGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             @default.Apply(getParameterGroupsResult => getParameterGroupsResult.Groups[0]?.Id),
     *         },
     *     });
     *     var nameRegex = AliCloud.PolarDB.GetParameterGroups.Invoke(new()
     *     {
     *         NameRegex = @default.Apply(getParameterGroupsResult => getParameterGroupsResult.Groups[0]?.ParameterGroupName),
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["polardbParameterGroupId1"] = ids&#46;Apply(getParameterGroupsResult => getParameterGroupsResult&#46;Groups[0]?.Id),
     *         ["polardbParameterGroupId2"] = nameRegex&#46;Apply(getParameterGroupsResult => getParameterGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := polardb.GetParameterGroups(ctx, &polardb.GetParameterGroupsArgs{
     * DbType: pulumi.StringRef("MySQL"),
     * DbVersion: pulumi.StringRef("8.0"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ids, err := polardb.GetParameterGroups(ctx, &polardb.GetParameterGroupsArgs{
     * Ids: interface{}{
     * _default.Groups[0].Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("polardbParameterGroupId1", ids.Groups[0].Id)
     * nameRegex, err := polardb.GetParameterGroups(ctx, &polardb.GetParameterGroupsArgs{
     * NameRegex: pulumi.StringRef(_default.Groups[0].ParameterGroupName),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("polardbParameterGroupId2", nameRegex.Groups[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetParameterGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = PolardbFunctions.getParameterGroups(GetParameterGroupsArgs.builder()
     *             .dbType("MySQL")
     *             .dbVersion("8.0")
     *             .build());
     *         final var ids = PolardbFunctions.getParameterGroups(GetParameterGroupsArgs.builder()
     *             .ids(default_.groups()[0].id())
     *             .build());
     *         ctx.export("polardbParameterGroupId1", ids.applyValue(getParameterGroupsResult -> getParameterGroupsResult.groups()[0].id()));
     *         final var nameRegex = PolardbFunctions.getParameterGroups(GetParameterGroupsArgs.builder()
     *             .nameRegex(default_.groups()[0].parameterGroupName())
     *             .build());
     *         ctx.export("polardbParameterGroupId2", nameRegex.applyValue(getParameterGroupsResult -> getParameterGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:polardb:getParameterGroups
     *       Arguments:
     *         dbType: MySQL
     *         dbVersion: '8.0'
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:polardb:getParameterGroups
     *       Arguments:
     *         ids:
     *           - ${default.groups[0].id}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:polardb:getParameterGroups
     *       Arguments:
     *         nameRegex: ${default.groups[0].parameterGroupName}
     * outputs:
     *   polardbParameterGroupId1: ${ids.groups[0].id}
     *   polardbParameterGroupId2: ${nameRegex.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getParameterGroups.
     * @return A collection of values returned by getParameterGroups.
     */
    public suspend fun getParameterGroups(argument: GetParameterGroupsPlainArgs): GetParameterGroupsResult =
        getParameterGroupsResultToKotlin(getParameterGroupsPlain(argument.toJava()).await())

    /**
     * @see [getParameterGroups].
     * @param dbType The type of the database engine. Only `MySQL` is supported.
     * @param dbVersion The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
     * @param ids A list of Parameter Group IDs.
     * @param nameRegex A regex string to filter results by Parameter Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getParameterGroups.
     */
    public suspend fun getParameterGroups(
        dbType: String? = null,
        dbVersion: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetParameterGroupsResult {
        val argument = GetParameterGroupsPlainArgs(
            dbType = dbType,
            dbVersion = dbVersion,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getParameterGroupsResultToKotlin(getParameterGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getParameterGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetParameterGroupsPlainArgs].
     * @return A collection of values returned by getParameterGroups.
     */
    public suspend fun getParameterGroups(argument: suspend GetParameterGroupsPlainArgsBuilder.() -> Unit): GetParameterGroupsResult {
        val builder = GetParameterGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParameterGroupsResultToKotlin(getParameterGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for PolarDB that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.74.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesIds = alicloud.polardb.getZones({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ids = alicloud.polardb.get_zones()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesIds = AliCloud.PolarDB.GetZones.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/polardb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := polardb.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.polardb.PolardbFunctions;
     * import com.pulumi.alicloud.polardb.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesIds = PolardbFunctions.getZones();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:polardb:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch PolarDB instances.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(multi: Boolean? = null, outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            multi = multi,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;polardb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
