@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.ClusterDbClusterIpArrayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dbClusterIpArrayName The name of the IP whitelist group. The group name must be 2 to 120 characters in length and consists of lowercase letters and digits. It must start with a letter, and end with a letter or a digit.
 * **NOTE:** If the specified whitelist group name does not exist, the whitelist group is created. If the specified whitelist group name exists, the whitelist group is modified. If you do not specify this parameter, the default group is modified. You can create a maximum of 50 IP whitelist groups for a cluster.
 * @property modifyMode The method for modifying the IP whitelist. Valid values are `Cover`, `Append`, `Delete`.
 * **NOTE:** There does not recommend setting modify_mode to `Append` or `Delete` and it will bring a potential diff error.
 * @property securityIps List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 */
public data class ClusterDbClusterIpArrayArgs(
    public val dbClusterIpArrayName: Output<String>? = null,
    public val modifyMode: Output<String>? = null,
    public val securityIps: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.ClusterDbClusterIpArrayArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.ClusterDbClusterIpArrayArgs =
        com.pulumi.alicloud.polardb.inputs.ClusterDbClusterIpArrayArgs.builder()
            .dbClusterIpArrayName(dbClusterIpArrayName?.applyValue({ args0 -> args0 }))
            .modifyMode(modifyMode?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClusterDbClusterIpArrayArgs].
 */
@PulumiTagMarker
public class ClusterDbClusterIpArrayArgsBuilder internal constructor() {
    private var dbClusterIpArrayName: Output<String>? = null

    private var modifyMode: Output<String>? = null

    private var securityIps: Output<List<String>>? = null

    /**
     * @param value The name of the IP whitelist group. The group name must be 2 to 120 characters in length and consists of lowercase letters and digits. It must start with a letter, and end with a letter or a digit.
     * **NOTE:** If the specified whitelist group name does not exist, the whitelist group is created. If the specified whitelist group name exists, the whitelist group is modified. If you do not specify this parameter, the default group is modified. You can create a maximum of 50 IP whitelist groups for a cluster.
     */
    @JvmName("kyodvjvkfakbeupm")
    public suspend fun dbClusterIpArrayName(`value`: Output<String>) {
        this.dbClusterIpArrayName = value
    }

    /**
     * @param value The method for modifying the IP whitelist. Valid values are `Cover`, `Append`, `Delete`.
     * **NOTE:** There does not recommend setting modify_mode to `Append` or `Delete` and it will bring a potential diff error.
     */
    @JvmName("ttyyiqsbtefyveai")
    public suspend fun modifyMode(`value`: Output<String>) {
        this.modifyMode = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("miearacuknyeebyn")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("oahsoigrtnaashww")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("bmjqtusyhvmiixny")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value The name of the IP whitelist group. The group name must be 2 to 120 characters in length and consists of lowercase letters and digits. It must start with a letter, and end with a letter or a digit.
     * **NOTE:** If the specified whitelist group name does not exist, the whitelist group is created. If the specified whitelist group name exists, the whitelist group is modified. If you do not specify this parameter, the default group is modified. You can create a maximum of 50 IP whitelist groups for a cluster.
     */
    @JvmName("accjogprtrfckneq")
    public suspend fun dbClusterIpArrayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIpArrayName = mapped
    }

    /**
     * @param value The method for modifying the IP whitelist. Valid values are `Cover`, `Append`, `Delete`.
     * **NOTE:** There does not recommend setting modify_mode to `Append` or `Delete` and it will bring a potential diff error.
     */
    @JvmName("jfdfdtmsvmevrpaq")
    public suspend fun modifyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyMode = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("xjltmiqpdwxtlxfi")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("bfxfamwamwcdnsyj")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    internal fun build(): ClusterDbClusterIpArrayArgs = ClusterDbClusterIpArrayArgs(
        dbClusterIpArrayName = dbClusterIpArrayName,
        modifyMode = modifyMode,
        securityIps = securityIps,
    )
}
