@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.ClusterParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Kernel parameter name.
 * @property value Kernel parameter value.
 */
public data class ClusterParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.ClusterParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.ClusterParameterArgs =
        com.pulumi.alicloud.polardb.inputs.ClusterParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterParameterArgs].
 */
@PulumiTagMarker
public class ClusterParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Kernel parameter name.
     */
    @JvmName("bweincyysekcxwnf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Kernel parameter value.
     */
    @JvmName("syrbxidoxxxkditc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Kernel parameter name.
     */
    @JvmName("xsuemwdiunivhteb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Kernel parameter value.
     */
    @JvmName("pelkdaldqfcbgpxo")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ClusterParameterArgs = ClusterParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
