@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.GetAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccounts.
 * @property dbClusterId The polarDB cluster ID.
 * @property nameRegex A regex string to filter results by account name.
 */
public data class GetAccountsPlainArgs(
    public val dbClusterId: String,
    public val nameRegex: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.GetAccountsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.GetAccountsPlainArgs =
        com.pulumi.alicloud.polardb.inputs.GetAccountsPlainArgs.builder()
            .dbClusterId(dbClusterId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetAccountsPlainArgsBuilder internal constructor() {
    private var dbClusterId: String? = null

    private var nameRegex: String? = null

    /**
     * @param value The polarDB cluster ID.
     */
    @JvmName("lagqiwgpdbitciya")
    public suspend fun dbClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbClusterId = mapped
    }

    /**
     * @param value A regex string to filter results by account name.
     */
    @JvmName("kfjbqansnvprkqvq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    internal fun build(): GetAccountsPlainArgs = GetAccountsPlainArgs(
        dbClusterId = dbClusterId ?: throw PulumiNullFieldException("dbClusterId"),
        nameRegex = nameRegex,
    )
}
