@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.GetDatabasesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDatabases.
 * @property dbClusterId The polarDB cluster ID.
 * @property nameRegex A regex string to filter results by database name.
 */
public data class GetDatabasesPlainArgs(
    public val dbClusterId: String,
    public val nameRegex: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.GetDatabasesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.GetDatabasesPlainArgs =
        com.pulumi.alicloud.polardb.inputs.GetDatabasesPlainArgs.builder()
            .dbClusterId(dbClusterId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabasesPlainArgs].
 */
@PulumiTagMarker
public class GetDatabasesPlainArgsBuilder internal constructor() {
    private var dbClusterId: String? = null

    private var nameRegex: String? = null

    /**
     * @param value The polarDB cluster ID.
     */
    @JvmName("glecdupuxcioomfp")
    public suspend fun dbClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbClusterId = mapped
    }

    /**
     * @param value A regex string to filter results by database name.
     */
    @JvmName("vauaxntlwbwbunoi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    internal fun build(): GetDatabasesPlainArgs = GetDatabasesPlainArgs(
        dbClusterId = dbClusterId ?: throw PulumiNullFieldException("dbClusterId"),
        nameRegex = nameRegex,
    )
}
