@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.GetEndpointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEndpoints.
 * @property dbClusterId PolarDB cluster ID.
 * @property dbEndpointId endpoint of the cluster.
 */
public data class GetEndpointsPlainArgs(
    public val dbClusterId: String,
    public val dbEndpointId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.GetEndpointsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.GetEndpointsPlainArgs =
        com.pulumi.alicloud.polardb.inputs.GetEndpointsPlainArgs.builder()
            .dbClusterId(dbClusterId.let({ args0 -> args0 }))
            .dbEndpointId(dbEndpointId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEndpointsPlainArgs].
 */
@PulumiTagMarker
public class GetEndpointsPlainArgsBuilder internal constructor() {
    private var dbClusterId: String? = null

    private var dbEndpointId: String? = null

    /**
     * @param value PolarDB cluster ID.
     */
    @JvmName("telumwcxnqgculik")
    public suspend fun dbClusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbClusterId = mapped
    }

    /**
     * @param value endpoint of the cluster.
     */
    @JvmName("ycrkctxowvpemgtq")
    public suspend fun dbEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbEndpointId = mapped
    }

    internal fun build(): GetEndpointsPlainArgs = GetEndpointsPlainArgs(
        dbClusterId = dbClusterId ?: throw PulumiNullFieldException("dbClusterId"),
        dbEndpointId = dbEndpointId,
    )
}
