@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.GetGlobalDatabaseNetworksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGlobalDatabaseNetworks.
 * @property dbClusterId The ID of the cluster.
 * @property description The description of the Global Database Network.
 * @property gdnId The ID of the Global Database Network.
 * @property ids A list of Global Database Network IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the Global Database Network. Valid values:
 */
public data class GetGlobalDatabaseNetworksPlainArgs(
    public val dbClusterId: String? = null,
    public val description: String? = null,
    public val gdnId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.GetGlobalDatabaseNetworksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.GetGlobalDatabaseNetworksPlainArgs =
        com.pulumi.alicloud.polardb.inputs.GetGlobalDatabaseNetworksPlainArgs.builder()
            .dbClusterId(dbClusterId?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .gdnId(gdnId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalDatabaseNetworksPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalDatabaseNetworksPlainArgsBuilder internal constructor() {
    private var dbClusterId: String? = null

    private var description: String? = null

    private var gdnId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value The ID of the cluster.
     */
    @JvmName("fbtlxidceqtwlbxu")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbClusterId = mapped
    }

    /**
     * @param value The description of the Global Database Network.
     */
    @JvmName("yebhybbqsnqbbjev")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value The ID of the Global Database Network.
     */
    @JvmName("ombrwctwxqlgstkb")
    public suspend fun gdnId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gdnId = mapped
    }

    /**
     * @param value A list of Global Database Network IDs.
     */
    @JvmName("dmqlqxjmgeybqohm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Global Database Network IDs.
     */
    @JvmName("yjwoymaadqyccafq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("taspicxnalyabinj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("kfopjqhoxrucbkwo")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("jgkpammtpqmjnmul")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the Global Database Network. Valid values:
     */
    @JvmName("ckckhkkhdecxjfog")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetGlobalDatabaseNetworksPlainArgs = GetGlobalDatabaseNetworksPlainArgs(
        dbClusterId = dbClusterId,
        description = description,
        gdnId = gdnId,
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
    )
}
