@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.GetNodeClassesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNodeClasses.
 * @property category The PolarDB node cluster series.
 * @property dbNodeClass The PolarDB node class type by the user.
 * @property dbType Database type. Options are `MySQL`, `PostgreSQL`, `Oracle`. If db_type is set, db_version also needs to be set.
 * @property dbVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/98169.htm) `DBVersion`. If db_version is set, db_type also needs to be set.
 * @property outputFile File name where to save data source results (after running `pulumi up`).
 * @property payType Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`.
 * @property regionId The Region to launch the PolarDB cluster.
 * @property zoneId The Zone to launch the PolarDB cluster.
 */
public data class GetNodeClassesPlainArgs(
    public val category: String? = null,
    public val dbNodeClass: String? = null,
    public val dbType: String? = null,
    public val dbVersion: String? = null,
    public val outputFile: String? = null,
    public val payType: String,
    public val regionId: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.GetNodeClassesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.GetNodeClassesPlainArgs =
        com.pulumi.alicloud.polardb.inputs.GetNodeClassesPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .dbNodeClass(dbNodeClass?.let({ args0 -> args0 }))
            .dbType(dbType?.let({ args0 -> args0 }))
            .dbVersion(dbVersion?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .payType(payType.let({ args0 -> args0 }))
            .regionId(regionId?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNodeClassesPlainArgs].
 */
@PulumiTagMarker
public class GetNodeClassesPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var dbNodeClass: String? = null

    private var dbType: String? = null

    private var dbVersion: String? = null

    private var outputFile: String? = null

    private var payType: String? = null

    private var regionId: String? = null

    private var zoneId: String? = null

    /**
     * @param value The PolarDB node cluster series.
     */
    @JvmName("iclahvyvqchpkwqb")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value The PolarDB node class type by the user.
     */
    @JvmName("uiivkgmmryvqxcbv")
    public suspend fun dbNodeClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbNodeClass = mapped
    }

    /**
     * @param value Database type. Options are `MySQL`, `PostgreSQL`, `Oracle`. If db_type is set, db_version also needs to be set.
     */
    @JvmName("kisttcgeyicskqaa")
    public suspend fun dbType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbType = mapped
    }

    /**
     * @param value Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/98169.htm) `DBVersion`. If db_version is set, db_type also needs to be set.
     */
    @JvmName("oxdyhvwloiqmrjoo")
    public suspend fun dbVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbVersion = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi up`).
     */
    @JvmName("lytfpryurteccajn")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter the results by charge type. Valid values: `PrePaid` and `PostPaid`.
     */
    @JvmName("ecebhwolqhnluina")
    public suspend fun payType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.payType = mapped
    }

    /**
     * @param value The Region to launch the PolarDB cluster.
     */
    @JvmName("tjagpefbfkqxtcmj")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regionId = mapped
    }

    /**
     * @param value The Zone to launch the PolarDB cluster.
     */
    @JvmName("ouxrtonfkcngyukh")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetNodeClassesPlainArgs = GetNodeClassesPlainArgs(
        category = category,
        dbNodeClass = dbNodeClass,
        dbType = dbType,
        dbVersion = dbVersion,
        outputFile = outputFile,
        payType = payType ?: throw PulumiNullFieldException("payType"),
        regionId = regionId,
        zoneId = zoneId,
    )
}
