@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.GetParameterGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getParameterGroups.
 * @property dbType The type of the database engine. Only `MySQL` is supported.
 * @property dbVersion The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
 * @property ids A list of Parameter Group IDs.
 * @property nameRegex A regex string to filter results by Parameter Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetParameterGroupsPlainArgs(
    public val dbType: String? = null,
    public val dbVersion: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.GetParameterGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.GetParameterGroupsPlainArgs =
        com.pulumi.alicloud.polardb.inputs.GetParameterGroupsPlainArgs.builder()
            .dbType(dbType?.let({ args0 -> args0 }))
            .dbVersion(dbVersion?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetParameterGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetParameterGroupsPlainArgsBuilder internal constructor() {
    private var dbType: String? = null

    private var dbVersion: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The type of the database engine. Only `MySQL` is supported.
     */
    @JvmName("ulfdqjsvmvojytxi")
    public suspend fun dbType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbType = mapped
    }

    /**
     * @param value The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
     */
    @JvmName("penrntgrbwwvpraj")
    public suspend fun dbVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbVersion = mapped
    }

    /**
     * @param value A list of Parameter Group IDs.
     */
    @JvmName("gekswiwrygurcnyj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Parameter Group IDs.
     */
    @JvmName("pfhkgheiprrjyfpj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Parameter Group name.
     */
    @JvmName("abixwbexvxowlfei")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xdpumiweajwhrwlq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetParameterGroupsPlainArgs = GetParameterGroupsPlainArgs(
        dbType = dbType,
        dbVersion = dbVersion,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
