@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.inputs

import com.pulumi.alicloud.polardb.inputs.ParameterGroupParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property paramName The name of a parameter in the parameter template.
 * @property paramValue The value of a parameter in the parameter template.
 */
public data class ParameterGroupParameterArgs(
    public val paramName: Output<String>,
    public val paramValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.polardb.inputs.ParameterGroupParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.polardb.inputs.ParameterGroupParameterArgs =
        com.pulumi.alicloud.polardb.inputs.ParameterGroupParameterArgs.builder()
            .paramName(paramName.applyValue({ args0 -> args0 }))
            .paramValue(paramValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterGroupParameterArgs].
 */
@PulumiTagMarker
public class ParameterGroupParameterArgsBuilder internal constructor() {
    private var paramName: Output<String>? = null

    private var paramValue: Output<String>? = null

    /**
     * @param value The name of a parameter in the parameter template.
     */
    @JvmName("tvkwkjbtsowlafxp")
    public suspend fun paramName(`value`: Output<String>) {
        this.paramName = value
    }

    /**
     * @param value The value of a parameter in the parameter template.
     */
    @JvmName("lgibrismynvufxdj")
    public suspend fun paramValue(`value`: Output<String>) {
        this.paramValue = value
    }

    /**
     * @param value The name of a parameter in the parameter template.
     */
    @JvmName("vjyqmrxnrpkxgpkj")
    public suspend fun paramName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramName = mapped
    }

    /**
     * @param value The value of a parameter in the parameter template.
     */
    @JvmName("fkjrgtxghpyfytoa")
    public suspend fun paramValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paramValue = mapped
    }

    internal fun build(): ParameterGroupParameterArgs = ParameterGroupParameterArgs(
        paramName = paramName ?: throw PulumiNullFieldException("paramName"),
        paramValue = paramValue ?: throw PulumiNullFieldException("paramValue"),
    )
}
