@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dbClusterIpArrayName The name of the IP whitelist group. The group name must be 2 to 120 characters in length and consists of lowercase letters and digits. It must start with a letter, and end with a letter or a digit.
 * **NOTE:** If the specified whitelist group name does not exist, the whitelist group is created. If the specified whitelist group name exists, the whitelist group is modified. If you do not specify this parameter, the default group is modified. You can create a maximum of 50 IP whitelist groups for a cluster.
 * @property modifyMode The method for modifying the IP whitelist. Valid values are `Cover`, `Append`, `Delete`.
 * **NOTE:** There does not recommend setting modify_mode to `Append` or `Delete` and it will bring a potential diff error.
 * @property securityIps List of IP addresses allowed to access all databases of a cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 */
public data class ClusterDbClusterIpArray(
    public val dbClusterIpArrayName: String? = null,
    public val modifyMode: String? = null,
    public val securityIps: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.ClusterDbClusterIpArray): ClusterDbClusterIpArray = ClusterDbClusterIpArray(
            dbClusterIpArrayName = javaType.dbClusterIpArrayName().map({ args0 -> args0 }).orElse(null),
            modifyMode = javaType.modifyMode().map({ args0 -> args0 }).orElse(null),
            securityIps = javaType.securityIps().map({ args0 -> args0 }),
        )
    }
}
